/*
 * Decompiled with CFR 0.152.
 */
package res;

import gui.form.AboutBox;
import gui.form.FormAssistent;
import gui.form.FormOptionen;
import gui.form.FormProxyConf;
import gui.form.FormStartAssistent;
import gui.form.InfoBox;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.jdom.JDOMException;
import res.Config;
import res.LicFile;
import res.NormFile;
import res.WebService;

public class Control {
    public static void beenden(int Status, Config CONFIG) {
        CONFIG.save();
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        Date currentTime = new Date();
        Control.addLog(CONFIG, "Beende Applikation", "", new String[]{formatter.format(currentTime), String.valueOf(Status)});
        System.exit(Status);
    }

    public static void ShowFormProxyConf(Config CONFIG) {
        FormProxyConf form = new FormProxyConf(CONFIG);
        form.setVisible(true);
    }

    public static void ShowFormOptionen(Config CONFIG) {
        FormOptionen form = new FormOptionen(CONFIG);
        form.setVisible(true);
    }

    public static void ShowFormStartAssistent(Config CONFIG) {
        CONFIG.setShowStartAssistentDialog(false);
        FormStartAssistent form = new FormStartAssistent(CONFIG);
        form.setVisible(true);
    }

    public static void ShowFormNewUser(Config CONFIG) {
        if (Control.checkOnline(CONFIG, CONFIG.getText("User_new_msg_go_online"))) {
            FormAssistent form = new FormAssistent(CONFIG);
            form.setVisible(true);
            form.showNewUser();
        }
    }

    public static void ShowFormEditUser(Config CONFIG) {
        if (Control.checkOnline(CONFIG, CONFIG.getText("User_edit_msg_go_online"))) {
            FormAssistent form = new FormAssistent(CONFIG);
            form.setVisible(true);
            form.showEditUser();
        }
    }

    public static void ShowFormLogin(Config CONFIG) {
        CONFIG.setUserLoggedIn(false);
        CONFIG.getCurrentGUI().update();
        FormAssistent form = new FormAssistent(CONFIG);
        form.setVisible(true);
        form.showLogin();
    }

    public static void ShowFormLizenzierungsAssistent(Config CONFIG) {
        FormAssistent form = new FormAssistent(CONFIG);
        form.setVisible(true);
        form.showLicAssistent();
    }

    public static void ShowFormSync(Config CONFIG) {
        FormAssistent form = new FormAssistent(CONFIG);
        form.setVisible(true);
        form.showSync();
    }

    public static void ShowFormLizenzInfo(Config CONFIG) {
        InfoBox form = new InfoBox(CONFIG);
        form.setVisible(true);
    }

    public static void ShowFormDeviceIDs(Config CONFIG, String Benutzer, String Passwort) {
        FormAssistent form = new FormAssistent(CONFIG);
        form.setVisible(true);
        form.showDeviceIDs(Benutzer, Passwort);
    }

    public static void ShowAboutBox(Config CONFIG) {
        AboutBox aboutbox = new AboutBox(CONFIG);
        aboutbox.setVisible(true);
    }

    public static void ShowHelp(Config CONFIG) {
        boolean showmessage = false;
        File f = new File(CONFIG.getHelpFilePath(CONFIG.getDatenpfad_zentral(), CONFIG.getSprache()));
        if (!f.exists()) {
            f = new File(CONFIG.getHelpFilePath(CONFIG.getDatenpfad_stammdaten(), CONFIG.getSprache()));
            showmessage = false;
        } else {
            showmessage = true;
        }
        if (!f.exists()) {
            f = new File(CONFIG.getHelpFilePath(String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator"), CONFIG.getSprache()));
            showmessage = false;
        } else {
            showmessage = true;
        }
        if (f.exists()) {
            CONFIG.getCurrentGUI().openPDF(f.getAbsolutePath());
            showmessage = false;
        } else {
            showmessage = true;
        }
        if (showmessage) {
            Control.showInfoMessage(CONFIG, CONFIG.getText("msg_nohelpfile"));
        }
    }

    public static void openWebShop(Config conf) {
        Control.goToURL("http://" + conf.getSoap_server());
    }

    public static void goToURL(String url) {
        Desktop desktop = null;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            URI uri = null;
            try {
                uri = new URI(url);
                desktop.browse(uri);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (URISyntaxException use) {
                use.printStackTrace();
            }
        }
    }

    public static void addNormFile(Config CONFIG) {
        JFileChooser fc = new JFileChooser(CONFIG.getOpendir());
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".srd");
            }

            public String getDescription() {
                return "SecureReader-Datei (*.srd)";
            }
        });
        fc.setMultiSelectionEnabled(true);
        int res = fc.showOpenDialog(CONFIG.getMasterFrame());
        if (res == 0) {
            CONFIG.setOpendir(fc.getSelectedFiles()[0].getAbsolutePath());
            File normdat = null;
            String[] meldung = new String[fc.getSelectedFiles().length];
            int i = 0;
            while (i < fc.getSelectedFiles().length) {
                normdat = fc.getSelectedFiles()[i];
                if (normdat.exists()) {
                    NormFile nf = new NormFile(normdat.getAbsolutePath());
                    try {
                        if (nf.open(CONFIG.getLICFILE().getSwitch_Name(), CONFIG.getLICFILE().getSRD_KEY(), CONFIG.getLICFILE().getSRD_IV())) {
                            File f = new File(CONFIG.getDatenpfad_lokal());
                            if (!f.exists()) {
                                f.mkdirs();
                            }
                            nf.saveTo(CONFIG.getDatenpfad_lokal());
                            meldung[i] = String.valueOf(normdat.getName()) + " -> " + CONFIG.getText("msg_NormFileAdded");
                        } else {
                            meldung[i] = String.valueOf(normdat.getName()) + " -> " + CONFIG.getText("msg_err_noNormFile") + " (Code: NFWPS)";
                        }
                    }
                    catch (ZipException e1) {
                        Control.addLog(CONFIG, "Fehler beim Norm \u00f6ffnen", "ZipException", new String[]{nf.getID(), nf.getBezeichnung(), "filesystem", e1.getMessage()});
                        meldung[i] = String.valueOf(normdat.getName()) + " -> " + CONFIG.getText("msg_err_noNormFile") + " (Code: NFNZF)";
                    }
                    catch (IOException e1) {
                        Control.addLog(CONFIG, "Fehler beim Norm \u00f6ffnen", "IOException", new String[]{nf.getID(), nf.getBezeichnung(), "filesystem", e1.getMessage()});
                    }
                    catch (JDOMException e1) {
                        Control.addLog(CONFIG, "Fehler beim Norm \u00f6ffnen", "JDOMException", new String[]{nf.getID(), nf.getBezeichnung(), "filesystem", e1.getMessage()});
                        meldung[i] = String.valueOf(normdat.getName()) + " -> " + CONFIG.getText("msg_err_noNormFile") + " (Code: NFXML)";
                    }
                }
                ++i;
            }
            String me = "";
            int c = 0;
            while (c < meldung.length) {
                me = String.valueOf(me) + meldung[c] + "\n";
                ++c;
            }
            JOptionPane.showMessageDialog(CONFIG.getMasterFrame(), me, CONFIG.getText("msg_info"), 1);
        }
    }

    public static boolean downloadLicFile(Config CONFIG, String Benutzer, String Passwort) {
        WebService ws = new WebService(CONFIG);
        if (!ws.echo().equals("ERROR")) {
            try {
                String[] res = ws.getLizenzdatei(Benutzer, Passwort, CONFIG.getPID());
                if (res[0].equals("NOERROR")) {
                    return Control.openLicFile(CONFIG, res[1], Benutzer, Passwort);
                }
                if (res[0].equals("Fail_NO_User") || res[0].equals("Fail_Wrong_PWD") || res[0].equals("Unkown_Device_ID")) {
                    Control.showInfoMessage(CONFIG, CONFIG.getText("msg_err_Fail_NO_User_or_Fail_Wrong_PWD"));
                    CONFIG.getCurrentGUI().hideReader();
                    Control.ShowFormLogin(CONFIG);
                }
                if (res[0].equals("Account_disabled")) {
                    Control.showInfoMessage(CONFIG, CONFIG.getText("msg_err_Account_disabled"));
                }
                if (res[0].equals("Account_deleted")) {
                    Control.showInfoMessage(CONFIG, CONFIG.getText("msg_err_Account_deleted"));
                }
                if (res[0].equals("Max_allowed_Device_IDs")) {
                    Control.ShowFormDeviceIDs(CONFIG, Benutzer, Passwort);
                }
                Control.showInfoMessage(CONFIG, String.valueOf(CONFIG.getText("msg_err_unbekannt")) + "\n" + res[0] + "\n" + res[1] + "\n(WS: getLizenzdatei)");
            }
            catch (IOException e1) {
                return false;
            }
            catch (JDOMException e1) {
                return false;
            }
        } else {
            Control.showErrorMessage(CONFIG, String.valueOf(CONFIG.getText("msg_err_noWSECHO")) + "\nServer: " + CONFIG.getSoap_server());
        }
        return false;
    }

    public static boolean openLicFile(Config CONFIG, String file, String user, String pw) {
        if (file.equals("")) {
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".srl");
                }

                public String getDescription() {
                    return "SecureReader-Lizenz (*.srl)";
                }
            });
            int res = fc.showOpenDialog(CONFIG.getMasterFrame());
            if (res == 0) {
                file = fc.getSelectedFile().getAbsolutePath();
            } else {
                return false;
            }
        }
        try {
            LicFile lf = new LicFile(file, CONFIG);
            if (lf.open()) {
                if (lf.checkBenutzer(user, pw)) {
                    try {
                        lf.saveTo(CONFIG.getLicFilePath());
                        return CONFIG.getCurrentGUI().openLicFile(CONFIG.getLicFilePath());
                    }
                    catch (IOException e1) {
                        Control.showErrorMessage(CONFIG, CONFIG.getText("msg_err_save_LicFile"));
                    }
                } else {
                    Control.showErrorMessage(CONFIG, CONFIG.getText("msg_err_Fail_NO_User_or_Fail_Wrong_PWD"));
                }
            } else {
                Control.showErrorMessage(CONFIG, String.valueOf(CONFIG.getText("msg_err_no_LicFile")) + "\nERRORCODE: LFWPS");
            }
        }
        catch (ZipException e1) {
            Control.showErrorMessage(CONFIG, String.valueOf(CONFIG.getText("msg_err_no_LicFile")) + "\nERRORCODE: LFNZF");
        }
        catch (IOException e1) {
            Control.showErrorMessage(CONFIG, String.valueOf(CONFIG.getText("msg_err_no_LicFile")) + "\nERRORCODE: LFIO");
        }
        catch (JDOMException e1) {
            Control.showErrorMessage(CONFIG, String.valueOf(CONFIG.getText("msg_err_no_LicFile")) + "\nERRORCODE: LFNXML");
            System.out.println(e1.getMessage());
        }
        return false;
    }

    public static void addLog(Config CONFIG, String Eventbezeichnung, String Eventbeschreibung, String[] dynData) {
        if (CONFIG.isOnline() && CONFIG.doEventlog()) {
            WebService wslog = new WebService(CONFIG);
            wslog.addEvent(Eventbezeichnung, Eventbeschreibung, dynData);
        }
    }

    public static void showErrorMessage(Config CONFIG, String Text2) {
        JOptionPane.showMessageDialog(CONFIG.getMasterFrame(), Text2, CONFIG.getText("msg_error"), 0);
    }

    public static void showInfoMessage(Config CONFIG, String Text2) {
        JOptionPane.showMessageDialog(CONFIG.getMasterFrame(), Text2, CONFIG.getText("msg_info"), 1);
    }

    public static boolean checkOnline(Config CONFIG, String frage) {
        if (CONFIG.isOnline()) {
            return CONFIG.isOnline();
        }
        int antwort = JOptionPane.showConfirmDialog(null, frage, CONFIG.getText("msg_info"), 1);
        if (antwort == 0) {
            CONFIG.setOnline("1");
            return true;
        }
        return false;
    }

    public static void resetLizenz(Config CONFIG, boolean delete_data) {
        String message = CONFIG.getText("msg_reset_lizenz");
        int antwort = JOptionPane.showConfirmDialog(null, message = message.replace("KD-Nummer", CONFIG.getLICFILE().getKundennummer()), CONFIG.getText("msg_title_reset_lizenz"), 1);
        if (antwort == 0) {
            WebService ws = new WebService(CONFIG);
            ws.deleteMyDevice_ID(CONFIG.getLICFILE().getKundennummer(), CONFIG.getLICFILE().getPasswort(), CONFIG.getPID());
            File file = new File(CONFIG.getLicFilePath());
            file.delete();
            file = new File(String.valueOf(CONFIG.getUserDataDir()) + ".pid");
            file.delete();
            Control.beenden(0, CONFIG);
        }
    }

    public static void resetDokumente(Config CONFIG) {
        String message = CONFIG.getText("msg_reset_dokumente");
        int antwort = JOptionPane.showConfirmDialog(null, message = message.replace("PATH", CONFIG.getDatenpfad_lokal()), CONFIG.getText("msg_question"), 1);
        if (antwort == 0) {
            File dir = new File(CONFIG.getDatenpfad_lokal());
            Control.deleteFolder(dir);
            dir.mkdir();
            CONFIG.getCurrentGUI().openLicFile(CONFIG.getLicFilePath());
        }
    }

    public static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isDirectory()) {
                    Control.deleteFolder(file);
                } else {
                    file.delete();
                }
                ++i;
            }
        }
        folder.delete();
    }
}

