/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.utils;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertiesFile {
    private String separator = System.getProperty("file.separator");
    private String userDir = System.getProperty("user.dir");
    private String configFile = String.valueOf(this.userDir) + this.separator + ".properties.xml";
    private Document doc;
    private int noOfRecentDocs = 6;

    public PropertiesFile() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (new File(this.configFile).exists()) {
                try {
                    this.doc = db.parse(this.configFile);
                }
                catch (Exception e) {
                    this.doc = db.newDocument();
                }
            } else {
                this.doc = db.newDocument();
            }
            this.checkAllElementsPresent();
            this.writeDoc();
        }
        catch (Exception e) {
            LogWriter.writeLog((String)("Exception " + e + " generating properties file"));
        }
    }

    public String[] getRecentDocuments() {
        String[] recentDocuments = new String[this.noOfRecentDocs];
        try {
            NodeList nl = this.doc.getElementsByTagName("recentfiles");
            ArrayList<String> fileNames = new ArrayList<String>();
            if (nl != null && nl.getLength() > 0) {
                NodeList allRecentDocs = ((Element)nl.item(0)).getElementsByTagName("*");
                int i = 0;
                while (i < allRecentDocs.getLength()) {
                    Node item = allRecentDocs.item(i);
                    NamedNodeMap attrs = item.getAttributes();
                    fileNames.add(attrs.getNamedItem("name").getNodeValue());
                    ++i;
                }
            }
            while (fileNames.size() > this.noOfRecentDocs) {
                fileNames.remove(0);
            }
            Collections.reverse(fileNames);
            recentDocuments = fileNames.toArray(new String[this.noOfRecentDocs]);
        }
        catch (Exception e) {
            LogWriter.writeLog((String)("Exception " + e + " getting recent documents"));
            return null;
        }
        return recentDocuments;
    }

    public void addRecentDocument(String file) {
        try {
            Element recentElement = (Element)this.doc.getElementsByTagName("recentfiles").item(0);
            this.checkExists(file, recentElement);
            Element elementToAdd = this.doc.createElement("file");
            elementToAdd.setAttribute("name", file);
            recentElement.appendChild(elementToAdd);
            this.removeOldFiles(recentElement);
            this.writeDoc();
        }
        catch (Exception e) {
            LogWriter.writeLog((String)("Exception " + e + " adding recent document to properties file"));
        }
    }

    public void setValue(String elementName, String newValue) {
        try {
            NodeList nl = this.doc.getElementsByTagName(elementName);
            Element element = (Element)nl.item(0);
            element.setAttribute("value", newValue);
            this.writeDoc();
        }
        catch (Exception e) {
            LogWriter.writeLog((String)("Exception " + e + " setting value in properties file"));
        }
    }

    public String getValue(String elementName) {
        Element element;
        NamedNodeMap attrs;
        block3: {
            attrs = null;
            try {
                NodeList nl = this.doc.getElementsByTagName(elementName);
                element = (Element)nl.item(0);
                if (element != null) break block3;
                return "";
            }
            catch (Exception e) {
                LogWriter.writeLog((String)("Exception " + e + " generating properties file"));
                return "";
            }
        }
        attrs = element.getAttributes();
        return attrs.getNamedItem("value").getNodeValue();
    }

    private void removeOldFiles(Element recentElement) throws Exception {
        NodeList allRecentDocs = recentElement.getElementsByTagName("*");
        while (allRecentDocs.getLength() > this.noOfRecentDocs) {
            recentElement.removeChild(allRecentDocs.item(0));
        }
    }

    private void checkExists(String file, Element recentElement) throws Exception {
        NodeList allRecentDocs = recentElement.getElementsByTagName("*");
        int i = 0;
        while (i < allRecentDocs.getLength()) {
            Node item = allRecentDocs.item(i);
            NamedNodeMap attrs = item.getAttributes();
            String value = attrs.getNamedItem("name").getNodeValue();
            if (value.equals(file)) {
                recentElement.removeChild(item);
            }
            ++i;
        }
    }

    private void writeDoc() throws Exception {
        InputStream stylesheet = this.getClass().getResourceAsStream("/org/jpedal/examples/simpleviewer/res/xmlstyle.xslt");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(stylesheet));
        transformer.transform(new DOMSource(this.doc), new StreamResult(this.configFile));
    }

    private void checkAllElementsPresent() throws Exception {
        Element showDDMessage;
        Element showFormsSaveMessage;
        NodeList allElements = this.doc.getElementsByTagName("*");
        ArrayList<String> elementsInTree = new ArrayList<String>(allElements.getLength());
        int i = 0;
        while (i < allElements.getLength()) {
            elementsInTree.add(allElements.item(i).getNodeName());
            ++i;
        }
        Element propertiesElement = null;
        if (elementsInTree.contains("properties")) {
            propertiesElement = (Element)this.doc.getElementsByTagName("properties").item(0);
        } else {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.newDocument();
            propertiesElement = this.doc.createElement("properties");
            this.doc.appendChild(propertiesElement);
            allElements = this.doc.getElementsByTagName("*");
            elementsInTree = new ArrayList(allElements.getLength());
            int i2 = 0;
            while (i2 < allElements.getLength()) {
                elementsInTree.add(allElements.item(i2).getNodeName());
                ++i2;
            }
        }
        if (!elementsInTree.contains("recentfiles")) {
            Element recent = this.doc.createElement("recentfiles");
            propertiesElement.appendChild(recent);
        }
        if (!elementsInTree.contains("showfirsttimepopup")) {
            showFormsSaveMessage = this.doc.createElement("showfirsttimepopup");
            showFormsSaveMessage.setAttribute("value", "true");
            propertiesElement.appendChild(showFormsSaveMessage);
        }
        if (!elementsInTree.contains("showsaveformsmessage")) {
            showFormsSaveMessage = this.doc.createElement("showsaveformsmessage");
            showFormsSaveMessage.setAttribute("value", "true");
            propertiesElement.appendChild(showFormsSaveMessage);
        }
        if (!elementsInTree.contains("showitextmessage")) {
            Element showItextMessage = this.doc.createElement("showitextmessage");
            showItextMessage.setAttribute("value", "true");
            propertiesElement.appendChild(showItextMessage);
        }
        if (!elementsInTree.contains("showddmessage")) {
            showDDMessage = this.doc.createElement("showddmessage");
            showDDMessage.setAttribute("value", "true");
            propertiesElement.appendChild(showDDMessage);
        }
        if (!elementsInTree.contains("searchWindowType")) {
            showDDMessage = this.doc.createElement("searchWindowType");
            showDDMessage.setAttribute("value", "0");
            propertiesElement.appendChild(showDDMessage);
        }
        if (!elementsInTree.contains("borderType")) {
            showDDMessage = this.doc.createElement("borderType");
            showDDMessage.setAttribute("value", "1");
            propertiesElement.appendChild(showDDMessage);
        }
        if (!elementsInTree.contains("DPI")) {
            showDDMessage = this.doc.createElement("DPI");
            showDDMessage.setAttribute("value", "96");
            propertiesElement.appendChild(showDDMessage);
        }
        if (!elementsInTree.contains("autoScroll")) {
            showDDMessage = this.doc.createElement("autoScroll");
            showDDMessage.setAttribute("value", "true");
            propertiesElement.appendChild(showDDMessage);
        }
        if (!elementsInTree.contains("pageMode")) {
            showDDMessage = this.doc.createElement("pageMode");
            showDDMessage.setAttribute("value", String.valueOf(1));
            propertiesElement.appendChild(showDDMessage);
        }
        if (!elementsInTree.contains("displaytipsonstartup")) {
            showDDMessage = this.doc.createElement("displaytipsonstartup");
            showDDMessage.setAttribute("value", "true");
            propertiesElement.appendChild(showDDMessage);
        }
        if (!elementsInTree.contains("automaticupdate")) {
            showDDMessage = this.doc.createElement("automaticupdate");
            showDDMessage.setAttribute("value", "true");
            propertiesElement.appendChild(showDDMessage);
        }
        if (!elementsInTree.contains("currentversion")) {
            showDDMessage = this.doc.createElement("currentversion");
            showDDMessage.setAttribute("value", "");
            propertiesElement.appendChild(showDDMessage);
        }
        if (!elementsInTree.contains("showtiffmessage")) {
            showDDMessage = this.doc.createElement("showtiffmessage");
            showDDMessage.setAttribute("value", "true");
            propertiesElement.appendChild(showDDMessage);
        }
    }

    public int getNoRecentDocumentsToDisplay() {
        return this.noOfRecentDocs;
    }
}

