/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.utils;

import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import res.Config;
import res.Control;
import res.obj.redPrinter_Blacklist;

public class Printer {
    private static int printingThreads = 0;
    int rangeStart = 1;
    int rangeEnd = 1;
    int subset = 8;
    JComboBox scaling = null;
    boolean wasCancelled = false;
    boolean messageShown = false;
    boolean pagesReversed = false;
    Timer updatePrinterProgress = null;
    private ProgressMonitor status = null;
    private String printText = "";
    private Config CONFIG;
    private String dots = ".";
    private int balken = 50;

    public void printPDF(final PdfDecoder decode_pdf, final GUIFactory currentGUI, String printtext) {
        ++printingThreads;
        this.printText = printtext;
        Thread worker = new Thread(){

            public void run() {
                boolean printFile;
                block31: {
                    if (Printer.this.CONFIG.disableProxyOnPrint() && Printer.this.CONFIG.isProxy_active()) {
                        System.out.println("Proxy wird deaktiviert");
                        System.setProperty("proxySet", "false");
                        System.setProperty("proxyHost", "");
                        System.setProperty("proxyPort", "");
                        if (Printer.this.CONFIG.isProxy_useuser()) {
                            System.setProperty("http.proxyUser", "");
                            System.setProperty("http.proxyPassword", "");
                        }
                    }
                    printFile = false;
                    try {
                        PrinterJob printJob = PrinterJob.getPrinterJob();
                        PrinterJob printJob2 = PrinterJob.getPrinterJob();
                        PageFormat pf = new PageFormat();
                        if (PdfDecoder.debugPrint) {
                            System.out.println("------------------------");
                            System.out.println("Default Page format used=" + pf);
                            System.out.println("Orientation=" + pf.getOrientation());
                            System.out.println("Width=" + pf.getWidth() + " imageableW=" + pf.getImageableWidth());
                            System.out.println("Height=" + pf.getHeight() + " imageableH=" + pf.getImageableHeight());
                            System.out.println("------------------------");
                        }
                        Paper paper = new Paper();
                        paper.setSize(595.0, 842.0);
                        paper.setImageableArea(0.0, 0.0, 595.0, 842.0);
                        pf.setPaper(paper);
                        Book book = new Book();
                        book.append(decode_pdf, pf, decode_pdf.getPageCount());
                        printJob.setPageable(book);
                        String printername = "";
                        printFile = printJob.printDialog();
                        try {
                            printername = printJob.getPrintService().getName();
                        }
                        catch (Exception e) {
                            Control.addLog(Printer.this.CONFIG, "Drucken", "Fehler beim Ermitteln des Druckernamens", new String[]{"Version: " + Printer.this.CONFIG.getAPPNAME() + " " + Printer.this.CONFIG.getVERSION(), "Exception: " + e.getMessage()});
                        }
                        pf = printJob.getPageFormat(null);
                        Paper p = pf.getPaper();
                        p.setImageableArea(0.0, 0.0, p.getWidth(), p.getHeight());
                        pf.setPaper(paper);
                        printJob2 = printJob;
                        Book book2 = new Book();
                        book2.append(decode_pdf, pf, decode_pdf.getPageCount());
                        printJob2.setPageable(book2);
                        printJob2.setJobName(String.valueOf(Printer.this.CONFIG.getAPPNAME()) + " - " + Printer.this.CONFIG.getNORMFILE().getDateiname());
                        decode_pdf.setPageFormat(pf);
                        boolean isonblacklist = false;
                        Object[] printerBlackList = Printer.this.CONFIG.getLICFILE().getPrinter_Blacklist();
                        if (!((Printer)Printer.this).CONFIG.DEVELOP) {
                            int c = 0;
                            while (c < printerBlackList.length) {
                                redPrinter_Blacklist bl = (redPrinter_Blacklist)printerBlackList[c];
                                String pn = bl.getPrintername();
                                String dn = bl.getDrivername();
                                pn = pn.replaceAll("[*]", ".*");
                                dn = dn.replaceAll("[*]", ".*");
                                if (printername.matches(pn)) {
                                    isonblacklist = true;
                                    break;
                                }
                                if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                                    try {
                                        RegistryKey userFolderKey = null;
                                        String drivername = null;
                                        userFolderKey = Registry.openSubkey((RegistryKey)Registry.HKEY_LOCAL_MACHINE, (String)("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\" + printername), (int)1);
                                        if (userFolderKey != null && (drivername = userFolderKey.getStringValue("Printer Driver")).matches(dn)) {
                                            isonblacklist = true;
                                            break;
                                        }
                                    }
                                    catch (Exception exception) {
                                    }
                                    catch (Error error) {
                                        // empty catch block
                                    }
                                }
                                ++c;
                            }
                        }
                        if (printFile && isonblacklist) {
                            Control.showInfoMessage(Printer.this.CONFIG, Printer.this.CONFIG.getText("msg_printeronblacklist"));
                            printFile = false;
                        }
                        if (!Printer.this.CONFIG.disableProxyOnPrint() || !Printer.this.CONFIG.isProxy_active()) {
                            Printer.this.status = new ProgressMonitor(Printer.this.CONFIG.getMasterFrame(), "", "", 1, 100);
                            Printer.this.CONFIG.getMasterFrame().setCursor(Cursor.getPredefinedCursor(3));
                            Printer.this.CONFIG.setPrinting(true);
                            Printer.this.updatePrinterProgress = new Timer(2000, new ActionListener(this, decode_pdf){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ PdfDecoder val$decode_pdf;
                                {
                                    this.this$1 = var1_1;
                                    this.val$decode_pdf = pdfDecoder;
                                }

                                public void actionPerformed(ActionEvent event) {
                                    int currentPage = this.val$decode_pdf.getCurrentPrintPage();
                                    if (currentPage > 0) {
                                        Printer.access$2(1.access$0(this.this$1), this.val$decode_pdf, currentPage);
                                    }
                                    if (currentPage == -1) {
                                        1.access$0(this.this$1).updatePrinterProgress.stop();
                                        Printer.access$3(1.access$0(this.this$1)).close();
                                        Printer.access$0(1.access$0(this.this$1)).getMasterFrame().setCursor(Cursor.getPredefinedCursor(0));
                                        Printer.access$0(1.access$0(this.this$1)).setPrinting(false);
                                    }
                                }
                            });
                            Printer.this.updatePrinterProgress.setRepeats(true);
                            Printer.this.updatePrinterProgress.start();
                        }
                        if (!printFile) break block31;
                        String dokname = Printer.this.CONFIG.getNORMFILE() != null ? Printer.this.CONFIG.getNORMFILE().getID() : "";
                        String drivername = "";
                        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                            try {
                                RegistryKey userFolderKey = null;
                                userFolderKey = Registry.openSubkey((RegistryKey)Registry.HKEY_LOCAL_MACHINE, (String)("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\" + printJob.getPrintService().getName()), (int)1);
                                if (userFolderKey != null) {
                                    drivername = userFolderKey.getStringValue("Printer Driver");
                                }
                            }
                            catch (Error error) {
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        Control.addLog(Printer.this.CONFIG, "Drucken", "", new String[]{printername, dokname, drivername});
                        printJob2.print();
                    }
                    catch (PrinterException ee) {
                        ee.printStackTrace();
                        LogWriter.writeLog((String)("Exception " + ee + " printing"));
                        currentGUI.showMessageDialog((Object)(String.valueOf(ee.getMessage()) + ' ' + ee + ' ' + ' ' + ee.getCause()));
                    }
                    catch (Exception e) {
                        LogWriter.writeLog((String)("Exception " + e + " printing"));
                        e.printStackTrace();
                        currentGUI.showMessageDialog((Object)("Exception " + e));
                    }
                    catch (Error err) {
                        err.printStackTrace();
                        LogWriter.writeLog((String)("Error " + err + " printing"));
                        currentGUI.showMessageDialog((Object)("Error " + err));
                    }
                }
                if (Printer.this.updatePrinterProgress != null) {
                    Printer.this.updatePrinterProgress.stop();
                    Printer.this.status.close();
                    Printer.this.CONFIG.getMasterFrame().setCursor(Cursor.getPredefinedCursor(0));
                    Printer.this.CONFIG.setPrinting(false);
                }
                if (!printFile && !decode_pdf.isPageSuccessful()) {
                    String errorMessage = String.valueOf(Messages.getMessage((String)"PdfViewerError.ProblemsEncountered")) + decode_pdf.getPageFailureMessage() + '\n';
                    if (decode_pdf.getPageFailureMessage().toLowerCase().indexOf("memory") != -1) {
                        errorMessage = String.valueOf(errorMessage) + Messages.getMessage((String)"PdfViewerError.RerunJava") + Messages.getMessage((String)"PdfViewerError.RerunJava1") + Messages.getMessage((String)"PdfViewerError.RerunJava2");
                    }
                    currentGUI.showMessageDialog((Object)errorMessage);
                }
                printingThreads = printingThreads - 1;
                decode_pdf.invalidate();
                decode_pdf.repaint();
                if (printFile && !Printer.this.wasCancelled) {
                    if (!Printer.this.CONFIG.disableProxyOnPrint() || !Printer.this.CONFIG.isProxy_active()) {
                        currentGUI.showMessageDialog((Object)Messages.getMessage((String)"PdfViewerPrintingFinished"));
                    }
                    decode_pdf.resetCurrentPrintPage();
                }
                if (Printer.this.CONFIG.disableProxyOnPrint() && Printer.this.CONFIG.isProxy_active()) {
                    System.out.println("Proxy wird aktiviert");
                    System.setProperty("proxySet", "true");
                    System.setProperty("proxyHost", Printer.this.CONFIG.getProxy_host());
                    System.setProperty("proxyPort", Printer.this.CONFIG.getProxy_port());
                    if (Printer.this.CONFIG.isProxy_useuser()) {
                        System.setProperty("http.proxyUser", Printer.this.CONFIG.getProxy_user());
                        System.setProperty("http.proxyPassword", Printer.this.CONFIG.getProxy_pw());
                    }
                }
            }

            private String[] getAvailablePrinters() {
                PrintService[] service = PrinterJob.lookupPrintServices();
                int noOfPrinters = service.length;
                String[] serviceNames = new String[noOfPrinters];
                int i = 0;
                while (i < noOfPrinters) {
                    serviceNames[i] = service[i].getName();
                    ++i;
                }
                return serviceNames;
            }

            static /* synthetic */ Printer access$0(1 var0) {
                return var0.Printer.this;
            }
        };
        worker.start();
    }

    private void updatePrinterProgess(PdfDecoder decode_pdf, int currentPage) {
        boolean isBackwards;
        int noOfPagesPrinting = this.rangeEnd - this.rangeStart + 1;
        int currentPrintingPage = currentPage - this.rangeStart;
        int actualCount = noOfPagesPrinting;
        int actualPage = currentPrintingPage;
        int actualPercentage = (int)((float)actualPage / (float)actualCount * 100.0f);
        if (this.status.isCanceled()) {
            decode_pdf.stopPrinting();
            this.updatePrinterProgress.stop();
            this.status.close();
            this.CONFIG.getMasterFrame().setCursor(Cursor.getPredefinedCursor(0));
            this.CONFIG.setPrinting(false);
            this.wasCancelled = true;
            --printingThreads;
            if (!this.messageShown) {
                JOptionPane.showMessageDialog(null, Messages.getMessage((String)"PdfViewerPrint.PrintingCanceled"));
                this.messageShown = true;
            }
            return;
        }
        this.dots = String.valueOf(this.dots) + '.';
        if (this.dots.length() > 8) {
            this.dots = ".";
        }
        boolean bl = isBackwards = currentPrintingPage <= 0;
        if (this.rangeStart == this.rangeEnd) {
            isBackwards = false;
        }
        if (isBackwards) {
            noOfPagesPrinting = this.rangeStart - this.rangeEnd + 1;
        }
        int percentage = (int)((float)currentPrintingPage / (float)noOfPagesPrinting * 100.0f);
        if (!isBackwards && percentage < 1) {
            percentage = 1;
        }
        if (isBackwards) {
            percentage = -percentage;
            currentPrintingPage = -currentPrintingPage;
        }
        if (this.pagesReversed) {
            percentage = 100 - percentage;
        }
        this.status.setProgress(percentage);
        String message = "";
        if (this.subset == 16) {
            actualCount = actualCount / 2 + 1;
            actualPage /= 2;
        } else if (this.subset == 32) {
            actualCount = actualCount / 2 + 1;
            actualPage /= 2;
        }
        if (actualCount == 1) {
            actualPercentage = 50;
            actualPage = 1;
            this.status.setProgress(actualPercentage);
        }
        message = String.valueOf(this.printText) + " " + currentPage + " " + this.dots;
        this.status.setProgress(this.balken);
        ++this.balken;
        if (this.pagesReversed) {
            message = String.valueOf(actualCount - actualPage) + " " + Messages.getMessage((String)"PdfViewerPrint.Of") + ' ' + actualCount + ": " + percentage + '%' + ' ' + this.dots;
            this.status.setNote(String.valueOf(Messages.getMessage((String)"PdfViewerPrint.ReversedPrinting")) + ' ' + message);
        } else if (isBackwards) {
            this.status.setNote(String.valueOf(Messages.getMessage((String)"PdfViewerPrint.ReversedPrinting")) + ' ' + message);
        } else {
            this.status.setNote(message);
        }
    }

    public boolean isPrinting() {
        return printingThreads > 0;
    }

    private void setPrinter(PrinterJob printJob, String chosenPrinter) throws PrinterException, PdfException {
        PrintService[] service = PrinterJob.lookupPrintServices();
        boolean matchFound = false;
        int count = service.length;
        int i = 0;
        while (i < count) {
            if (service[i].getName().equals(chosenPrinter)) {
                printJob.setPrintService(service[i]);
                i = count;
                matchFound = true;
            }
            ++i;
        }
        if (!matchFound) {
            throw new PdfException("Unknown printer " + chosenPrinter);
        }
    }

    public void setCONFIG(Config config) {
        this.CONFIG = config;
    }

    static /* synthetic */ void access$2(Printer printer, PdfDecoder pdfDecoder, int n) {
        printer.updatePrinterProgess(pdfDecoder, n);
    }
}

