/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUIMouseHandler;

public class SwingMouseHandler
implements GUIMouseHandler {
    private PdfDecoder decode_pdf;
    private SwingGUI currentGUI;
    private Values commonValues;
    private Commands currentCommands;
    private String message = "";
    private Rectangle[] boxes = new Rectangle[8];
    private int handlesGap = 5;
    private int oldX = -1;
    private int oldY = -1;
    private boolean dragAltering = false;
    private int boxContained = -1;
    private boolean drawingCursorBox = false;
    private int old_m_x2 = -1;
    private int old_m_y2 = -1;
    private int x;
    private int y;
    private int cx;
    private int cy;
    private int view_state;

    public SwingMouseHandler(PdfDecoder decode_pdf, SwingGUI currentGUI, Values commonValues, Commands currentCommands) {
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.commonValues = commonValues;
        this.currentCommands = currentCommands;
    }

    public void checkLinks(boolean mouseClicked) {
        this.message = "";
    }

    public void setupExtractor() {
        this.decode_pdf.addMouseMotionListener(new Extractor_mouse_mover());
        this.decode_pdf.addMouseListener(new Extractor_mouse_clicker());
    }

    protected void scrollAndUpdateCoords(MouseEvent event) {
        int interval = this.decode_pdf.getScrollInterval();
        Rectangle visible_test = new Rectangle(this.currentGUI.AdjustForAlignment(event.getX()), event.getY(), interval, interval);
        if (this.currentGUI.allowScrolling() && !this.decode_pdf.getVisibleRect().contains(visible_test)) {
            this.decode_pdf.scrollRectToVisible(visible_test);
        }
        this.updateCords(event);
    }

    public void updateCords(MouseEvent event) {
        int tmp;
        float scaling = this.currentGUI.getScaling();
        int inset = this.currentGUI.getPDFDisplayInset();
        int rotation = this.currentGUI.getRotation();
        int ex = this.currentGUI.AdjustForAlignment(event.getX()) - inset;
        int ey = event.getY() - inset;
        if (this.commonValues.maxViewY != 0) {
            ex = (int)((double)((float)ex - (float)this.commonValues.dx * scaling) / this.commonValues.viewportScale);
            ey = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)ey / scaling - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)scaling);
        }
        this.cx = (int)((float)ex / scaling);
        this.cy = (int)((float)ey / scaling);
        if (this.decode_pdf.getDisplayView() != 1) {
            this.cx = 0;
            this.cy = 0;
        } else if (rotation == 90) {
            tmp = this.cx + this.currentGUI.cropY;
            this.cx = this.cy + this.currentGUI.cropX;
            this.cy = tmp;
        } else if (rotation == 180) {
            this.cx = this.currentGUI.cropW + this.currentGUI.cropX - this.cx;
            this.cy += this.currentGUI.cropY;
        } else if (rotation == 270) {
            tmp = this.currentGUI.cropH + this.currentGUI.cropY - this.cx;
            this.cx = this.currentGUI.cropW + this.currentGUI.cropX - this.cy;
            this.cy = tmp;
        } else {
            this.cx += this.currentGUI.cropX;
            this.cy = this.currentGUI.cropH + this.currentGUI.cropY - this.cy;
        }
        if (this.currentGUI.allowScrolling() && !event.isShiftDown()) {
            int interval = this.decode_pdf.getScrollInterval() * 2;
            Rectangle visible_test = new Rectangle(this.currentGUI.AdjustForAlignment(event.getX()) - interval, event.getY() - interval, interval * 2, interval * 2);
            if (!this.decode_pdf.getVisibleRect().contains(visible_test)) {
                this.decode_pdf.scrollRectToVisible(visible_test);
            }
        }
    }

    public void updateRectangle() {
        Rectangle newRect;
        Rectangle currentRectangle = this.currentGUI.getRectangle();
        if (currentRectangle != null && (newRect = this.decode_pdf.getCombinedAreas(currentRectangle, false)) != null) {
            this.commonValues.m_x1 = newRect.x;
            this.commonValues.m_y2 = newRect.y;
            this.commonValues.m_x2 = newRect.x + newRect.width;
            this.commonValues.m_y1 = newRect.y + newRect.height;
            currentRectangle = newRect;
            this.decode_pdf.updateCursorBoxOnScreen(currentRectangle, Color.blue);
            this.decode_pdf.repaint();
        }
    }

    public void setupMouse() {
        this.decode_pdf.addMouseMotionListener(new mouse_mover());
        this.decode_pdf.addMouseListener(new mouse_clicker());
    }

    protected int[] updateXY(MouseEvent event) {
        float scaling = this.currentGUI.getScaling();
        int inset = this.currentGUI.getPDFDisplayInset();
        int rotation = this.currentGUI.getRotation();
        this.x = (int)((float)(this.currentGUI.AdjustForAlignment(event.getX()) - inset) / scaling);
        this.y = (int)((float)(event.getY() - inset) / scaling);
        if (this.commonValues.maxViewY != 0) {
            this.x = (int)((double)((float)this.x - (float)this.commonValues.dx * scaling) / this.commonValues.viewportScale);
            this.y = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)this.y / scaling - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)scaling);
        }
        int[] ret = new int[2];
        if (rotation == 90) {
            ret[1] = this.x + this.currentGUI.cropY;
            ret[0] = this.y + this.currentGUI.cropX;
        } else if (rotation == 180) {
            ret[0] = this.currentGUI.mediaW - (this.x + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
            ret[1] = this.y + this.currentGUI.cropY;
        } else if (rotation == 270) {
            ret[1] = this.currentGUI.mediaH - (this.x + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
            ret[0] = this.currentGUI.mediaW - (this.y + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
        } else {
            ret[0] = this.x + this.currentGUI.cropX;
            ret[1] = this.currentGUI.mediaH - (this.y + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
        }
        return ret;
    }

    protected class Extractor_mouse_clicker
    extends mouse_clicker {
        protected Extractor_mouse_clicker() {
        }

        public void mousePressed(MouseEvent event) {
            Rectangle currentRectangle = SwingMouseHandler.this.currentGUI.getRectangle();
            if (currentRectangle == null) {
                super.mousePressed(event);
                SwingMouseHandler.this.drawingCursorBox = true;
            } else {
                int[] values = SwingMouseHandler.this.updateXY(event);
                SwingMouseHandler.this.oldX = values[0];
                SwingMouseHandler.this.oldY = values[1];
            }
        }

        public void mouseReleased(MouseEvent event) {
            int tmp;
            SwingMouseHandler.this.drawingCursorBox = false;
            SwingMouseHandler.this.old_m_x2 = -1;
            SwingMouseHandler.this.old_m_y2 = -1;
            SwingMouseHandler.this.updateCords(event);
            if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2) {
                tmp = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = tmp;
            }
            if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 < ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2) {
                tmp = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = tmp;
            }
            SwingMouseHandler.this.decode_pdf.repaint();
            SwingMouseHandler.this.dragAltering = false;
        }
    }

    protected class Extractor_mouse_mover
    extends mouse_mover {
        private boolean inRect = false;
        private boolean handleChange = false;

        protected Extractor_mouse_mover() {
        }

        public void mouseDragged(MouseEvent event) {
            Rectangle currentRectangle = SwingMouseHandler.this.currentGUI.getRectangle();
            if (currentRectangle == null || SwingMouseHandler.this.drawingCursorBox) {
                SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, SwingMouseHandler.this.boxContained, Color.red);
                super.mouseDragged(event);
                SwingMouseHandler.this.boxContained = -1;
                return;
            }
            int[] values = SwingMouseHandler.this.updateXY(event);
            SwingMouseHandler.this.boxes = this.createNewRectangles(currentRectangle);
            if (SwingMouseHandler.this.boxContained == -1) {
                int i = 0;
                while (i < SwingMouseHandler.this.boxes.length) {
                    if (SwingMouseHandler.this.boxes[i].contains(SwingMouseHandler.this.oldX, SwingMouseHandler.this.oldY)) {
                        SwingMouseHandler.this.boxContained = i;
                        break;
                    }
                    ++i;
                }
            }
            if (SwingMouseHandler.this.boxContained != -1 || SwingMouseHandler.this.dragAltering) {
                SwingMouseHandler.this.drawingCursorBox = false;
                int highlightBox = SwingMouseHandler.this.boxContained;
                int boxCenterX = (int)SwingMouseHandler.this.boxes[SwingMouseHandler.this.boxContained].getCenterX();
                int boxCenterY = (int)SwingMouseHandler.this.boxes[SwingMouseHandler.this.boxContained].getCenterY();
                if (currentRectangle.x == boxCenterX) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = values[0];
                } else if (currentRectangle.x + currentRectangle.width == boxCenterX) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = values[0];
                }
                if (currentRectangle.y == boxCenterY) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = values[1];
                } else if (currentRectangle.y + currentRectangle.height == boxCenterY) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = values[1];
                }
                boolean changeX = false;
                boolean changeY = false;
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2) {
                    changeX = true;
                }
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1) {
                    changeY = true;
                }
                if (changeX || changeY) {
                    switch (highlightBox) {
                        case 0: {
                            if (!changeX) break;
                            highlightBox = 3;
                            break;
                        }
                        case 1: {
                            if (!changeY) break;
                            highlightBox = 2;
                            break;
                        }
                        case 2: {
                            if (!changeY) break;
                            highlightBox = 1;
                            break;
                        }
                        case 3: {
                            if (!changeX) break;
                            highlightBox = 0;
                            break;
                        }
                        case 4: {
                            if (changeX) {
                                highlightBox = 6;
                            } else if (changeY) {
                                highlightBox = 5;
                            }
                            if (!changeX || !changeY) break;
                            highlightBox = 7;
                            break;
                        }
                        case 5: {
                            if (changeX) {
                                highlightBox = 7;
                            } else if (changeY) {
                                highlightBox = 4;
                            }
                            if (!changeX || !changeY) break;
                            highlightBox = 6;
                            break;
                        }
                        case 6: {
                            if (changeX) {
                                highlightBox = 4;
                            } else if (changeY) {
                                highlightBox = 7;
                            }
                            if (!changeX || !changeY) break;
                            highlightBox = 5;
                            break;
                        }
                        case 7: {
                            if (changeX) {
                                highlightBox = 5;
                            } else if (changeY) {
                                highlightBox = 6;
                            }
                            if (!changeX || !changeY) break;
                            highlightBox = 4;
                        }
                    }
                }
                SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, highlightBox, Color.red);
                SwingMouseHandler.this.scrollAndUpdateCoords(event);
                this.generateNewCursorBox();
                SwingMouseHandler.this.dragAltering = true;
                SwingMouseHandler.this.oldX = values[0];
                SwingMouseHandler.this.oldY = values[1];
            } else {
                SwingMouseHandler.this.drawingCursorBox = true;
                SwingMouseHandler.this.boxContained = -1;
                SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, SwingMouseHandler.this.boxContained, Color.red);
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = SwingMouseHandler.this.oldX;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = SwingMouseHandler.this.oldY;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = values[0];
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = values[1];
                SwingMouseHandler.this.scrollAndUpdateCoords(event);
                this.generateNewCursorBox();
            }
        }

        public void mouseMoved(MouseEvent event) {
            super.mouseMoved(event);
            Rectangle currentRectangle = SwingMouseHandler.this.currentGUI.getRectangle();
            SwingMouseHandler.this.boxes = this.createNewRectangles(currentRectangle);
            if (SwingMouseHandler.this.boxes != null) {
                int oldBox = SwingMouseHandler.this.boxContained;
                SwingMouseHandler.this.boxContained = -1;
                int i = 0;
                while (i < SwingMouseHandler.this.boxes.length) {
                    if (SwingMouseHandler.this.boxes[i].contains(SwingMouseHandler.this.cx, SwingMouseHandler.this.cy)) {
                        SwingMouseHandler.this.boxContained = i;
                        break;
                    }
                    ++i;
                }
                if (SwingMouseHandler.this.boxContained != oldBox) {
                    this.handleChange = true;
                }
            }
            if (currentRectangle != null) {
                if (currentRectangle.x - SwingMouseHandler.this.handlesGap < SwingMouseHandler.this.cx && currentRectangle.x + currentRectangle.width + SwingMouseHandler.this.handlesGap > SwingMouseHandler.this.cx && currentRectangle.y - SwingMouseHandler.this.handlesGap < SwingMouseHandler.this.cy && currentRectangle.y + currentRectangle.height + SwingMouseHandler.this.handlesGap > SwingMouseHandler.this.cy) {
                    SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, SwingMouseHandler.this.boxContained, Color.red);
                    if (!this.inRect || this.handleChange) {
                        SwingMouseHandler.this.decode_pdf.repaint();
                        this.handleChange = false;
                        this.inRect = true;
                    }
                } else {
                    SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(false, SwingMouseHandler.this.boxContained, Color.red);
                    if (this.inRect || this.handleChange) {
                        SwingMouseHandler.this.decode_pdf.repaint();
                        this.handleChange = false;
                        this.inRect = false;
                    }
                }
            }
        }

        private Rectangle[] createNewRectangles(Rectangle currentRectangle) {
            if (currentRectangle != null) {
                int x1 = currentRectangle.x;
                int y1 = currentRectangle.y;
                int x2 = x1 + currentRectangle.width;
                int y2 = y1 + currentRectangle.height;
                Rectangle[] cursorBoxHandles = new Rectangle[]{new Rectangle(x1 - SwingMouseHandler.this.handlesGap, y1 + Math.abs(y2 - y1) / 2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(x1 + Math.abs(x2 - x1) / 2 - SwingMouseHandler.this.handlesGap, y1 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(x1 + Math.abs(x2 - x1) / 2 - SwingMouseHandler.this.handlesGap, y2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(x2 - SwingMouseHandler.this.handlesGap, y1 + Math.abs(y2 - y1) / 2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(x1 - SwingMouseHandler.this.handlesGap, y1 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(x1 - SwingMouseHandler.this.handlesGap, y2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(x2 - SwingMouseHandler.this.handlesGap, y1 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(x2 - SwingMouseHandler.this.handlesGap, y2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2)};
                return cursorBoxHandles;
            }
            return null;
        }
    }

    protected class mouse_clicker
    extends MouseAdapter {
        protected mouse_clicker() {
        }

        public void mousePressed(MouseEvent event) {
            float scaling = SwingMouseHandler.this.currentGUI.getScaling();
            int inset = SwingMouseHandler.this.currentGUI.getPDFDisplayInset();
            int rotation = SwingMouseHandler.this.currentGUI.getRotation();
            SwingMouseHandler.this.view_state = SwingMouseHandler.this.decode_pdf.getDisplayView();
            int x = (int)((float)(SwingMouseHandler.this.currentGUI.AdjustForAlignment(event.getX()) - inset) / scaling);
            int y = (int)((float)(event.getY() - inset) / scaling);
            if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.maxViewY != 0) {
                x = (int)((double)((float)x - (float)((SwingMouseHandler)SwingMouseHandler.this).commonValues.dx * scaling) / ((SwingMouseHandler)SwingMouseHandler.this).commonValues.viewportScale);
                y = (int)(((double)((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - (double)((float)((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - (float)y / scaling - (float)((SwingMouseHandler)SwingMouseHandler.this).commonValues.dy) / ((SwingMouseHandler)SwingMouseHandler.this).commonValues.viewportScale) * (double)scaling);
            }
            if (rotation == 90) {
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = x + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = y + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX;
            } else if (rotation == 180) {
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaW - (x + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaW - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropW - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX);
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = y + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY;
            } else if (rotation == 270) {
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - (x + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropH - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY);
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaW - (y + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaW - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropW - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX);
            } else {
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = x + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - (y + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropH - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY);
            }
            SwingMouseHandler.this.updateCords(event);
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseReleased(MouseEvent event) {
            SwingMouseHandler.this.old_m_x2 = -1;
            SwingMouseHandler.this.old_m_y2 = -1;
            SwingMouseHandler.this.updateCords(event);
            if (SwingMouseHandler.this.commonValues.isPDF() && ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.btn_selecttext.isSelected()) {
                ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.btn_selecttext.setSelected(false);
                if (SwingMouseHandler.this.commonValues.isExtractImageOnSelection()) {
                    if (SwingMouseHandler.this.decode_pdf.getDisplayView() == 1) {
                        SwingMouseHandler.this.currentCommands.extractSelectedScreenAsImage();
                    } else {
                        JOptionPane.showMessageDialog(SwingMouseHandler.this.currentGUI.getFrame(), "Image Extraction is only avalible in single page display mode");
                    }
                } else if (SwingMouseHandler.this.decode_pdf.getDisplayView() == 1) {
                    SwingMouseHandler.this.currentCommands.extractText();
                } else {
                    JOptionPane.showMessageDialog(SwingMouseHandler.this.currentGUI.getFrame(), "Text Extraction is only avalible in single page display mode");
                }
            }
            SwingMouseHandler.this.decode_pdf.updateCursorBoxOnScreen(null, null);
            SwingMouseHandler.this.decode_pdf.repaintArea(new Rectangle(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY), ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH);
            if (SwingMouseHandler.this.decode_pdf.getDisplayView() == 1) {
                SwingMouseHandler.this.decode_pdf.setDisplayView(2, 2);
            }
        }
    }

    protected class mouse_mover
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent event) {
            int[] values = SwingMouseHandler.this.updateXY(event);
            ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = values[0];
            ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = values[1];
            SwingMouseHandler.this.scrollAndUpdateCoords(event);
            if (SwingMouseHandler.this.commonValues.isPDF()) {
                this.generateNewCursorBox();
            }
        }

        protected void generateNewCursorBox() {
            if (SwingMouseHandler.this.old_m_x2 != -1 | SwingMouseHandler.this.old_m_y2 != -1 | Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 - SwingMouseHandler.this.old_m_x2) > 5 | Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 - SwingMouseHandler.this.old_m_y2) > 5) {
                int top_x = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1;
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2) {
                    top_x = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2;
                }
                int top_y = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1;
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2) {
                    top_y = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2;
                }
                int w = Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1);
                int h = Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1);
                Rectangle currentRectangle = new Rectangle(top_x, top_y, w, h);
                SwingMouseHandler.this.currentGUI.setRectangle(currentRectangle);
                if (((SwingMouseHandler)SwingMouseHandler.this).currentGUI.btn_selecttext.isSelected()) {
                    SwingMouseHandler.this.decode_pdf.updateCursorBoxOnScreen(currentRectangle, Color.blue);
                }
                Rectangle[] highlightedAreas = new Rectangle[2];
                highlightedAreas[0] = currentRectangle;
                SwingMouseHandler.this.old_m_x2 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2;
                SwingMouseHandler.this.old_m_y2 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2;
            }
        }

        public void mouseMoved(MouseEvent event) {
            SwingMouseHandler.this.updateCords(event);
        }
    }
}

