/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.popups.AddHeaderFooterToPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.CropPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.DeletePDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.EncryptPDFDocument;
import org.jpedal.examples.simpleviewer.gui.popups.ErrorDialog;
import org.jpedal.examples.simpleviewer.gui.popups.ExtractPDFPagesNup;
import org.jpedal.examples.simpleviewer.gui.popups.InsertBlankPDFPage;
import org.jpedal.examples.simpleviewer.gui.popups.RotatePDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.SaveBitmap;
import org.jpedal.examples.simpleviewer.gui.popups.SaveImage;
import org.jpedal.examples.simpleviewer.gui.popups.SavePDF;
import org.jpedal.examples.simpleviewer.gui.popups.SaveText;
import org.jpedal.examples.simpleviewer.gui.popups.StampImageToPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.StampTextToPDFPages;
import org.jpedal.examples.simpleviewer.utils.Exporter;
import org.jpedal.examples.simpleviewer.utils.FileFilterer;
import org.jpedal.examples.simpleviewer.utils.IconiseImage;
import org.jpedal.examples.simpleviewer.utils.ItextFunctions;
import org.jpedal.examples.simpleviewer.utils.Printer;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;
import org.jpedal.utils.SwingWorker;
import res.Config;

public class Commands {
    public static final int INFO = 1;
    public static final int BITMAP = 2;
    public static final int IMAGES = 3;
    public static final int TEXT = 4;
    public static final int SAVE = 5;
    public static final int PRINT = 6;
    public static final int EXIT = 7;
    public static final int AUTOSCROLL = 8;
    public static final int DOCINFO = 9;
    public static final int OPENFILE = 10;
    public static final int FIND = 12;
    public static final int SNAPSHOT = 13;
    public static final int OPENURL = 14;
    public static final int VISITWEBSITE = 15;
    public static final int PREVIOUSDOCUMENT = 16;
    public static final int NEXTDOCUMENT = 17;
    public static final int PREVIOUSRESULT = 18;
    public static final int NEXTRESULT = 19;
    public static final int TIP = 20;
    public static final int CASCADE = 21;
    public static final int TILE = 22;
    public static final int UPDATE = 23;
    public static final int PREFERENCES = 24;
    public static final int COPY = 25;
    public static final int SELECTALL = 26;
    public static final int DESELECTALL = 27;
    public static final int UPDATEGUILAYOUT = 28;
    public static final int FIRSTPAGE = 50;
    public static final int FBACKPAGE = 51;
    public static final int BACKPAGE = 52;
    public static final int FORWARDPAGE = 53;
    public static final int FFORWARDPAGE = 54;
    public static final int LASTPAGE = 55;
    public static final int GOTO = 56;
    public static final int SINGLE = 57;
    public static final int CONTINUOUS = 58;
    public static final int CONTINUOUS_FACING = 59;
    public static final int FACING = 60;
    public static final int FULLSCREEN = 61;
    public static final int QUALITY = 250;
    public static final int ROTATION = 251;
    public static final int SCALING = 252;
    public static final int SAVEFORM = 500;
    public static final int PDF = 501;
    public static final int ROTATE = 502;
    public static final int DELETE = 503;
    public static final int ADD = 504;
    public static final int SECURITY = 505;
    public static final int ADDHEADERFOOTER = 506;
    public static final int STAMPTEXT = 507;
    public static final int STAMPIMAGE = 508;
    public static final int SETCROP = 509;
    public static final int NUP = 510;
    public static final int HANDOUTS = 511;
    private Values commonValues;
    private SwingGUI currentGUI;
    private PdfDecoder decode_pdf;
    private GUIThumbnailPanel thumbnails;
    Window win;
    private BufferedImage img = null;
    private final Font headFont = new Font("SansSerif", 1, 14);
    private boolean display = true;
    private final GUISearchWindow searchFrame;
    private Printer currentPrinter;
    private boolean isOpening;
    private boolean fileIsURL;
    private Config CONFIG;

    public Commands(Values commonValues, SwingGUI currentGUI, PdfDecoder decode_pdf, GUIThumbnailPanel thumbnails, GUISearchWindow searchFrame, Printer currentPrinter, Config conf) {
        this.commonValues = commonValues;
        this.currentGUI = currentGUI;
        this.decode_pdf = decode_pdf;
        this.thumbnails = thumbnails;
        this.currentPrinter = currentPrinter;
        this.searchFrame = searchFrame;
        this.CONFIG = conf;
    }

    public void executeCommand(int ID, Object[] args) {
        switch (ID) {
            case 1: {
                this.currentGUI.getInfoBox();
                break;
            }
            case 2: {
                if (this.commonValues.getSelectedFile() == null) {
                    JOptionPane.showMessageDialog(this.currentGUI.getFrame(), Messages.getMessage((String)"PdfViewer.OpenFile"));
                    break;
                }
                SaveBitmap current_selection = new SaveBitmap(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int userChoice = current_selection.display(this.currentGUI.getFrame(), Messages.getMessage((String)"PdfViewer.SaveAsBitmap"));
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerMessage.CannotExportFromURL"));
                    break;
                }
                if (userChoice != 0) break;
                Exporter exporter = new Exporter(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                exporter.extractPagesAsImages(current_selection);
                break;
            }
            case 3: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFile"));
                    break;
                }
                SaveImage current_selection = new SaveImage(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int userChoice = current_selection.display(this.currentGUI.getFrame(), Messages.getMessage((String)"PdfViewerTitle.SaveImagesFromPageRange"));
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerMessage.CannotExportFromURL"));
                    break;
                }
                if (userChoice != 0) break;
                Exporter exporter = new Exporter(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                exporter.extractImagesOnPages(current_selection);
                break;
            }
            case 4: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFile"));
                    break;
                }
                if (!this.decode_pdf.isExtractionAllowed()) {
                    this.currentGUI.showMessageDialog("Not allowed");
                    break;
                }
                SaveText current_selection = new SaveText(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int userChoice = current_selection.display(this.currentGUI.getFrame(), Messages.getMessage((String)"PdfViewerTitle.SaveTextFromPageRange"));
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerMessage.CannotExportFromURL"));
                    break;
                }
                if (userChoice != 0) break;
                Exporter exporter = new Exporter(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                exporter.extractTextOnPages(current_selection);
                break;
            }
            case 5: {
                this.saveFile();
                break;
            }
            case 6: {
                if (this.commonValues.getSelectedFile() != null) {
                    if (!this.currentPrinter.isPrinting()) {
                        if (!this.commonValues.isPDF()) {
                            this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.ImagePrinting"));
                            break;
                        }
                        this.currentPrinter.printPDF(this.decode_pdf, this.currentGUI, this.CONFIG.getText("txt_printpage"));
                        break;
                    }
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerPrintFinish.message"));
                    break;
                }
                this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerNoFile.message"));
                break;
            }
            case 7: {
                if (this.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerStillPrinting.text"));
                    break;
                }
                this.exit();
                break;
            }
            case 8: {
                this.currentGUI.toogleAutoScrolling();
                break;
            }
            case 9: {
                if (!this.commonValues.isPDF()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.ImageSearch"));
                    break;
                }
                this.currentGUI.showDocumentProperties(this.commonValues.getSelectedFile(), this.commonValues.getInputDir(), this.commonValues.getFileSize(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                break;
            }
            case 10: {
                this.handleUnsaveForms();
                if (this.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerPrintWait.message"));
                    break;
                }
                if (this.commonValues.isProcessing() || this.isOpening) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerDecodeWait.message"));
                    break;
                }
                if (this.commonValues.isContentExtractor()) {
                    this.currentGUI.setPDFOutlineVisible(false);
                }
                this.selectFile();
                this.fileIsURL = false;
                break;
            }
            case 13: {
                if (this.decode_pdf.getDisplayView() != 1) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PageLayoutMessage.SinglePageOnly"));
                    break;
                }
                this.commonValues.toggleExtractImageOnSelection();
                this.currentGUI.toggleSnapshotButton();
                break;
            }
            case 12: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFile"));
                    break;
                }
                if (!this.commonValues.isPDF()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.ImageSearch"));
                    break;
                }
                if (this.decode_pdf.getDisplayView() != 1) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PageLayoutMessage.SinglePageOnly"));
                    break;
                }
                if (!this.searchFrame.isSearchVisible()) {
                    this.searchFrame.find();
                    break;
                }
                this.searchFrame.grabFocusInInput();
                break;
            }
            case 14: {
                this.handleUnsaveForms();
                if (this.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerPrintWait.message"));
                    break;
                }
                if (this.commonValues.isProcessing() || this.isOpening) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerDecodeWait.message"));
                    break;
                }
                this.currentGUI.resetNavBar();
                String newFile = this.selectURL();
                if (newFile == null) break;
                this.commonValues.setSelectedFile(newFile);
                this.fileIsURL = true;
                break;
            }
            case 15: {
                try {
                    BrowserLauncher.openURL((String)Messages.getMessage((String)"PdfViewer.VisitWebsite"));
                }
                catch (IOException e1) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.ErrorWebsite"));
                }
                break;
            }
            case 50: {
                if (this.commonValues.getSelectedFile() == null || this.commonValues.getPageCount() <= 1 || this.commonValues.getCurrentPage() == 1) break;
                this.back(this.commonValues.getCurrentPage() - 1);
                break;
            }
            case 51: {
                if (this.commonValues.getSelectedFile() == null) break;
                if (this.commonValues.getCurrentPage() < 10) {
                    this.back(this.commonValues.getCurrentPage() - 1);
                    break;
                }
                this.back(10);
                break;
            }
            case 52: {
                if (this.commonValues.getSelectedFile() == null) break;
                this.back(1);
                break;
            }
            case 53: {
                if (this.commonValues.getSelectedFile() == null) break;
                this.forward(1);
                break;
            }
            case 54: {
                if (this.commonValues.getSelectedFile() == null) break;
                if (this.commonValues.getPageCount() < this.commonValues.getCurrentPage() + 10) {
                    this.forward(this.commonValues.getPageCount() - this.commonValues.getCurrentPage());
                    break;
                }
                this.forward(10);
                break;
            }
            case 55: {
                if (this.commonValues.getSelectedFile() == null || this.commonValues.getPageCount() <= 1 || this.commonValues.getPageCount() - this.commonValues.getCurrentPage() <= 0) break;
                this.forward(this.commonValues.getPageCount() - this.commonValues.getCurrentPage());
                break;
            }
            case 56: {
                String page = this.currentGUI.showInputDialog(Messages.getMessage((String)"PdfViewer.EnterPageNumber"), Messages.getMessage((String)"PdfViewer.GotoPage"), 3);
                if (page == null) break;
                this.gotoPage(page);
                break;
            }
            case 57: {
                this.currentGUI.alignLayoutMenuOption(1);
                this.decode_pdf.setDisplayView(1, 2);
                this.currentGUI.resetRotationBox();
                break;
            }
            case 58: {
                this.decode_pdf.setDisplayView(2, 2);
                break;
            }
            case 59: {
                this.decode_pdf.setDisplayView(4, 2);
                this.currentGUI.setSelectedComboIndex(251, 0);
                break;
            }
            case 60: {
                this.currentGUI.alignLayoutMenuOption(3);
                this.decode_pdf.setDisplayView(3, 2);
                this.currentGUI.decodePage(false);
                this.currentGUI.setSelectedComboIndex(251, 0);
                break;
            }
            case 61: {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gs = ge.getDefaultScreenDevice();
                gs.isFullScreenSupported();
                if (this.win == null) {
                    Frame frame = new Frame(gs.getDefaultConfiguration());
                    this.win = new Window(frame);
                }
                this.currentGUI.getMyFrame().getContentPane().remove(this.currentGUI.getDisplayPane());
                this.win.add((Component)this.currentGUI.getDisplayPane(), "Center");
                Button btn = new Button("Return");
                this.win.add((Component)btn, "North");
                btn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        GraphicsDevice gs = ge.getDefaultScreenDevice();
                        gs.setFullScreenWindow(null);
                        Commands.this.win.remove(Commands.this.currentGUI.getDisplayPane());
                        Commands.this.currentGUI.getMyFrame().getContentPane().add((Component)Commands.this.currentGUI.getDisplayPane(), "Center");
                        Commands.this.currentGUI.getDisplayPane().invalidate();
                        Commands.this.currentGUI.getDisplayPane().updateUI();
                        Commands.this.currentGUI.getMyFrame().getContentPane().validate();
                        Commands.this.win.dispose();
                    }
                });
                try {
                    gs.setFullScreenWindow(this.win);
                    this.win.validate();
                }
                catch (Error e) {
                    this.currentGUI.showMessageDialog("Full screen mode not supported on this machine.\nJPedal will now exit");
                    this.exit();
                }
                break;
            }
            case 250: {
                if (this.commonValues.isProcessing()) break;
                boolean useHiresImage = true;
                if (this.currentGUI.getSelectedComboIndex(250) == 0) {
                    useHiresImage = false;
                }
                if (this.commonValues.getSelectedFile() == null) break;
                this.decode_pdf.unsetScaling();
                this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerReparseWait.message"));
                this.decode_pdf.useHiResScreenDisplay(useHiresImage);
                this.commonValues.setUseHiresImage(useHiresImage);
                try {
                    this.currentGUI.decodePage(false);
                }
                catch (Exception e1) {
                    System.err.println("Exception " + e1 + "decoding page after image quality changes");
                    e1.printStackTrace();
                }
                break;
            }
            case 252: {
                if (this.commonValues.isProcessing() || this.commonValues.getSelectedFile() == null) break;
                this.currentGUI.zoom();
                break;
            }
            case 251: {
                if (this.commonValues.getSelectedFile() != null) {
                    this.currentGUI.rotate();
                }
                this.currentGUI.getDisplayPane();
                break;
            }
            case 500: {
                this.saveChangedForm();
                break;
            }
            case 501: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFile"));
                    break;
                }
                SavePDF current_selection = new SavePDF(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int userChoice = current_selection.display(this.currentGUI.getFrame(), Messages.getMessage((String)"PdfViewerTitle.SavePagesAsPdf"));
                if (userChoice != 0) break;
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.extractPagesToNewPDF(current_selection);
                break;
            }
            case 502: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFile"));
                    break;
                }
                RotatePDFPages current_selection = new RotatePDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int userChoice = current_selection.display(this.currentGUI.getFrame(), Messages.getMessage((String)"PdfViewerRotation.text"));
                if (userChoice != 0) break;
                PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.rotate(this.commonValues.getPageCount(), currentPageData, current_selection);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            case 509: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFile"));
                    break;
                }
                CropPDFPages cropPage = new CropPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int cropPageChoice = cropPage.display(this.currentGUI.getFrame(), Messages.getMessage((String)"PdfViewerTooltip.PDFCropPages"));
                if (cropPageChoice != 0) break;
                PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.setCrop(this.commonValues.getPageCount(), currentPageData, cropPage);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            case 510: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFile"));
                    break;
                }
                ExtractPDFPagesNup nup = new ExtractPDFPagesNup(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int nupChoice = nup.display(this.currentGUI.getFrame(), Messages.getMessage((String)"PdfViewerNUP.titlebar"));
                if (nupChoice != 0) break;
                PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.nup(this.commonValues.getPageCount(), currentPageData, nup);
                break;
            }
            case 511: {
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerMessage.CannotExportFromURL"));
                }
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFile"));
                    break;
                }
                if (this.fileIsURL) break;
                JFileChooser chooser1 = new JFileChooser();
                chooser1.setFileSelectionMode(0);
                int approved1 = chooser1.showSaveDialog(null);
                if (approved1 != 0) break;
                File file = chooser1.getSelectedFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.handouts(file.getAbsolutePath());
                break;
            }
            case 503: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFile"));
                    break;
                }
                DeletePDFPages deletedPages = new DeletePDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int deletedPagesChoice = deletedPages.display(this.currentGUI.getFrame(), Messages.getMessage((String)"PdfViewerDelete.text"));
                if (deletedPagesChoice != 0) break;
                PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.delete(this.commonValues.getPageCount(), currentPageData, deletedPages);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            case 506: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFile"));
                    break;
                }
                AddHeaderFooterToPDFPages addHeaderFooter = new AddHeaderFooterToPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int headerFooterPagesChoice = addHeaderFooter.display(this.currentGUI.getFrame(), Messages.getMessage((String)"PdfViewerTitle.AddHeaderAndFooters"));
                if (headerFooterPagesChoice != 0) break;
                PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.addHeaderFooter(this.commonValues.getPageCount(), currentPageData, addHeaderFooter);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            case 507: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFile"));
                    break;
                }
                StampTextToPDFPages stampText = new StampTextToPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int stampTextChoice = stampText.display(this.currentGUI.getFrame(), Messages.getMessage((String)"PdfViewerStampText.text"));
                if (stampTextChoice != 0) break;
                PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.stampText(this.commonValues.getPageCount(), currentPageData, stampText);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            case 508: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFile"));
                    break;
                }
                StampImageToPDFPages stampImage = new StampImageToPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int stampImageChoice = stampImage.display(this.currentGUI.getFrame(), Messages.getMessage((String)"PdfViewerStampImage.text"));
                if (stampImageChoice != 0) break;
                PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.stampImage(this.commonValues.getPageCount(), currentPageData, stampImage);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            case 504: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFile"));
                    break;
                }
                InsertBlankPDFPage addPage = new InsertBlankPDFPage(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int positionToAdd = addPage.display(this.currentGUI.getFrame(), Messages.getMessage((String)"PdfViewer.BlankPage"));
                if (positionToAdd != 0) break;
                PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.add(this.commonValues.getPageCount(), currentPageData, addPage);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            case 505: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFile"));
                    break;
                }
                EncryptPDFDocument encryptPage = new EncryptPDFDocument(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int encrypt = encryptPage.display(this.currentGUI.getFrame(), "Standard Security");
                if (encrypt != 0) break;
                PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.encrypt(this.commonValues.getPageCount(), currentPageData, encryptPage);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            default: {
                System.out.println("No menu item set");
            }
        }
    }

    private void saveChangedForm() {
        AcroRenderer formRenderer = this.decode_pdf.getFormRenderer();
        if (formRenderer == null) {
            return;
        }
        List names = null;
        try {
            names = formRenderer.getComponentNameList();
        }
        catch (PdfException e1) {
            e1.printStackTrace();
        }
        if (names == null) {
            this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NoFields"));
        } else {
            File file = null;
            String fileToSave = "";
            boolean finished = false;
            while (!finished) {
                JFileChooser chooser = new JFileChooser(this.commonValues.getInputDir());
                chooser.setSelectedFile(new File(String.valueOf(this.commonValues.getInputDir()) + "/" + this.commonValues.getSelectedFile()));
                chooser.addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
                chooser.addChoosableFileFilter(new FileFilterer(new String[]{"fdf"}, "fdf (*.fdf)"));
                chooser.setFileSelectionMode(0);
                int approved = chooser.showSaveDialog(null);
                if (approved == 0) {
                    int n;
                    file = chooser.getSelectedFile();
                    fileToSave = file.getAbsolutePath();
                    if (!fileToSave.endsWith(".pdf")) {
                        fileToSave = String.valueOf(fileToSave) + ".pdf";
                        file = new File(fileToSave);
                    }
                    if (fileToSave.equals(this.commonValues.getSelectedFile())) {
                        this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerMessage.SaveError"));
                        continue;
                    }
                    if (file.exists() && (n = this.currentGUI.showConfirmDialog(String.valueOf(fileToSave) + "\n" + Messages.getMessage((String)"PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage((String)"PdfViewerMessage.ConfirmResave"), Messages.getMessage((String)"PdfViewerMessage.Resave"), 0)) == 1) continue;
                    finished = true;
                    continue;
                }
                return;
            }
            ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
            itextFunctions.saveFormsData(fileToSave);
            this.commonValues.setFormsChanged(false);
            this.currentGUI.setViewerTitle(null);
        }
    }

    public void handleUnsaveForms() {
        int n;
        if (this.commonValues.isFormsChanged() && this.commonValues.isItextOnClasspath() && (n = this.currentGUI.showConfirmDialog(Messages.getMessage((String)"PdfViewerFormsUnsavedOptions.message"), Messages.getMessage((String)"PdfViewerFormsUnsavedWarning.message"), 0)) == 0) {
            this.saveChangedForm();
        }
        this.commonValues.setFormsChanged(false);
    }

    public void extractSelectedScreenAsImage() {
        int t_x1 = this.commonValues.m_x1;
        int t_x2 = this.commonValues.m_x2;
        int t_y1 = this.commonValues.m_y1;
        int t_y2 = this.commonValues.m_y2;
        if (this.commonValues.m_y1 < this.commonValues.m_y2) {
            t_y2 = this.commonValues.m_y1;
            t_y1 = this.commonValues.m_y2;
        }
        if (this.commonValues.m_x1 > this.commonValues.m_x2) {
            t_x2 = this.commonValues.m_x1;
            t_x1 = this.commonValues.m_x2;
        }
        float scaling = 100.0f;
        if (PdfDecoder.isRunningOnWindows) {
            scaling = 100.0f * this.currentGUI.getScaling();
        }
        final BufferedImage snapShot = this.decode_pdf.getSelectedRectangleOnscreen(t_x1, t_y1, t_x2, t_y2, scaling);
        JPanel image_display = new JPanel();
        image_display.setLayout(new BorderLayout());
        if (snapShot == null) {
            return;
        }
        IconiseImage icon_image = new IconiseImage(snapShot);
        image_display.add((Component)new JLabel(icon_image), "Center");
        final JScrollPane image_scroll = new JScrollPane();
        image_scroll.getViewport().add(image_display);
        int imgSize = snapShot.getWidth();
        if (imgSize < snapShot.getHeight()) {
            imgSize = snapShot.getHeight();
        }
        if ((imgSize += 50) > 450) {
            imgSize = 450;
        }
        JFrame frame = this.currentGUI.getMyFrame();
        final JDialog displayFrame = new JDialog((Frame)frame, true);
        if (this.commonValues.getModeOfOperation() != 1) {
            displayFrame.setLocationRelativeTo(null);
            displayFrame.setLocation(frame.getLocationOnScreen().x + 10, frame.getLocationOnScreen().y + 10);
        }
        displayFrame.setSize(imgSize, imgSize);
        displayFrame.setTitle(Messages.getMessage((String)"PdfViewerMessage.SaveImage"));
        displayFrame.getContentPane().setLayout(new BorderLayout());
        displayFrame.getContentPane().add((Component)image_scroll, "Center");
        JPanel buttonBar = new JPanel();
        buttonBar.setLayout(new BorderLayout());
        displayFrame.getContentPane().add((Component)buttonBar, "South");
        JButton yes = new JButton(Messages.getMessage((String)"PdfMessage.Yes"));
        yes.setFont(new Font("SansSerif", 0, 12));
        buttonBar.add((Component)yes, "West");
        yes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                displayFrame.hide();
                File file = null;
                String fileToSave = "";
                boolean finished = false;
                while (!finished) {
                    JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
                    chooser.addChoosableFileFilter(new FileFilterer(new String[]{"tif", "tiff"}, "TIFF"));
                    chooser.addChoosableFileFilter(new FileFilterer(new String[]{"jpg", "jpeg"}, "JPEG"));
                    int approved = chooser.showSaveDialog(image_scroll);
                    if (approved == 0) {
                        int n;
                        file = chooser.getSelectedFile();
                        fileToSave = file.getAbsolutePath();
                        String format = chooser.getFileFilter().getDescription();
                        if (format.equals("All Files")) {
                            format = "TIFF";
                        }
                        if (!fileToSave.toLowerCase().endsWith(("." + format).toLowerCase())) {
                            fileToSave = String.valueOf(fileToSave) + "." + format;
                            file = new File(fileToSave);
                        }
                        if (file.exists() && (n = Commands.this.currentGUI.showConfirmDialog(String.valueOf(fileToSave) + "\n" + Messages.getMessage((String)"PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage((String)"PdfViewerMessage.ConfirmResave"), Messages.getMessage((String)"PdfViewerMessage.Resave"), 0)) == 1) continue;
                        if (JAIHelper.isJAIused()) {
                            JAIHelper.confirmJAIOnClasspath();
                        }
                        if (snapShot != null) {
                            if (JAIHelper.isJAIused()) {
                                JAI.create((String)"filestore", (RenderedImage)snapShot, (Object)fileToSave, (Object)format);
                            } else if (format.toLowerCase().startsWith("tif")) {
                                Commands.this.currentGUI.showMessageDialog("Please setup JAI library for Tiffs");
                            } else {
                                try {
                                    ImageIO.write((RenderedImage)snapShot, format, new File(fileToSave));
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                        finished = true;
                        continue;
                    }
                    return;
                }
                displayFrame.dispose();
            }
        });
        JButton no = new JButton(Messages.getMessage((String)"PdfMessage.No"));
        no.setFont(new Font("SansSerif", 0, 12));
        buttonBar.add((Component)no, "East");
        no.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                displayFrame.dispose();
            }
        });
        displayFrame.show();
    }

    public void extractSelectedText() {
        if (!this.decode_pdf.isExtractionAllowed()) {
            this.currentGUI.showMessageDialog("Not allowed");
            return;
        }
        int t_x1 = this.commonValues.m_x1;
        int t_x2 = this.commonValues.m_x2;
        int t_y1 = this.commonValues.m_y1;
        int t_y2 = this.commonValues.m_y2;
        if (this.commonValues.m_y1 < this.commonValues.m_y2) {
            t_y2 = this.commonValues.m_y1;
            t_y1 = this.commonValues.m_y2;
        }
        if (this.commonValues.m_x1 > this.commonValues.m_x2) {
            t_x2 = this.commonValues.m_x1;
            t_x1 = this.commonValues.m_x2;
        }
        String[] groupings = new String[]{Messages.getMessage((String)"PdfViewerRect.label"), Messages.getMessage((String)"PdfViewerRect.message"), Messages.getMessage((String)"PdfViewerTable.label"), Messages.getMessage((String)"PdfViewerTable.message"), Messages.getMessage((String)"PdfViewerWordList.label"), Messages.getMessage((String)"PdfViewerWordList.message"), Messages.getMessage((String)"PdfViewerFind.label"), Messages.getMessage((String)"PdfViewerFind.message")};
        boolean isXML = true;
        JPanel display_value = new JPanel();
        display_value.setLayout(new BoxLayout(display_value, 1));
        JLabel region = new JLabel(String.valueOf(Messages.getMessage((String)"PdfViewerCoords.message")) + " " + this.commonValues.m_x1 + " , " + this.commonValues.m_y1 + " , " + this.commonValues.m_x2 + " , " + this.commonValues.m_y2);
        region.setFont(this.headFont);
        display_value.add(region);
        display_value.add(new JLabel(" "));
        int groupingCount = groupings.length / 2;
        Object[] options = new Object[groupingCount + 2];
        int i = 0;
        while (i < groupingCount) {
            options[i + 2] = groupings[i * 2];
            JLabel groupingTitle = new JLabel(groupings[i * 2]);
            groupingTitle.setForeground(Color.blue);
            groupingTitle.setFont(this.headFont);
            display_value.add(groupingTitle);
            JLabel groupingInfo = new JLabel(groupings[i * 2 + 1]);
            groupingInfo.setFont(this.headFont);
            display_value.add(groupingInfo);
            display_value.add(new JLabel(" "));
            ++i;
        }
        options[0] = Messages.getMessage((String)"PdfViewerCancel.text");
        options[1] = Messages.getMessage((String)"PdfViewerHelpMenu.text");
        this.display = true;
        while (this.display) {
            int n = this.currentGUI.showOptionDialog(display_value, Messages.getMessage((String)"PdfViewerGroupingOptions.message"), 0, 1, null, options, options[0]);
            String extractedText = null;
            try {
                PdfGroupingAlgorithms currentGrouping = null;
                if (n > 1) {
                    currentGrouping = this.decode_pdf.getGroupingObject();
                }
                this.display = false;
                switch (n) {
                    case 1: {
                        JTextArea info = new JTextArea(Messages.getMessage((String)"PdfViewerGroupingInfo.message"));
                        this.currentGUI.showMessageDialog(info);
                        this.display = true;
                        break;
                    }
                    case 2: {
                        extractedText = currentGrouping.extractTextInRectangle(t_x1, t_y1, t_x2, t_y2, this.commonValues.getCurrentPage(), false, true);
                        int useXml = this.currentGUI.showConfirmDialog(Messages.getMessage((String)"PdfViewerXmlMessage.message"), Messages.getMessage((String)"PdfViewerOutputFormat.message"), 0);
                        if (extractedText == null) {
                            this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerMessage.NoTextFound"));
                            break;
                        }
                        if (useXml != 0) {
                            extractedText = Strip.stripXML((String)extractedText).toString();
                            isXML = false;
                            break;
                        }
                        isXML = true;
                        break;
                    }
                    case 3: {
                        isXML = true;
                        int useCSV = this.currentGUI.showConfirmDialog(Messages.getMessage((String)"PdfViewerXHTML.message"), Messages.getMessage((String)"PdfViewerOutputFormat.message"), 0);
                        Map content = useCSV != 0 ? currentGrouping.extractTextAsTable(t_x1, t_y1, t_x2, t_y2, this.commonValues.getCurrentPage(), true, false, false, false, 0, false) : currentGrouping.extractTextAsTable(t_x1, t_y1, t_x2, t_y2, this.commonValues.getCurrentPage(), false, true, true, false, 1, false);
                        extractedText = (String)content.get("content");
                        break;
                    }
                    case 4: {
                        int alterCoords;
                        PdfGroupingAlgorithms.useUnrotatedCoords = true;
                        PdfPageData pageData = this.decode_pdf.getPdfPageData();
                        int rotation = pageData.getRotation(this.commonValues.getCurrentPage());
                        if (rotation != 0 && (alterCoords = this.currentGUI.showConfirmDialog(Messages.getMessage((String)"PdfViewerRotatedCoords.message"), Messages.getMessage((String)"PdfViewerOutputFormat.message"), 0)) == 0) {
                            PdfGroupingAlgorithms.useUnrotatedCoords = false;
                        }
                        Vector words = currentGrouping.extractTextAsWordlist(t_x1, t_y1, t_x2, t_y2, this.commonValues.getCurrentPage(), false, true, "()!;.,\\/\"\"''");
                        int useXml = this.currentGUI.showConfirmDialog(Messages.getMessage((String)"PdfViewerXmlMessage.message"), Messages.getMessage((String)"PdfViewerOutputFormat.message"), 0);
                        if (words == null) {
                            this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerMessage.NoTextFound"));
                        } else {
                            isXML = useXml == 0;
                        }
                        if (words == null) break;
                        StringBuffer textOutput = new StringBuffer();
                        Iterator wordIterator = words.iterator();
                        while (wordIterator.hasNext()) {
                            String currentWord = (String)wordIterator.next();
                            if (!isXML) {
                                currentWord = Strip.convertToText((String)currentWord);
                            }
                            int wx1 = (int)Float.parseFloat((String)wordIterator.next());
                            int wy1 = (int)Float.parseFloat((String)wordIterator.next());
                            int wx2 = (int)Float.parseFloat((String)wordIterator.next());
                            int wy2 = (int)Float.parseFloat((String)wordIterator.next());
                            textOutput.append(String.valueOf(currentWord) + "," + wx1 + "," + wy1 + "," + wx2 + "," + wy2 + "\n");
                        }
                        extractedText = textOutput.toString();
                        break;
                    }
                    case 5: {
                        String textToFind = this.currentGUI.showInputDialog(Messages.getMessage((String)"PdfViewerMessage.GetUserInput"));
                        if (textToFind == null || textToFind.length() < 1) {
                            this.display = true;
                            break;
                        }
                        boolean isCaseSensitive = false;
                        int caseSensitiveOption = this.currentGUI.showConfirmDialog(Messages.getMessage((String)"PdfViewercase.message"), null, 0);
                        if (caseSensitiveOption == 0) {
                            isCaseSensitive = true;
                        }
                        boolean findAll = false;
                        int findAllOption = this.currentGUI.showConfirmDialog(Messages.getMessage((String)"PdfViewerfindAll.message"), null, 0);
                        if (findAllOption == 0) {
                            findAll = true;
                        }
                        if (textToFind == null) break;
                        float[] co_ords = currentGrouping.findTextInRectangle(t_x1, t_y1, t_x2, t_y2, this.commonValues.getCurrentPage(), textToFind);
                        if (co_ords != null) {
                            if (co_ords.length < 3) {
                                this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage((String)"PdfViewerMessage.Found")) + " " + co_ords[0] + "," + co_ords[1]);
                                break;
                            }
                            StringBuffer displayCoords = new StringBuffer();
                            int i2 = 0;
                            while (i2 < co_ords.length / 2) {
                                displayCoords.append(String.valueOf(Messages.getMessage((String)"PdfViewerMessage.FoundAt")) + " ");
                                System.out.println("coord.length=" + co_ords.length + " i=" + i2);
                                displayCoords.append(co_ords[i2 * 2]);
                                displayCoords.append(",");
                                displayCoords.append(co_ords[i2 * 2 + 1]);
                                displayCoords.append("\n");
                                ++i2;
                            }
                            this.currentGUI.showMessageDialog(displayCoords.toString());
                            break;
                        }
                        this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerMessage.NotFound"));
                        break;
                    }
                }
                if (extractedText == null) continue;
                JScrollPane scroll = new JScrollPane();
                try {
                    JTextPane text_pane = new JTextPane();
                    scroll = this.currentGUI.createPane(text_pane, extractedText, isXML);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                scroll.setHorizontalScrollBarPolicy(31);
                scroll.setVerticalScrollBarPolicy(20);
                scroll.setPreferredSize(new Dimension(400, 400));
                final JDialog displayFrame = new JDialog((Frame)this.currentGUI.getMyFrame(), true);
                if (this.commonValues.getModeOfOperation() != 1) {
                    JFrame frame = this.currentGUI.getMyFrame();
                    displayFrame.setLocation(frame.getLocationOnScreen().x + 10, frame.getLocationOnScreen().y + 10);
                }
                displayFrame.setSize(450, 450);
                displayFrame.setTitle(Messages.getMessage((String)"PdfViewerExtractedText.menu"));
                displayFrame.getContentPane().setLayout(new BorderLayout());
                displayFrame.getContentPane().add((Component)scroll, "Center");
                JPanel buttonBar = new JPanel();
                buttonBar.setLayout(new BorderLayout());
                displayFrame.getContentPane().add((Component)buttonBar, "South");
                JButton yes = new JButton(Messages.getMessage((String)"PdfViewerMenu.return"));
                yes.setFont(new Font("SansSerif", 0, 12));
                buttonBar.add((Component)yes, "West");
                yes.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Commands.this.display = true;
                        displayFrame.dispose();
                    }
                });
                JButton no = new JButton(Messages.getMessage((String)"PdfViewerFileMenuExit.text"));
                no.setFont(new Font("SansSerif", 0, 12));
                buttonBar.add((Component)no, "East");
                no.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        displayFrame.dispose();
                    }
                });
                displayFrame.show();
            }
            catch (PdfException e) {
                System.err.println("Exception " + e.getMessage() + " in file " + this.commonValues.getSelectedFile());
                e.printStackTrace();
            }
        }
    }

    private void decodeImage(final boolean resizePanel) {
        this.decode_pdf.setFoundTextAreas(null);
        this.currentGUI.setRectangle(null);
        this.currentGUI.resetComboBoxes(false);
        this.decode_pdf.clearScreen();
        this.thumbnails.terminateDrawing();
        this.commonValues.setProcessing(true);
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                try {
                    Commands.this.currentGUI.updateStatusMessage(Messages.getMessage((String)"PdfViewerDecoding.page"));
                    if (Commands.this.img != null) {
                        Commands.this.decode_pdf.addImage(Commands.this.img);
                    }
                    PdfPageData page_data = Commands.this.decode_pdf.getPdfPageData();
                    page_data.checkSizeSet(1);
                    Commands.this.currentGUI.resetRotationBox();
                    if (resizePanel && Commands.this.thumbnails.isShownOnscreen()) {
                        Commands.this.currentGUI.zoom();
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    Commands.this.currentGUI.setPageNumber();
                    Commands.this.currentGUI.setViewerTitle(null);
                }
                catch (Exception e) {
                    Commands.this.currentGUI.setViewerTitle(null);
                }
                Commands.this.currentGUI.setStatusProgress(100);
                Commands.this.currentGUI.resetComboBoxes(true);
                Commands.this.decode_pdf.repaint();
                return null;
            }
        };
        worker.start();
    }

    protected boolean openUpFile(String selectedFile) {
        this.commonValues.maxViewY = 0;
        boolean fileCanBeOpened = true;
        this.decode_pdf.closePdfFile();
        this.currentGUI.setScalingToDefault();
        this.decode_pdf.markAllPagesAsUnread();
        try {
            if (this.commonValues.isPDF()) {
                if (selectedFile.startsWith("http:")) {
                    try {
                        this.decode_pdf.openPdfFileFromURL(this.commonValues.getSelectedFile());
                    }
                    catch (Exception e) {
                        this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.UrlError"));
                        selectedFile = null;
                        fileCanBeOpened = false;
                    }
                } else {
                    this.decode_pdf.openPdfFile(this.commonValues.getSelectedFile());
                }
                this.currentGUI.reinitThumbnails();
            } else {
                boolean isTiff;
                this.decode_pdf.resetForNonPDFPage();
                boolean bl = isTiff = selectedFile.toLowerCase().indexOf(".tif") != -1;
                if (JAIHelper.isJAIused()) {
                    JAIHelper.confirmJAIOnClasspath();
                }
                if (isTiff && JAIHelper.isJAIused()) {
                    try {
                        this.img = JAI.create((String)"fileload", (Object)this.commonValues.getSelectedFile()).getAsBufferedImage();
                    }
                    catch (Exception e) {
                        LogWriter.writeLog((String)("Exception " + e + Messages.getMessage((String)"PdfViewerError.Loading") + this.commonValues.getSelectedFile()));
                    }
                } else {
                    try {
                        this.img = ImageIO.read(new File(this.commonValues.getSelectedFile()));
                    }
                    catch (Exception e) {
                        LogWriter.writeLog((String)("Exception " + e + "loading " + this.commonValues.getSelectedFile()));
                    }
                }
            }
            this.currentGUI.updateStatusMessage("opening file");
            if (fileCanBeOpened && this.decode_pdf.isEncrypted() && !this.decode_pdf.isFileViewable()) {
                fileCanBeOpened = false;
                String password = this.currentGUI.showInputDialog(Messages.getMessage((String)"PdfViewerPassword.message"));
                if (password != null) {
                    this.decode_pdf.setEncryptionPassword(password);
                    if (this.decode_pdf.isFileViewable()) {
                        fileCanBeOpened = true;
                    }
                }
                if (!fileCanBeOpened) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerPasswordRequired.message"));
                }
            }
            this.currentGUI.reinitialiseTabs();
            if (fileCanBeOpened) {
                this.commonValues.isContentExtractor();
                this.commonValues.setCurrentPage(1);
            }
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " opening file");
            ErrorDialog.showError(e, Messages.getMessage((String)"PdfViewerOpenerror"), this.currentGUI.getFrame());
            System.exit(1);
        }
        if (!this.decode_pdf.isOpen() && this.commonValues.isPDF()) {
            return false;
        }
        return fileCanBeOpened;
    }

    protected void openFile(String selectedFile) {
        String memFlag;
        String hiresFlag = System.getProperty("org.jpedal.hires");
        if (hiresFlag != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((memFlag = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        this.commonValues.setUseHiresImage(false);
        this.thumbnails.resetToDefault();
        this.currentGUI.setNoPagesDecoded();
        if (this.searchFrame != null) {
            this.searchFrame.removeSearchWindow(false);
        }
        this.commonValues.maxViewY = 0;
        String ending = selectedFile.toLowerCase().trim();
        this.commonValues.setPDF(ending.endsWith(".pdf") || ending.endsWith(".fdf"));
        this.currentGUI.setQualityBoxVisible(this.commonValues.isPDF());
        this.commonValues.setCurrentPage(1);
        boolean fileCanBeOpened = this.openUpFile(this.commonValues.getSelectedFile());
        try {
            if (fileCanBeOpened) {
                this.processPage();
            } else {
                this.currentGUI.setViewerTitle(Messages.getMessage((String)"PdfViewer.NoFile"));
                this.decode_pdf.clearScreen();
                this.currentGUI.zoom();
                this.commonValues.setPageCount(1);
                this.commonValues.setCurrentPage(1);
            }
        }
        catch (Exception e) {
            System.err.println(String.valueOf(Messages.getMessage((String)"PdfViewerError.Exception")) + " " + e + " " + Messages.getMessage((String)"PdfViewerError.DecodeFile"));
        }
    }

    protected void processPage() {
        if (this.commonValues.isPDF() && (this.decode_pdf.isOpen() || !this.commonValues.isPDF())) {
            PdfFileInformation currentFileInformation = this.decode_pdf.getFileInformationData();
            this.decode_pdf.setRenderMode(3);
            String[] values = currentFileInformation.getFieldValues();
            String[] fields = currentFileInformation.getFieldNames();
            String[] ocr = new String[]{"TeleForm", "dgn2pdf"};
            int i = 0;
            while (i < fields.length) {
                if (fields[i].equals("Creator") | fields[i].equals("Producer")) {
                    int j = 0;
                    while (j < ocr.length) {
                        if (values[i].equals(ocr[j])) {
                            this.decode_pdf.setRenderMode(2);
                            this.decode_pdf.setEnableLegacyJPEGConversion(true);
                        }
                        ++j;
                    }
                }
                boolean currentProcessingStatus = this.commonValues.isProcessing();
                this.commonValues.setProcessing(true);
                if (this.commonValues.isUseHiresImage()) {
                    this.decode_pdf.useHiResScreenDisplay(true);
                    this.currentGUI.setSelectedComboIndex(250, 1);
                } else {
                    this.decode_pdf.useHiResScreenDisplay(false);
                    this.currentGUI.setSelectedComboIndex(250, 0);
                }
                this.commonValues.setProcessing(currentProcessingStatus);
                ++i;
            }
        }
        this.commonValues.setPageCount(this.decode_pdf.getPageCount());
        if (!this.commonValues.isPDF()) {
            this.commonValues.setPageCount(1);
            this.decode_pdf.useHiResScreenDisplay(true);
        }
        if (this.commonValues.getPageCount() < this.commonValues.getCurrentPage()) {
            this.commonValues.setCurrentPage(this.commonValues.getPageCount());
            System.err.println(String.valueOf(this.commonValues.getCurrentPage()) + " out of range. Opening on last page");
            LogWriter.writeLog((String)(String.valueOf(this.commonValues.getCurrentPage()) + " out of range. Opening on last page"));
        }
        this.decode_pdf.setExtractionMode(1, 72, this.currentGUI.getScaling());
        this.currentGUI.setPageNumber();
        this.currentGUI.resetRotationBox();
        if (this.commonValues.isPDF()) {
            this.currentGUI.decodePage(true);
        } else {
            this.currentGUI.zoom();
            this.decode_pdf.setPDFBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.decode_pdf.disableBorderForPrinting();
            this.decodeImage(true);
            this.commonValues.setProcessing(false);
        }
    }

    public void selectFile() {
        if (this.searchFrame != null) {
            this.searchFrame.removeSearchWindow(false);
        }
        this.currentGUI.resetNavBar();
        JFileChooser chooser = new JFileChooser(this.commonValues.getInputDir());
        if (this.commonValues.getSelectedFile() != null) {
            chooser.setSelectedFile(new File(this.commonValues.getSelectedFile()));
        }
        chooser.setFileSelectionMode(0);
        String[] pdf = new String[]{"pdf"};
        String[] fdf = new String[]{"fdf"};
        String[] png = new String[]{"png", "tif", "tiff", "jpg", "jpeg"};
        chooser.addChoosableFileFilter(new FileFilterer(png, "Images (Tiff, Jpeg,Png)"));
        chooser.addChoosableFileFilter(new FileFilterer(fdf, "fdf (*.fdf)"));
        chooser.addChoosableFileFilter(new FileFilterer(pdf, "Pdf (*.pdf)"));
        int state = chooser.showOpenDialog(this.currentGUI.getFrame());
        File file = chooser.getSelectedFile();
        if (file != null && state == 0) {
            boolean isValid;
            String ext = file.getName().toLowerCase();
            boolean bl = isValid = ext.endsWith(".pdf") || ext.endsWith(".fdf") || ext.endsWith(".tif") || ext.endsWith(".tiff") || ext.endsWith(".png") || ext.endsWith(".jpg") || ext.endsWith(".jpeg");
            if (isValid) {
                try {
                    this.commonValues.setInputDir(chooser.getCurrentDirectory().getCanonicalPath());
                    this.open(file.getAbsolutePath());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else {
                this.decode_pdf.repaint();
                this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NotValidPdfWarning"));
            }
        } else {
            this.decode_pdf.repaint();
            this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerMessage.NoSelection"));
        }
    }

    private String selectURL() {
        String selectedFile = this.currentGUI.showInputDialog(Messages.getMessage((String)"PdfViewerMessage.RequestURL"));
        if (selectedFile != null) {
            selectedFile = selectedFile.trim();
        }
        if (selectedFile != null && !selectedFile.trim().startsWith("http://")) {
            this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerMessage.URLMustContain"));
            selectedFile = null;
        }
        if (selectedFile != null && !selectedFile.endsWith(".pdf")) {
            this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewer.NotValidPdfWarning"));
            selectedFile = null;
        }
        if (selectedFile != null) {
            this.commonValues.setSelectedFile(selectedFile);
            boolean failed = false;
            try {
                URL testExists = new URL(selectedFile);
                URLConnection conn = testExists.openConnection();
                if (conn.getContent() == null) {
                    failed = true;
                }
            }
            catch (Exception e) {
                failed = true;
            }
            if (failed) {
                selectedFile = null;
                this.currentGUI.showMessageDialog("URL " + selectedFile + " " + Messages.getMessage((String)"PdfViewerError.DoesNotExist"));
            }
        }
        if (selectedFile != null) {
            try {
                this.commonValues.setFileSize(0L);
                this.currentGUI.setViewerTitle(null);
            }
            catch (Exception e) {
                System.err.println(String.valueOf(Messages.getMessage((String)"PdfViewerError.Exception")) + " " + e + " " + Messages.getMessage((String)"PdfViewerError.GettingPaths"));
            }
            if (selectedFile != null && !this.commonValues.isProcessing()) {
                this.thumbnails.terminateDrawing();
                this.decode_pdf.flushObjectValues(true);
                this.decode_pdf.resetViewableArea();
                this.currentGUI.stopThumbnails();
                this.openFile(this.commonValues.getSelectedFile());
            }
        } else {
            this.decode_pdf.repaint();
            this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerMessage.NoSelection"));
        }
        return selectedFile;
    }

    private void forward(int count) {
        if (!this.commonValues.isProcessing()) {
            int updatedTotal = this.commonValues.getCurrentPage() + count;
            if (updatedTotal <= this.commonValues.getPageCount()) {
                if ((this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) && (updatedTotal & 1) == 1) {
                    if (updatedTotal < this.commonValues.getPageCount()) {
                        ++updatedTotal;
                    } else if (this.commonValues.getPageCount() - updatedTotal > 1) {
                        --updatedTotal;
                    }
                }
                this.commonValues.setCurrentPage(updatedTotal);
                this.currentGUI.setPageNumber();
                if (this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 4) {
                    this.currentGUI.decodePage(false);
                    return;
                }
                this.currentGUI.resetStatusMessage("Loading Page " + this.commonValues.getCurrentPage());
                this.decode_pdf.setPageParameters(this.currentGUI.getScaling(), this.commonValues.getCurrentPage());
                this.currentGUI.decodePage(false);
            }
        } else {
            this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerDecodeWait.message"));
        }
    }

    private void back(int count) {
        if (!this.commonValues.isProcessing()) {
            int updatedTotal = this.commonValues.getCurrentPage() - count;
            if (updatedTotal >= 1) {
                if ((this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) && (updatedTotal & 1) == 1 && updatedTotal != 1) {
                    --updatedTotal;
                }
                this.commonValues.setCurrentPage(updatedTotal);
                this.currentGUI.setPageNumber();
                if (this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 4) {
                    this.currentGUI.decodePage(false);
                    return;
                }
                this.currentGUI.resetStatusMessage("loading page " + this.commonValues.getCurrentPage());
                this.decode_pdf.setPageParameters(this.currentGUI.getScaling(), this.commonValues.getCurrentPage());
                this.currentGUI.decodePage(false);
            }
        } else {
            this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerDecodeWait.message"));
        }
    }

    public void gotoPage(String page) {
        int newPage;
        try {
            newPage = Integer.parseInt(page);
            if ((this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) && (newPage & 1) == 1 && newPage != 1) {
                --newPage;
            }
            if (newPage > this.decode_pdf.getPageCount() | newPage < 1) {
                this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage((String)"PdfViewerPageLabel.text")) + " " + page + " " + Messages.getMessage((String)"PdfViewerOutOfRange.text") + " " + this.decode_pdf.getPageCount());
                newPage = this.commonValues.getCurrentPage();
                this.currentGUI.setPageNumber();
            }
        }
        catch (Exception e) {
            this.currentGUI.showMessageDialog(">" + page + "< " + Messages.getMessage((String)"PdfViewerInvalidNumber.text"));
            newPage = this.commonValues.getCurrentPage();
            this.currentGUI.pageCounter2.setText("" + this.commonValues.getCurrentPage());
        }
        if (!this.commonValues.isProcessing() && this.commonValues.getCurrentPage() != newPage) {
            this.commonValues.setCurrentPage(newPage);
            this.currentGUI.decodePage(false);
        }
    }

    public void open(String file) {
        this.currentGUI.resetNavBar();
        boolean isURL = file.startsWith("http:");
        try {
            if (!isURL) {
                this.fileIsURL = false;
                this.commonValues.setFileSize(new File(file).length() >> 10);
            } else {
                this.fileIsURL = true;
            }
            this.commonValues.setSelectedFile(file);
            this.currentGUI.setViewerTitle(null);
        }
        catch (Exception e) {
            LogWriter.writeLog((String)("Exception " + e + " getting paths"));
        }
        File testFile = new File(this.commonValues.getSelectedFile());
        if (!isURL && !testFile.exists()) {
            this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage((String)"PdfViewerFile.text")) + this.commonValues.getSelectedFile() + Messages.getMessage((String)"PdfViewerNotExist"));
        } else if (this.commonValues.getSelectedFile() != null && !this.commonValues.isProcessing()) {
            this.currentGUI.stopThumbnails();
            this.decode_pdf.flushObjectValues(true);
            this.decode_pdf.resetViewableArea();
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    if (!Commands.this.isOpening) {
                        Commands.this.isOpening = true;
                        Commands.this.openFile(Commands.this.commonValues.getSelectedFile());
                        Commands.this.isOpening = false;
                    }
                    return null;
                }
            };
            worker.start();
        }
    }

    private void saveFile() {
        File file = null;
        String fileToSave = "";
        boolean finished = false;
        while (!finished) {
            JFileChooser chooser = new JFileChooser(this.commonValues.getInputDir());
            chooser.setSelectedFile(new File(String.valueOf(this.commonValues.getInputDir()) + "/" + this.commonValues.getSelectedFile()));
            chooser.addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
            chooser.addChoosableFileFilter(new FileFilterer(new String[]{"fdf"}, "fdf (*.fdf)"));
            chooser.setFileSelectionMode(0);
            int approved = chooser.showSaveDialog(null);
            if (approved == 0) {
                int n;
                FileInputStream fis = null;
                FileOutputStream fos = null;
                file = chooser.getSelectedFile();
                fileToSave = file.getAbsolutePath();
                if (!fileToSave.endsWith(".pdf")) {
                    fileToSave = String.valueOf(fileToSave) + ".pdf";
                    file = new File(fileToSave);
                }
                if (fileToSave.equals(this.commonValues.getSelectedFile())) {
                    return;
                }
                if (file.exists() && (n = this.currentGUI.showConfirmDialog(String.valueOf(fileToSave) + "\n" + Messages.getMessage((String)"PdfViewerMessage.FileAlreadyExists") + "\n" + Messages.getMessage((String)"PdfViewerMessage.ConfirmResave"), Messages.getMessage((String)"PdfViewerMessage.Resave"), 0)) == 1) continue;
                try {
                    int bytes_read;
                    fis = new FileInputStream(this.commonValues.getSelectedFile());
                    fos = new FileOutputStream(fileToSave);
                    byte[] buffer = new byte[4096];
                    while ((bytes_read = fis.read(buffer)) != -1) {
                        fos.write(buffer, 0, bytes_read);
                    }
                }
                catch (Exception e1) {
                    this.currentGUI.showMessageDialog(Messages.getMessage((String)"PdfViewerException.NotSaveInternetFile"));
                }
                try {
                    fis.close();
                    fos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                finished = true;
                continue;
            }
            return;
        }
    }

    private void exit() {
        this.thumbnails.terminateDrawing();
        this.handleUnsaveForms();
        this.currentGUI.showConfirmDialog(new JLabel(Messages.getMessage((String)"PdfViewerExiting")), Messages.getMessage((String)"PdfViewerprogramExit"), -1, -1);
        this.decode_pdf.closePdfFile();
        this.flush();
        System.exit(1);
    }

    public final void flush() {
        File temp_files;
        String[] file_list;
        String target = this.commonValues.getTarget();
        if (target != null && (file_list = (temp_files = new File(target)).list()) != null) {
            int ii = 0;
            while (ii < file_list.length) {
                File delete_file = new File(String.valueOf(target) + this.commonValues.getSeparator() + file_list[ii]);
                delete_file.delete();
                ++ii;
            }
        }
    }

    public boolean openPDF(InputStream is) {
        this.currentGUI.resetNavBar();
        this.currentGUI.stopThumbnails();
        this.decode_pdf.flushObjectValues(true);
        this.thumbnails.resetToDefault();
        this.currentGUI.setNoPagesDecoded();
        if (this.searchFrame != null) {
            this.searchFrame.removeSearchWindow(false);
        }
        this.commonValues.setPDF(true);
        this.commonValues.maxViewY = 0;
        this.commonValues.setSelectedFile("stream");
        this.decode_pdf.closePdfFile();
        this.decode_pdf.clearScreen();
        this.flush();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = is.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
            is.close();
            out.close();
            this.decode_pdf.openPdfArray(out.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (PdfException e) {
            e.printStackTrace();
            return false;
        }
        this.currentGUI.reinitThumbnails();
        this.currentGUI.reinitialiseTabs();
        this.commonValues.setCurrentPage(1);
        try {
            this.decode_pdf.decodePage(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.decode_pdf.invalidate();
        this.commonValues.setCurrentPage(1);
        this.processPage();
        this.currentGUI.goToFirstPage();
        return true;
    }

    public void extractText() {
        final JDialog displayFrame = new JDialog((Frame)this.currentGUI.getMyFrame(), true);
        int t_x1 = this.commonValues.m_x1;
        int t_x2 = this.commonValues.m_x2;
        int t_y1 = this.commonValues.m_y1;
        int t_y2 = this.commonValues.m_y2;
        if (t_y1 < t_y2) {
            t_y2 = this.commonValues.m_y1;
            t_y1 = this.commonValues.m_y2;
        }
        if (t_x1 > t_x2) {
            t_x2 = this.commonValues.m_x1;
            t_x1 = this.commonValues.m_x2;
        }
        String xmlText = null;
        String text = null;
        try {
            PdfGroupingAlgorithms currentGrouping = this.decode_pdf.getGroupingObject();
            xmlText = currentGrouping.extractTextInRectangle(t_x1 - 3, t_y1 + 3, t_x2 + 6, t_y2 - 6, this.commonValues.getCurrentPage(), false, true);
            if (xmlText != null) {
                text = Strip.stripXML((String)xmlText).toString();
            }
        }
        catch (PdfException e) {
            e.printStackTrace();
        }
        final BufferedImage snapShot = this.decode_pdf.getSelectedRectangleOnscreen(t_x1, t_y1, t_x2, t_y2, 100.0f);
        JTabbedPane display = new JTabbedPane();
        if (text != null) {
            JPanel text_display = new JPanel();
            text_display.setLayout(new BorderLayout());
            final JTextPane textPane = new JTextPane();
            JScrollPane textScroll = new JScrollPane();
            try {
                textScroll = this.currentGUI.createPane(textPane, text, true);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
            textScroll.setVerticalScrollBarPolicy(20);
            textScroll.setHorizontalScrollBarPolicy(30);
            textScroll.setPreferredSize(new Dimension(400, 400));
            text_display.add((Component)textScroll, "Center");
            JPanel textButtonBar = new JPanel();
            textButtonBar.setLayout(new BorderLayout());
            JButton btn_copytext = new JButton(this.CONFIG.getText("ExtractBox_btn_copytext"));
            textButtonBar.add((Component)btn_copytext, "West");
            btn_copytext.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    textPane.selectAll();
                    textPane.copy();
                }
            });
            text_display.add((Component)textButtonBar, "South");
            display.addTab(this.CONFIG.getText("ExtractBox_tab_text"), text_display);
        }
        JPanel image_display = new JPanel();
        image_display.setLayout(new BorderLayout());
        if (snapShot == null) {
            return;
        }
        JScrollPane imageScroll = new JScrollPane();
        imageScroll.setVerticalScrollBarPolicy(20);
        imageScroll.setHorizontalScrollBarPolicy(30);
        imageScroll.getVerticalScrollBar().setUnitIncrement(80);
        imageScroll.getHorizontalScrollBar().setUnitIncrement(80);
        imageScroll.getViewport().add(new JLabel(new IconiseImage(snapShot)));
        imageScroll.setPreferredSize(new Dimension(400, 400));
        image_display.add((Component)imageScroll, "Center");
        JPanel imageButtonBar = new JPanel();
        imageButtonBar.setLayout(new BorderLayout());
        JButton btn_saveimage = new JButton(this.CONFIG.getText("ExtractBox_btn_saveimage"));
        imageButtonBar.add((Component)btn_saveimage, "West");
        btn_saveimage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.addChoosableFileFilter(new FileFilter(this){
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        return f.getName().toLowerCase().endsWith(".jpg");
                    }

                    public String getDescription() {
                        return "JPG";
                    }
                });
                fc.setMultiSelectionEnabled(false);
                if (fc.showSaveDialog(displayFrame) == 0) {
                    File bild = fc.getSelectedFile();
                    if (!bild.getAbsolutePath().toLowerCase().endsWith(".jpg")) {
                        bild = new File(bild.getAbsoluteFile() + ".jpg");
                    }
                    int check = 0;
                    if (bild.exists()) {
                        check = Commands.this.currentGUI.showConfirmDialog(Commands.this.CONFIG.getText("msg_overwrite"), Commands.this.CONFIG.getText("msg_question"), 0);
                    }
                    if (check == 0) {
                        try {
                            ImageIO.write((RenderedImage)snapShot, "jpeg", bild);
                            Commands.this.currentGUI.showMessageDialog(Commands.this.CONFIG.getText("msg_imagesaved"));
                        }
                        catch (IOException e1) {
                            Commands.this.currentGUI.showMessageDialog(Commands.this.CONFIG.getText("msg_imageerror"));
                        }
                    }
                }
            }
        });
        image_display.add((Component)imageButtonBar, "South");
        display.addTab(this.CONFIG.getText("ExtractBox_tab_grafik"), image_display);
        displayFrame.setLocationRelativeTo(null);
        displayFrame.setLocation(this.currentGUI.getFrame().getLocationOnScreen().x + 10, this.currentGUI.getFrame().getLocationOnScreen().y + 10);
        displayFrame.setSize(450, 450);
        displayFrame.setTitle(this.CONFIG.getText("ExtractBox_title"));
        displayFrame.getContentPane().setLayout(new BorderLayout());
        displayFrame.getContentPane().add((Component)display, "Center");
        displayFrame.show();
    }
}

