/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jpedal.Display;
import org.jpedal.PageOffsets;
import org.jpedal.PdfDecoder;
import org.jpedal.SingleDisplay;
import org.jpedal.gui.Hotspots;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PageLines;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.objects.PdfFormData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Shape;

public class PdfPanel
extends JPanel {
    private static final long serialVersionUID = -5480323101993399978L;
    public JPanel[] extraButton;
    public boolean useParentButtons = false;
    int[] highlightedImage = null;
    private boolean ImageExtractionAllowed = true;
    protected Display pages;
    protected PdfFormData currentAcroFormData;
    protected PdfAnnots annotsData;
    protected AcroRenderer formRenderer;
    Hotspots displayHotspots;
    Hotspots printHotspots;
    protected PageLines pageLines;
    public static Color highlightColor = Color.blue;
    public static Color backgroundColor = null;
    protected Rectangle[] alternateOutlines;
    String altName;
    private int lastIndent = -1;
    PageOffsets currentOffset;
    protected boolean renderPage = false;
    protected boolean isPrintAutoRotateAndCenter = false;
    protected boolean usePDFPaperSize = false;
    protected int pageScalingMode = 2;
    protected int displayView = 1;
    private int scrollInterval = 10;
    protected int pageCount = 0;
    private boolean showCrop = false;
    private boolean isNewRotationSet = false;
    protected boolean displayViewportBorder = false;
    protected boolean isDecoding = false;
    protected boolean stopDecoding = false;
    protected int alignment = 1;
    protected int displayRotation = 0;
    private Point current_p;
    protected Rectangle viewableArea = null;
    private Vector_Int merge_level;
    private Vector_Shape merge_outline;
    private boolean[] showDebugLevel;
    private Color[] debugColors;
    private boolean showMerging = false;
    AffineTransform demoAf = null;
    private RepaintManager currentManager = RepaintManager.currentManager(this);
    protected int pageNumber = 1;
    protected AffineTransform displayScaling;
    protected AffineTransform viewScaling = null;
    public boolean showAnnotations = true;
    protected boolean formsAvailable = true;
    protected PdfPageData pageData = new PdfPageData();
    private Rectangle lastHighlight = null;
    protected Rectangle cursorBoxOnScreen = null;
    protected Rectangle lastCursorBoxOnScreen = null;
    private boolean drawCrossHairs = false;
    private int boxContained = -1;
    private Color selectedHandleColor = Color.red;
    private int handlesGap = 5;
    private Color outlineColor;
    protected Rectangle currentHighlightedObject = null;
    private Color outlineHighlightColor;
    private Color[] highlightColors;
    private static final int strip = 2;
    private Rectangle2D[] outlineZone = null;
    private int[] processedByRegularExpression = null;
    protected int insetW = 0;
    protected int insetH = 0;
    private boolean[] highlightedZonesSelected = null;
    private boolean[] hasDrownedObjects = null;
    Rectangle userAnnot = null;
    private int defaultSize;
    private int y_size = this.defaultSize = 100;
    private int max_y;
    private int max_x;
    private int x_size = this.defaultSize;
    int[] cx = null;
    int[] cy = null;
    protected float scaling = 1.0f;
    private int highlightMode = 0;
    public static final int SHOW_OBJECTS = 1;
    public static final int SHOW_LINES = 2;
    public static final int SHOW_BOXES = 4;
    protected int size = 20;
    protected Font highlightFont = null;
    protected Border myBorder = null;
    protected DropTarget dropTarget = null;
    protected ObjectStore objectStoreRef = new ObjectStore();
    protected DynamicVectorRenderer currentDisplay = new DynamicVectorRenderer(1, this.objectStoreRef, false);
    Map userAnnotIcons;
    protected boolean useBorder = true;
    private int[] selectionOrder;
    private Rectangle[] areas;
    private Object[] linkedItems;
    private Object[] children;
    private int[] parents;
    protected boolean useAcceleration = true;
    private Shape[] fragmentShapes;
    private int x_size_cropped;
    private int y_size_cropped;
    private AffineTransform cursorAf;
    private Rectangle actualBox;
    private boolean drawInteractively = false;
    protected int lastFormPage = -1;
    protected int lastStart = -1;
    protected int lastEnd = -1;
    private int pageUsedForTransform;
    protected int additionalPageCount = 0;
    protected int xOffset = 0;
    private boolean displayForms = true;

    public void initNonPDF(PdfDecoder pdf) {
        this.pages = new SingleDisplay(this.pageNumber, this.pageCount, this.currentDisplay);
        this.pages.setup(true, null, pdf);
    }

    public Rectangle getCombinedAreas(Rectangle targetRectangle, boolean justText) {
        if (this.currentDisplay != null) {
            return this.currentDisplay.getCombinedAreas(targetRectangle, justText);
        }
        return null;
    }

    public final void addMergingDisplayForDebugging(Vector_Int merge_level, Vector_Shape merge_outline, int count, Color[] colors) {
        this.merge_level = merge_level;
        this.merge_outline = merge_outline;
        this.showDebugLevel = new boolean[count];
        this.debugColors = colors;
    }

    public final void setDebugView(int level, boolean enabled) {
        if (this.showDebugLevel != null) {
            this.showDebugLevel[level] = enabled;
        }
    }

    public final BufferedImage getPageAsThumbnail(int height, DynamicVectorRenderer currentDisplay) {
        if (currentDisplay == null) {
            currentDisplay = this.currentDisplay;
            ObjectStore.cachePage((Integer)new Integer(this.pageNumber), (DynamicVectorRenderer)currentDisplay);
        }
        BufferedImage image = this.getImageFromRenderer(height, currentDisplay, this.pageNumber);
        return image;
    }

    protected BufferedImage getImageFromRenderer(int height, DynamicVectorRenderer rend, int pageNumber) {
        int mediaBoxH = this.pageData.getMediaBoxHeight(pageNumber);
        int mediaBoxX = this.pageData.getMediaBoxX(pageNumber);
        int mediaBoxY = this.pageData.getMediaBoxY(pageNumber);
        int crw = this.pageData.getCropBoxWidth(pageNumber);
        int crh = this.pageData.getCropBoxHeight(pageNumber);
        int crx = this.pageData.getCropBoxX(pageNumber);
        int cry = this.pageData.getCropBoxY(pageNumber);
        if (cry > 0) {
            cry = mediaBoxH - crh - cry;
        }
        float scale = (float)height / (float)crh;
        int rotation = this.pageData.getRotation(pageNumber);
        int dr = -1;
        if (rotation == 90 | rotation == 270) {
            int tmp = crw;
            crw = crh;
            crh = tmp;
            dr = 1;
            tmp = crx;
            crx = cry;
            cry = tmp;
        }
        AffineTransform scaleAf = this.getScalingForImage(pageNumber, rotation, scale);
        int cx = mediaBoxX - crx;
        int cy = mediaBoxY - cry;
        scaleAf.translate(cx, dr * cy);
        return rend.getPageAsImage(scale, crx, cry, crw, crh, pageNumber, scaleAf, 1);
    }

    public final void setHighlightedZones(int mode, int[] cx, int[] cy, Shape[] fragmentShapes, Object[] linkedItems, int[] parents, Object[] childItems, int[] childParents, Rectangle2D[] outlineZone, boolean[] highlightedZonesSelected, boolean[] hasDrownedObjects, Color[] highlightColors, int[] selectionOrder, int[] processedByRegularExpression) {
        this.cx = cx;
        this.cy = cy;
        this.fragmentShapes = fragmentShapes;
        this.linkedItems = linkedItems;
        this.parents = parents;
        this.children = childItems;
        this.outlineZone = outlineZone;
        this.processedByRegularExpression = processedByRegularExpression;
        this.highlightedZonesSelected = highlightedZonesSelected;
        this.hasDrownedObjects = hasDrownedObjects;
        this.highlightMode = mode;
        this.highlightColors = highlightColors;
        this.selectionOrder = selectionOrder;
        this.alternateOutlines = null;
    }

    public void setDebugDisplay(boolean isEnabled) {
        this.showMerging = isEnabled;
    }

    public final void setInset(int width, int height) {
        this.insetW = width;
        this.insetH = height;
    }

    public void ensurePointIsVisible(Point p) {
        super.scrollRectToVisible(new Rectangle(p.x, this.y_size - p.y, this.scrollInterval, this.scrollInterval));
    }

    public final Dimension getMaximumSize() {
        Dimension pageSize = null;
        if (this.displayView != 1) {
            pageSize = this.pages.getPageSize(this.displayView);
        }
        if (pageSize == null) {
            pageSize = this.displayRotation == 90 | this.displayRotation == 270 ? new Dimension((int)((float)(this.y_size_cropped + this.insetW + this.insetW) + (float)this.xOffset * this.scaling + (float)(this.additionalPageCount * (this.insetW + this.insetW))), this.x_size_cropped + this.insetH + this.insetH) : new Dimension((int)((float)(this.x_size_cropped + this.insetW + this.insetW) + (float)this.xOffset * this.scaling + (float)(this.additionalPageCount * (this.insetW + this.insetW))), this.y_size_cropped + this.insetH + this.insetH);
        }
        return pageSize;
    }

    public final Dimension getMinimumSize() {
        return new Dimension(100 + this.insetW, 100 + this.insetH);
    }

    public Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    public void setFoundTextArea(Rectangle rectArea) {
        if (rectArea == null) {
            this.areas = null;
        }
        if (this.areas != null) {
            boolean matchFound = false;
            int size = this.areas.length;
            int i = 0;
            while (i < size) {
                if (this.areas[i] != null && this.areas[i].x == rectArea.x && this.areas[i].x == rectArea.x && this.areas[i].width == rectArea.width && this.areas[i].height == rectArea.height) {
                    matchFound = true;
                    i = size;
                }
                ++i;
            }
            if (!matchFound) {
                int newSize = this.areas.length + 1;
                Rectangle[] newAreas = new Rectangle[newSize];
                int i2 = 1;
                while (i2 < newSize) {
                    if (this.areas[i2 - 1] != null) {
                        newAreas[i2] = new Rectangle(this.areas[i2 - 1].x, this.areas[i2 - 1].y, this.areas[i2 - 1].width, this.areas[i2 - 1].height);
                    }
                    ++i2;
                }
                this.areas = newAreas;
                this.areas[0] = new Rectangle(rectArea.x, rectArea.y, rectArea.width, rectArea.height);
            }
        } else {
            this.areas = new Rectangle[1];
            this.areas[0] = rectArea;
        }
        this.pages.refreshDisplay();
    }

    public void removeFoundTextArea(Rectangle rectArea) {
        if (rectArea == null || this.areas == null) {
            return;
        }
        int size = this.areas.length;
        int i = 0;
        while (i < size) {
            if (this.areas[i] != null && this.areas[i].x == rectArea.x && this.areas[i].y == rectArea.y && this.areas[i].width == rectArea.width && this.areas[i].height == rectArea.height) {
                this.areas[i] = null;
                i = size;
            }
            ++i;
        }
        this.pages.refreshDisplay();
    }

    public void removeFoundTextAreas(Rectangle[] rectArea) {
        if (rectArea == null) {
            this.areas = null;
        } else {
            int count = rectArea.length;
            int ii = 0;
            while (ii < count) {
                this.removeFoundTextArea(rectArea[ii]);
                ++ii;
            }
        }
        this.pages.refreshDisplay();
    }

    public void setFoundTextAreas(Rectangle[] newAreas) {
        if (this.displayView != 1) {
            this.areas = null;
            return;
        }
        if (newAreas != null) {
            int count = newAreas.length;
            int ii = 0;
            while (ii < count) {
                this.setFoundTextArea(newAreas[ii]);
                ++ii;
            }
        } else {
            this.areas = null;
        }
        this.pages.refreshDisplay();
    }

    public void setHighlightedAreas(Rectangle[] areas) {
        this.setFoundTextAreas(areas);
    }

    public final String getToolTipText(MouseEvent e) {
        String result = null;
        Point raw_p = e.getPoint();
        this.current_p = new Point((int)((raw_p.getX() - (double)this.insetW) / (double)this.scaling), (int)(((double)(this.y_size + this.insetH) - raw_p.getY()) / (double)this.scaling));
        if (this.displayHotspots != null) {
            result = this.displayHotspots.getTooltip(this.current_p, this.userAnnotIcons, this.pageNumber);
        }
        return result;
    }

    public final void updateCursorBoxOnScreen(Rectangle newOutlineRectangle, Color outlineColor) {
        if (this.displayView != 1) {
            return;
        }
        int x_size = this.x_size;
        int y_size = this.y_size;
        if (newOutlineRectangle != null) {
            int diff;
            int x = newOutlineRectangle.x;
            int y = newOutlineRectangle.y;
            int w = newOutlineRectangle.width;
            int h = newOutlineRectangle.height;
            int cropX = this.pageData.getCropBoxX(this.pageNumber);
            int cropY = this.pageData.getCropBoxY(this.pageNumber);
            int cropW = this.pageData.getCropBoxWidth(this.pageNumber);
            int cropH = this.pageData.getCropBoxHeight(this.pageNumber);
            if (x < cropX) {
                diff = cropX - x;
                w -= diff;
                x = cropX;
            }
            if (y < cropY) {
                diff = cropY - y;
                h -= diff;
                y += diff;
            }
            if (x + w > cropW + cropX + this.xOffset) {
                w = cropX + this.xOffset + cropW - x;
            }
            if (y + h > cropY + cropH) {
                h = cropY + cropH - y;
            }
            this.cursorBoxOnScreen = new Rectangle(x, y, w, h);
        } else {
            this.cursorBoxOnScreen = null;
        }
        this.outlineColor = outlineColor;
        int strip = 30;
        int dx = 0;
        if (this.alignment == 2) {
            int width = this.getBounds().width;
            int pdfWidth = this.getPDFWidth();
            if (this.displayView != 1) {
                pdfWidth = (int)this.pages.getPageSize(this.displayView).getWidth();
            }
            dx = (width - pdfWidth) / 2;
        }
        if (this.lastCursorBoxOnScreen != null) {
            if (this.displayRotation == 0 || this.displayRotation == 180) {
                this.currentManager.addDirtyRegion(this, this.insetW + dx, this.insetH, x_size + 5 + this.xOffset, y_size);
            } else {
                this.currentManager.addDirtyRegion(this, this.insetH + dx, this.insetW, y_size + 5 + this.xOffset, x_size);
            }
            this.lastCursorBoxOnScreen = null;
        }
        if (this.cursorBoxOnScreen != null) {
            this.currentManager.addDirtyRegion(this, (int)((float)this.cursorBoxOnScreen.x * this.scaling) - strip, (int)((float)(this.max_y - this.cursorBoxOnScreen.y - this.cursorBoxOnScreen.height) * this.scaling) - strip, (int)((float)this.cursorBoxOnScreen.width * this.scaling) + strip + strip, (int)((float)this.cursorBoxOnScreen.height * this.scaling) + strip + strip);
        }
        if (this.viewScaling != null) {
            this.currentManager.markCompletelyDirty(this);
        }
    }

    public void repaintArea(Rectangle screenBox, int maxY) {
        int strip = 10;
        if (strip < this.insetH) {
            strip = this.insetH;
        }
        if (strip < this.insetW) {
            strip = this.insetW;
        }
        this.currentManager.addDirtyRegion(this, (int)((float)screenBox.x * this.scaling) - strip, (int)((float)(maxY - screenBox.y - screenBox.height) * this.scaling) - strip, (int)((float)(screenBox.x + screenBox.width) * this.scaling) + strip + strip, (int)((float)(screenBox.y + screenBox.height) * this.scaling) + strip + strip);
    }

    public final void removeHiglightedObject() {
        if (this.lastHighlight != null) {
            this.currentManager.addDirtyRegion(this, this.lastHighlight.x - 2, this.lastHighlight.y - 2, this.lastHighlight.width + 2 + 2, this.lastHighlight.height + 2 + 2);
            this.currentHighlightedObject = null;
        }
    }

    public final void addHiglightedObject(Rectangle currentShape, Color outlineHighlightColor) {
        if (this.displayView != 1) {
            return;
        }
        this.currentHighlightedObject = currentShape;
        this.outlineHighlightColor = outlineHighlightColor;
        if (this.currentHighlightedObject != null && this.currentHighlightedObject != this.lastHighlight) {
            this.currentManager.addDirtyRegion(this, this.currentHighlightedObject.x - 2, this.currentHighlightedObject.y - 2, this.currentHighlightedObject.width + 2 + 2, this.currentHighlightedObject.height + 2 + 2);
            this.lastHighlight = this.currentHighlightedObject;
        }
    }

    public void paint(Graphics g) {
        try {
            super.paint(g);
            if (!this.isDecoding && this.cursorBoxOnScreen != null) {
                Graphics2D g2 = (Graphics2D)g;
                AffineTransform defaultAf = g2.getTransform();
                if (this.cursorAf != null) {
                    g2.setTransform(this.cursorAf);
                    Shape clip = g2.getClip();
                    if (this.alignment == 2 && clip != null) {
                        g2.setClip(null);
                    }
                    this.paintRectangle(g2);
                    g2.setClip(clip);
                    g2.setTransform(defaultAf);
                }
            }
        }
        catch (Exception e) {
            this.pages.stopGeneratingPage();
            this.pages.flushPageCaches();
        }
        catch (Error err) {
            this.pages.flushPageCaches();
            this.pages.stopGeneratingPage();
            this.paint(g);
        }
    }

    public void paintComponent(Graphics g) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.threadSafePaint(g);
        } else {
            final Graphics g2 = g;
            Runnable doPaintComponent = new Runnable(){

                public void run() {
                    PdfPanel.this.threadSafePaint(g2);
                }
            };
            SwingUtilities.invokeLater(doPaintComponent);
        }
    }

    private void threadSafePaint(Graphics g) {
        super.paintComponent(g);
        if (this.displayScaling == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform rawAf = g2.getTransform();
        if (this.formsAvailable && this.renderPage && !this.stopDecoding && this.displayForms) {
            int start = this.pageNumber;
            int end = this.pageNumber;
            if (this.displayView != 1) {
                start = this.pages.getStartPage();
                end = this.pages.getEndPage();
                if (start == 0 || end == 0 || this.lastEnd != end || this.lastStart != start) {
                    this.lastFormPage = -1;
                }
                this.lastEnd = end;
                this.lastStart = start;
            }
            if (this.lastFormPage != this.pageNumber && !this.stopDecoding && !this.isDecoding && this.formRenderer != null) {
                this.formRenderer.displayComponentsOnscreen(start, end);
                if (this.formRenderer.getCompData().getStartComponentCountForPage(this.pageNumber) != -1) {
                    this.lastFormPage = this.pageNumber;
                }
            }
        }
        if (DynamicVectorRenderer.debugPaint) {
            System.err.println("threadsafePaint called " + this.displayView);
        }
        this.pages.init(this.scaling, this.pageCount, this.displayRotation, this.pageNumber, this.currentDisplay, false, this.pageData, this.insetW, this.insetH);
        int indent = 0;
        if (this.alignment == 2) {
            int width = this.getBounds().width;
            int pdfWidth = this.getPDFWidth();
            if (this.displayView != 1) {
                pdfWidth = (int)this.pages.getPageSize(this.displayView).getWidth();
            }
            if (width > pdfWidth) {
                indent = (width - pdfWidth) / 2;
                if (this.displayView == 1) {
                    this.lastIndent = indent;
                } else if (this.displayView == 2 && this.lastIndent != -1) {
                    indent = this.lastIndent;
                    this.lastIndent = -1;
                } else {
                    this.lastIndent = -1;
                }
                g2.translate(indent, 0);
            }
            if (this.formsAvailable && this.formRenderer != null) {
                this.formRenderer.getCompData().resetScaledLocation(this.scaling, this.displayRotation, indent);
            }
        }
        Rectangle dirtyRegion = null;
        this.pages.initRenderer(this.areas, g2, this.myBorder, indent);
        if (!this.isDecoding || this.drawInteractively) {
            this.actualBox = this.pages.drawPage(this.viewScaling, this.displayScaling, this.pageUsedForTransform);
        } else {
            this.currentDisplay.paintBackground(g2, dirtyRegion);
        }
        if (this.displayView == 1) {
            if (this.currentHighlightedObject == null && this.lastHighlight != null) {
                this.lastHighlight = null;
            }
            if (this.viewScaling != null) {
                g2.transform(this.viewScaling);
            }
            if (this.highlightedZonesSelected != null) {
                this.paintHighlights(g2);
            }
            if (this.displayHotspots != null) {
                this.displayHotspots.addHotspotsToDisplay(g2, this.userAnnotIcons, this.pageNumber);
            }
            if (this.merge_level != null && this.showMerging) {
                this.paintMergingInfo(g2);
            }
            if (this.cursorBoxOnScreen != null) {
                this.cursorAf = g2.getTransform();
            } else {
                this.actualBox = null;
            }
            this.pages.resetToDefaultClip();
            if (this.currentHighlightedObject != null) {
                g2.setColor(this.outlineHighlightColor);
                g2.draw(this.currentHighlightedObject);
            }
            if (this.showCrop) {
                g2.setColor(Color.orange);
                this.pages.completeForm(g2);
            }
        }
        if (this.highlightedImage != null) {
            int x = (int)((float)this.highlightedImage[0] * this.scaling);
            int y = (int)((float)this.highlightedImage[1] * this.scaling);
            int w = (int)((float)this.highlightedImage[2] * this.scaling);
            int h = (int)((float)this.highlightedImage[3] * this.scaling);
            if (w < 0) {
                w = -w;
                x -= w;
            }
            if (h < 0) {
                h = -h;
                y -= h;
            }
            int finalX = x;
            int finalY = y;
            int finalW = w;
            int finalH = h;
            if (this.displayRotation == 90) {
                finalH = w;
                finalW = h;
                finalX = this.insetW + y;
                finalY = this.insetH + x;
            } else if (this.displayRotation == 180) {
                finalX = (int)((float)this.max_x * this.scaling - (float)x - (float)w) + this.insetW;
                finalY = this.insetH + y;
            } else if (this.displayRotation == 270) {
                finalH = w;
                finalW = h;
                finalY = (int)((float)this.max_x * this.scaling - (float)x - (float)w) + this.insetW;
                finalX = (int)((float)this.max_y * this.scaling - (float)y - (float)h) + this.insetH;
            } else {
                finalX = this.insetW + x;
                finalY = (int)((float)this.max_y * this.scaling - (float)y - (float)h) + this.insetH;
            }
            Color oldColor = g2.getColor();
            Composite oldComposite = g2.getComposite();
            Stroke oldStroke = g2.getStroke();
            g2.setColor(Color.BLUE);
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawRect(finalX, finalY, finalW, finalH);
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g2.fillRect(finalX, finalY, finalW, finalH);
            g2.setColor(oldColor);
            g2.setComposite(oldComposite);
            g2.setStroke(oldStroke);
        }
        this.pages.drawBorder();
        g2.setTransform(rawAf);
    }

    public void scrollRectToHighlight(Rectangle highlight) {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        int cropW = this.pageData.getCropBoxWidth(this.pageNumber);
        int cropH = this.pageData.getCropBoxHeight(this.pageNumber);
        int cropX = this.pageData.getCropBoxX(this.pageNumber);
        int cropY = this.pageData.getCropBoxY(this.pageNumber);
        switch (this.displayRotation) {
            case 0: {
                x = (int)((float)(highlight.x - cropX) * this.scaling) + this.insetW;
                y = (int)((float)(cropH - (highlight.y - cropY)) * this.scaling) + this.insetH;
                w = (int)((float)highlight.width * this.scaling);
                h = (int)((float)highlight.height * this.scaling);
                break;
            }
            case 90: {
                x = (int)((float)(highlight.y - cropY) * this.scaling) + this.insetH;
                y = (int)((float)(highlight.x - cropX) * this.scaling) + this.insetW;
                w = (int)((float)highlight.height * this.scaling);
                h = (int)((float)highlight.width * this.scaling);
                break;
            }
            case 180: {
                x = (int)((float)(cropW - (highlight.x - cropX)) * this.scaling) + this.insetW;
                y = (int)((float)(highlight.y - cropY) * this.scaling) + this.insetH;
                w = (int)((float)highlight.width * this.scaling);
                h = (int)((float)highlight.height * this.scaling);
                break;
            }
            case 270: {
                x = (int)((float)(cropH - (highlight.y - cropY)) * this.scaling) + this.insetH;
                y = (int)((float)(cropW - (highlight.x - cropX)) * this.scaling) + this.insetW;
                w = (int)((float)highlight.height * this.scaling);
                h = (int)((float)highlight.width * this.scaling);
            }
        }
        Rectangle scrollto = new Rectangle(x - this.scrollInterval, y - this.scrollInterval, w + this.scrollInterval * 2, h + this.scrollInterval * 2);
        super.scrollRectToVisible(scrollto);
    }

    private void paintMergingInfo(Graphics2D g2) {
        int merge_count = this.merge_outline.size() - 1;
        int i = 0;
        while (i < merge_count) {
            Area s = this.merge_outline.elementAt(i);
            int level = this.merge_level.elementAt(i);
            if (this.showDebugLevel[level] & s != null) {
                g2.setColor(this.debugColors[level]);
                g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
                g2.draw(s.getBounds());
                g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
                g2.fill(s);
            }
            ++i;
        }
    }

    public void setDrawCrossHairs(boolean newDrawCrossHairs, int newBoxContained, Color newColor) {
        this.drawCrossHairs = newDrawCrossHairs;
        this.boxContained = newBoxContained;
        this.selectedHandleColor = newColor;
    }

    private void paintRectangle(Graphics2D g2) {
        Stroke oldStroke = g2.getStroke();
        BasicStroke lineStroke = this.scaling < 0.0f ? new BasicStroke(1.0f / -this.scaling) : new BasicStroke(1.0f / this.scaling);
        g2.setStroke(lineStroke);
        g2.setColor(this.outlineColor);
        g2.draw(this.cursorBoxOnScreen);
        if (this.drawCrossHairs) {
            int x1 = this.cursorBoxOnScreen.x;
            int y1 = this.cursorBoxOnScreen.y;
            int x2 = x1 + this.cursorBoxOnScreen.width;
            int y2 = y1 + this.cursorBoxOnScreen.height;
            int mediaW = this.pageData.getMediaBoxWidth(this.pageNumber);
            int mediaH = this.pageData.getMediaBoxHeight(this.pageNumber);
            int mediaX = this.pageData.getMediaBoxX(this.pageNumber);
            int mediaY = this.pageData.getMediaBoxY(this.pageNumber);
            if (this.scaling > 0.0f) {
                g2.setStroke(new BasicStroke(3.0f / this.scaling, 1, 1, 0.0f, new float[]{0.0f, 6.0f / this.scaling, 0.0f, 6.0f / this.scaling}, 0.0f));
            } else {
                g2.setStroke(new BasicStroke(3.0f / -this.scaling, 1, 1, 0.0f, new float[]{0.0f, 6.0f / -this.scaling, 0.0f, 6.0f / -this.scaling}, 0.0f));
            }
            g2.drawLine(x1, y1, mediaX, y1);
            g2.drawLine(x1, y1, x1, mediaY);
            g2.drawLine(x2, y1, mediaW, y1);
            g2.drawLine(x2, y1, x2, mediaY);
            g2.drawLine(x1, y2, mediaX, y2);
            g2.drawLine(x1, y2, x1, mediaH);
            g2.drawLine(x2, y2, mediaW, y2);
            g2.drawLine(x2, y2, x2, mediaH);
            Rectangle[] cursorBoxHandles = new Rectangle[]{new Rectangle(x1 - this.handlesGap, y1 + Math.abs(y2 - y1) / 2 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(x1 + Math.abs(x2 - x1) / 2 - this.handlesGap, y1 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(x1 + Math.abs(x2 - x1) / 2 - this.handlesGap, y2 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(x2 - this.handlesGap, y1 + Math.abs(y2 - y1) / 2 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(x1 - this.handlesGap, y1 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(x1 - this.handlesGap, y2 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(x2 - this.handlesGap, y1 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(x2 - this.handlesGap, y2 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2)};
            g2.setStroke(lineStroke);
            if (this.boxContained != -1 && this.boxContained < cursorBoxHandles.length) {
                if (this.selectedHandleColor != null) {
                    Color old = g2.getColor();
                    g2.setColor(this.selectedHandleColor);
                    g2.fill(cursorBoxHandles[this.boxContained]);
                    g2.setColor(old);
                } else {
                    g2.fill(cursorBoxHandles[this.boxContained]);
                }
            }
            int i = 0;
            while (i < cursorBoxHandles.length) {
                if (i != this.boxContained) {
                    g2.draw(cursorBoxHandles[i]);
                }
                ++i;
            }
        }
        g2.setStroke(oldStroke);
        if (this.actualBox == null) {
            this.lastCursorBoxOnScreen = this.cursorBoxOnScreen;
        } else {
            Rectangle b1 = this.cursorBoxOnScreen.getBounds();
            int minX = (int)b1.getMinX();
            int minY = (int)b1.getMinY();
            int maxX = (int)b1.getMaxX();
            int maxY = (int)b1.getMaxY();
            Rectangle bounds = this.actualBox.getBounds();
            int tmp = (int)bounds.getMinX();
            if (tmp < minX) {
                minX = tmp;
            }
            if ((tmp = (int)bounds.getMinY()) < minY) {
                minY = tmp;
            }
            if ((tmp = (int)bounds.getMaxX()) > maxX) {
                maxX = tmp;
            }
            if ((tmp = (int)bounds.getMaxY()) > maxY) {
                maxY = tmp;
            }
            this.lastCursorBoxOnScreen = new Rectangle(minX - 5, minY - 5, 10 + maxX - minX, 10 + (maxY - minY));
        }
    }

    private void paintHighlights(Graphics2D g2) {
        if (this.alternateOutlines != null) {
            int items = this.alternateOutlines.length;
            int i = 0;
            while (i < items) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
                g2.setColor(Color.darkGray);
                g2.fill(this.alternateOutlines[i]);
                g2.setComposite(AlphaComposite.getInstance(3, 0.9f));
                g2.draw(this.alternateOutlines[i]);
                ++i;
            }
            if (this.merge_outline != null && !this.altName.equals("Nothing") && !this.altName.equals("Lines")) {
                int merge_count = this.merge_outline.size() - 1;
                int i2 = 0;
                while (i2 < merge_count) {
                    Area s = this.merge_outline.elementAt(i2);
                    int level = this.merge_level.elementAt(i2);
                    if (level == 2 & s != null) {
                        g2.setColor(this.debugColors[level]);
                        g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
                        g2.draw(s.getBounds());
                        g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
                        g2.fill(s);
                    }
                    ++i2;
                }
            }
        } else {
            int items = this.highlightedZonesSelected.length;
            int i = 0;
            while (i < items) {
                if (this.highlightedZonesSelected[i]) {
                    if (this.hasDrownedObjects == null) {
                        this.highlightStoryOnscreen(g2, i, false);
                    } else {
                        this.highlightStoryOnscreen(g2, i, this.hasDrownedObjects[i]);
                    }
                } else if ((this.highlightMode & 1) == 1 && this.fragmentShapes[i] != null) {
                    int[] ii;
                    g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
                    if (this.highlightColors[i] == null) {
                        g2.setColor(Color.darkGray);
                    } else {
                        g2.setColor(this.highlightColors[i]);
                    }
                    g2.fill(this.fragmentShapes[i]);
                    g2.draw(this.outlineZone[i]);
                    g2.setComposite(AlphaComposite.getInstance(3, 0.9f));
                    g2.draw(this.outlineZone[i]);
                    if (this.children != null && (ii = (int[])this.children[i]) != null) {
                        this.drawRelationships(false, g2, String.valueOf(i) + "-", ii);
                    }
                    if (this.linkedItems != null && (ii = (int[])this.linkedItems[i]) != null) {
                        this.numberItems(false, g2, String.valueOf(i) + "-", ii);
                    }
                }
                ++i;
            }
            if (this.pageLines != null && (this.highlightMode & 2) == 2) {
                this.pageLines.drawLines(g2);
            }
            if (this.pageLines != null && (this.highlightMode & 4) == 4) {
                this.pageLines.drawBoxes(g2);
            }
            if (this.selectionOrder != null) {
                this.drawRelationships(false, g2, "", this.selectionOrder);
            }
        }
    }

    private void highlightStoryOnscreen(Graphics2D g2, int i, boolean containsDownedObjects) {
        Stroke line = g2.getStroke();
        if (containsDownedObjects) {
            BasicStroke dashed = new BasicStroke(8.0f, 0, 2, 0.0f, new float[]{12.0f, 12.0f}, 0.0f);
            g2.setStroke(dashed);
        }
        if (this.fragmentShapes[i] != null) {
            if (this.highlightColors[i] == null) {
                g2.setColor(highlightColor);
            } else {
                g2.setColor(this.highlightColors[i]);
            }
            g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
            g2.fill(this.fragmentShapes[i]);
            g2.draw(this.outlineZone[i]);
            g2.setComposite(AlphaComposite.getInstance(3, 0.9f));
            g2.draw(this.outlineZone[i]);
            int xs = this.outlineZone[i].getBounds().x;
            int ys = this.outlineZone[i].getBounds().y;
            g2.drawLine(xs, ys + (int)this.outlineZone[i].getBounds().getHeight(), xs + (int)this.outlineZone[i].getBounds().getWidth(), ys);
            if (this.processedByRegularExpression[i] > 0) {
                g2.drawLine(xs + (int)this.outlineZone[i].getBounds().getWidth(), ys + (int)this.outlineZone[i].getBounds().getHeight(), xs, ys);
            }
        }
        if (containsDownedObjects) {
            int xoffset = this.outlineZone[i].getBounds().x;
            int yoffset = this.outlineZone[i].getBounds().y;
            xoffset = xoffset + (int)this.outlineZone[i].getBounds().getWidth() / 2 - 12;
            g2.setColor(Color.yellow);
            g2.fillOval(xoffset, yoffset += (int)this.outlineZone[i].getBounds().getHeight() / 2, 50, 50);
            g2.setColor(Color.black);
            g2.fillOval(xoffset + 27, yoffset + 30, 8, 8);
            g2.fillOval(xoffset + 15, yoffset + 30, 8, 8);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawOval(xoffset, yoffset, 50, 50);
            g2.drawArc(xoffset + 12, yoffset + 5, 26, 15, 170, 200);
        }
        g2.setStroke(line);
    }

    private void numberItems(boolean isSublist, Graphics2D g2, String prefix, int[] selectionOrder) {
        int itemCount = selectionOrder.length;
        if (itemCount == 0) {
            return;
        }
        int order = 1;
        int ii = 0;
        while (ii < itemCount) {
            int i = selectionOrder[ii];
            if (i == -1) {
                ii = itemCount;
            } else {
                String value = String.valueOf(prefix) + order;
                if (this.linkedItems == null) {
                    if (this.fragmentShapes[i] != null) {
                        this.numberItem(g2, i, value);
                    }
                    ++order;
                } else {
                    int[] currentLinks = (int[])this.linkedItems[i];
                    if (currentLinks != null) {
                        ++order;
                        int childCount = currentLinks.length;
                        int item = 0;
                        int j = 0;
                        while (j < childCount) {
                            int childID = currentLinks[j];
                            ++item;
                            if (childID == -1) {
                                j = childCount;
                            } else if (this.fragmentShapes[i] != null) {
                                if (item != 1 && this.extraButton[childID] != null) {
                                    this.extraButton[childID].setVisible(false);
                                }
                                this.numberItem(g2, childID, String.valueOf(value) + '.' + item);
                            }
                            ++j;
                        }
                    } else if (this.parents[i] == -1) {
                        if (this.fragmentShapes[i] != null) {
                            this.numberItem(g2, i, value);
                        }
                        ++order;
                    }
                }
            }
            ++ii;
        }
    }

    public JPanel getParentChildButton(int buttonNumber) {
        return this.extraButton[buttonNumber];
    }

    public void setParentChildButton(int buttonNumber, JPanel j) {
        this.extraButton[buttonNumber] = j;
    }

    public JPanel[] getParentChildButtonArray() {
        return this.extraButton;
    }

    public void setParentChildButtonArray(JPanel[] newButtonSet) {
        this.extraButton = newButtonSet;
    }

    private void drawRelationships(boolean isSublist, Graphics2D g2, String prefix, int[] selectionOrder) {
        int itemCount = selectionOrder.length;
        if (itemCount == 0) {
            return;
        }
        int ii = 0;
        while (ii < itemCount) {
            int i = selectionOrder[ii];
            if (i == -1) {
                ii = itemCount;
            } else if (this.children != null) {
                int[] currentLinks = (int[])this.children[i];
                if (currentLinks != null) {
                    int childCount = currentLinks.length;
                    int item = 0;
                    int j = 0;
                    while (j < childCount) {
                        int childID = currentLinks[j];
                        ++item;
                        if (childID == -1) {
                            j = childCount;
                        } else if (this.fragmentShapes[childID] != null) {
                            Stroke oldStroke = g2.getStroke();
                            BasicStroke newStroke = new BasicStroke(5.0f);
                            g2.setStroke(newStroke);
                            g2.setColor(highlightColor);
                            if (i != childID) {
                                g2.drawLine(this.cx[i], this.cy[i], this.cx[childID], this.cy[childID]);
                                g2.fillOval(this.cx[childID] - 15, this.cy[childID] - 15, 30, 30);
                                g2.setColor(Color.red);
                                g2.fillOval(this.cx[i] - 20, this.cy[i] - 20, 40, 40);
                            }
                            g2.setStroke(oldStroke);
                            this.highlightedZonesSelected[childID] = true;
                            if (this.linkedItems[childID] != null) {
                                int y = 0;
                                int[] links = (int[])this.linkedItems[childID];
                                while (y != links.length) {
                                    if (links[y] != -1) {
                                        this.highlightStoryOnscreen(g2, links[y], this.hasDrownedObjects[y]);
                                        this.highlightedZonesSelected[links[y]] = true;
                                        this.numberItems(false, g2, "", currentLinks);
                                        if (this.useParentButtons && this.extraButton[links[y]] != null) {
                                            this.extraButton[links[y]].setVisible(false);
                                        }
                                    }
                                    ++y;
                                }
                            } else {
                                this.numberItems(false, g2, "", currentLinks);
                                this.highlightStoryOnscreen(g2, childID, this.hasDrownedObjects[childID]);
                                if (this.useParentButtons && this.extraButton[childID] != null) {
                                    this.extraButton[childID].setVisible(false);
                                }
                            }
                        }
                        ++j;
                    }
                } else {
                    this.numberItems(false, g2, "", selectionOrder);
                }
            }
            ++ii;
        }
    }

    private void numberItem(Graphics2D g2, int i, String value) {
        AffineTransform af = new AffineTransform();
        GlyphVector gv = this.highlightFont.createGlyphVector(g2.getFontRenderContext(), value);
        af.scale(1.0, -1.0);
        af.translate(this.cx[i], -this.cy[i]);
        Area a = new Area(gv.getOutline());
        a.transform(af);
        g2.setColor(Color.black);
        g2.fill(a.getBounds());
        g2.setColor(Color.white);
        g2.fill(a);
    }

    public final int getPDFWidth() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.y_size + this.insetW + this.insetW;
        }
        return this.x_size + this.insetW + this.insetW;
    }

    public final int getRawPDFWidth() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.y_size;
        }
        return this.x_size;
    }

    public void setMessageFrame(JFrame frame) {
        this.currentDisplay.setMessageFrame(frame);
    }

    public final int getPDFHeight() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.x_size + this.insetH + this.insetH;
        }
        return this.y_size + this.insetH + this.insetH;
    }

    public final int getRawPDFHeight() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.x_size;
        }
        return this.y_size;
    }

    public Rectangle[] getPageHotspots() {
        if (this.displayHotspots != null) {
            return this.displayHotspots.getAnnotationhotSpots();
        }
        return null;
    }

    public void disableBorderForPrinting() {
        this.useBorder = false;
    }

    public final void setPDFBorder(Border newBorder) {
        this.myBorder = newBorder;
        this.useBorder = true;
    }

    protected final AffineTransform getScalingForImage(int pageNumber, int rotation, float scaling) {
        double mediaX = (float)this.pageData.getMediaBoxX(pageNumber) * scaling;
        double mediaY = (float)this.pageData.getMediaBoxY(pageNumber) * scaling;
        double mediaH = (float)this.pageData.getMediaBoxHeight(pageNumber) * scaling;
        double crw = (float)this.pageData.getCropBoxWidth(pageNumber) * scaling;
        double crh = (float)this.pageData.getCropBoxHeight(pageNumber) * scaling;
        double crx = (float)this.pageData.getCropBoxX(pageNumber) * scaling;
        double cry = (float)this.pageData.getCropBoxY(pageNumber) * scaling;
        AffineTransform displayScaling = new AffineTransform();
        int x_size = (int)(crw + (crx - mediaX));
        int y_size = (int)(crh + (cry - mediaY));
        if (rotation == 270) {
            displayScaling.rotate(-1.5707963267948966, x_size / 2, y_size / 2);
            double x_change = displayScaling.getTranslateX();
            double y_change = displayScaling.getTranslateY();
            displayScaling.translate((double)y_size - y_change, -x_change);
            displayScaling.translate(0.0, y_size);
            displayScaling.scale(1.0, -1.0);
            displayScaling.translate(-(crx + mediaX), -(mediaH - crh - (cry - mediaY)));
        } else if (rotation == 180) {
            displayScaling.rotate(Math.PI, x_size / 2, y_size / 2);
            displayScaling.translate(-(crx + mediaX), (double)y_size + (cry + mediaY) - (mediaH - crh - (cry - mediaY)));
            displayScaling.scale(1.0, -1.0);
        } else if (rotation == 90) {
            displayScaling.rotate(1.5707963267948966);
            displayScaling.translate(0.0, cry + mediaY - (mediaH - crh - (cry - mediaY)));
            displayScaling.scale(1.0, -1.0);
        } else {
            displayScaling.translate(0.0, y_size);
            displayScaling.scale(1.0, -1.0);
            displayScaling.translate(0.0, -(mediaH - crh - (cry - mediaY)));
        }
        displayScaling.scale(scaling, scaling);
        return displayScaling;
    }

    public final void setPageRotation(int newRotation) {
        this.displayRotation = newRotation;
        if (this.displayView != 1) {
            newRotation = 0;
        }
        this.pageUsedForTransform = this.pageNumber;
        this.displayScaling = this.getScalingForImage(this.pageNumber, newRotation, this.scaling);
        if (newRotation == 90) {
            this.displayScaling.translate((float)this.insetH / this.scaling, (float)this.insetW / this.scaling);
        } else if (newRotation == 270) {
            this.displayScaling.translate((float)(-this.insetH) / this.scaling, (float)(-this.insetW) / this.scaling);
        } else if (newRotation == 180) {
            this.displayScaling.translate((float)(-this.insetW) / this.scaling, (float)this.insetH / this.scaling);
        } else {
            this.displayScaling.translate((float)this.insetW / this.scaling, (float)(-this.insetH) / this.scaling);
        }
        this.pages.refreshDisplay();
        if (this.viewableArea != null) {
            this.viewScaling = new AffineTransform();
            double dx = (double)this.viewableArea.width / (double)this.pageData.getCropBoxWidth(this.pageNumber);
            double dy = (double)this.viewableArea.height / (double)this.pageData.getCropBoxHeight(this.pageNumber);
            double viewScale = dx;
            if (dy < dx) {
                viewScale = dy;
            }
            double x = this.viewableArea.x;
            double y = (double)this.viewableArea.y + ((double)this.viewableArea.height - (double)this.pageData.getCropBoxHeight(this.pageNumber) * viewScale);
            this.viewScaling.translate(x, y);
            this.viewScaling.scale(viewScale, viewScale);
        } else {
            this.viewScaling = null;
        }
    }

    public final void setPageParameters(float scaling, int pageNumber, int newRotation) {
        if (this.pages != null) {
            this.pages.setScaling(scaling);
        }
        this.isNewRotationSet = true;
        this.displayRotation = newRotation;
        this.setPageParameters(scaling, pageNumber);
    }

    public final void setPageParameters(float scaling, int pageNumber) {
        this.pageNumber = pageNumber;
        if (scaling > 0.0f) {
            this.scaling = scaling;
        } else {
            scaling = this.scaling;
        }
        this.pageData.setScalingValue(scaling);
        int mediaW = this.pageData.getMediaBoxWidth(pageNumber);
        this.max_y = this.pageData.getMediaBoxHeight(pageNumber);
        this.max_x = this.pageData.getMediaBoxWidth(pageNumber);
        int cropW = this.pageData.getCropBoxWidth(pageNumber);
        int cropH = this.pageData.getCropBoxHeight(pageNumber);
        this.x_size_cropped = (int)((float)cropW * scaling);
        this.y_size_cropped = (int)((float)cropH * scaling);
        this.x_size = (int)((float)cropW * scaling);
        this.y_size = (int)((float)cropH * scaling);
        if (!this.isNewRotationSet) {
            this.displayRotation = this.pageData.getRotation(pageNumber);
        } else {
            this.isNewRotationSet = false;
        }
        this.currentDisplay.init(mediaW, this.max_y, this.displayRotation);
        this.setPageRotation(this.displayRotation);
    }

    protected final AffineTransform setPageParametersForImage(float scaling, int pageNumber) {
        AffineTransform imageScaling = new AffineTransform();
        int crw = this.pageData.getCropBoxWidth(pageNumber);
        int crh = this.pageData.getCropBoxHeight(pageNumber);
        int crx = this.pageData.getCropBoxX(pageNumber);
        int cry = this.pageData.getCropBoxY(pageNumber);
        int image_x_size = (int)((float)crw * scaling);
        int image_y_size = (int)((float)crh * scaling);
        int raw_rotation = this.pageData.getRotation(pageNumber);
        imageScaling.translate((float)(-crx) * scaling, (float)cry * scaling);
        if (raw_rotation == 270) {
            imageScaling.rotate(-1.5707963267948966, image_x_size / 2, image_y_size / 2);
            double x_change = imageScaling.getTranslateX();
            double y_change = imageScaling.getTranslateY();
            imageScaling.translate((double)image_y_size - y_change, -x_change);
            imageScaling.translate((float)(2 * cry) * scaling, 0.0);
            imageScaling.translate(0.0, -scaling * (float)(this.pageData.getCropBoxHeight(pageNumber) - this.pageData.getMediaBoxHeight(pageNumber)));
        } else if (raw_rotation == 180) {
            imageScaling.rotate(Math.PI, image_x_size / 2, image_y_size / 2);
        } else if (raw_rotation == 90) {
            imageScaling.rotate(1.5707963267948966, image_x_size / 2, image_y_size / 2);
            double x_change = imageScaling.getTranslateX();
            double y_change = imageScaling.getTranslateY();
            imageScaling.translate(-y_change, (double)image_x_size - x_change);
        }
        if (scaling < 1.0f) {
            imageScaling.translate(image_x_size, image_y_size);
            imageScaling.scale(1.0, -1.0);
            imageScaling.translate(-image_x_size, 0.0);
            imageScaling.scale(scaling, scaling);
        } else {
            imageScaling.translate(image_x_size, image_y_size);
            imageScaling.scale(1.0, -1.0);
            imageScaling.translate(-image_x_size, 0.0);
            imageScaling.scale(scaling, scaling);
        }
        return imageScaling;
    }

    public void setHardwareAccelerationforScreen(boolean useAcceleration) {
        this.useAcceleration = useAcceleration;
    }

    public int getScrollInterval() {
        return this.scrollInterval;
    }

    public void setScrollInterval(int scrollInterval) {
        this.scrollInterval = scrollInterval;
    }

    public void setAnnotationsVisible(boolean showAnnotations) {
        this.showAnnotations = showAnnotations;
    }

    public void setDrawInteractively(boolean drawInteractively) {
        this.drawInteractively = drawInteractively;
    }

    public int getDisplayView() {
        return this.displayView;
    }

    public int getPrintPageScalingMode() {
        return this.pageScalingMode;
    }

    public void setPrintPageScalingMode(int pageScalingMode) {
        this.pageScalingMode = pageScalingMode;
    }

    public void setUsePDFPaperSize(boolean usePDFPaperSize) {
        this.usePDFPaperSize = usePDFPaperSize;
    }

    public void setHighlightedImage(int[] highlightedImage) {
        this.highlightedImage = highlightedImage;
    }

    public int[] getHighlightImage() {
        return this.highlightedImage;
    }

    public boolean isImageExtractionAllowed() {
        return this.ImageExtractionAllowed;
    }

    public void setImageExtractionAllowed(boolean allow) {
        this.ImageExtractionAllowed = allow;
    }

    public float getScaling() {
        return this.scaling;
    }

    public int getInsetH() {
        return this.insetH;
    }

    public int getInsetW() {
        return this.insetW;
    }

    protected void setDisplayForms(boolean displayForms) {
        this.displayForms = displayForms;
    }
}

