/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.RepaintManager;
import javax.swing.Timer;
import org.jpedal.MultiDisplay;
import org.jpedal.PageOffsets;
import org.jpedal.PdfPanel;
import org.jpedal.SingleDisplay;
import org.jpedal.color.ColorSpaces;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.external.ImageHandler;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfHeightTable;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.GUIFactory;
import org.jpedal.gui.Hotspots;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.PdfReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PageLines;
import org.jpedal.objects.PageLookup;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfFormData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.acroforms.rendering.DefaultAcroRenderer;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.outlines.OutlineData;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.PdfPageObject;
import org.jpedal.objects.structuredtext.MarkedContentGenerator;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;
import org.w3c.dom.Document;

public class PdfDecoder
extends PdfPanel
implements Printable,
Pageable {
    private static final long serialVersionUID = 1107156907326450528L;
    public static final String version = "3.51b12";
    public static final boolean optimiseType3Rendering = false;
    boolean isOptimisedImage = false;
    File tempURLFile;
    boolean downloadCreated = false;
    JFrame download = null;
    JPanel p;
    JProgressBar pb;
    JLabel downloadMessage;
    JLabel downloadFile;
    JLabel turnOff;
    int downloadCount = 0;
    boolean useDownloadWindow = true;
    boolean oldSetup = false;
    boolean useARGBFix = true;
    boolean docIsLandscaped = false;
    boolean printOnlyVisible = false;
    private Rectangle clipVr = null;
    private int duplexGapEven = 0;
    private int duplexGapOdd = 0;
    private boolean isPDf = false;
    private boolean isMultiPageTiff = false;
    private Map formKids = new HashMap();
    private final Map overlayType = new HashMap();
    private final Map overlayColors = new HashMap();
    private final Map overlayObj = new HashMap();
    private final Map overlayTypeG = new HashMap();
    private final Map overlayColorsG = new HashMap();
    private final Map overlayObjG = new HashMap();
    private Map fdfData = null;
    private boolean isXFA = false;
    private Javascript javascript = null;
    ImageHandler customImageHandler = null;
    PdfObjectReader currentPdfFile;
    private static boolean debugFonts = false;
    private PdfAnnots printAnnots = null;
    private PageLookup pageLookup = new PageLookup();
    private boolean isBackgroundDecoding = false;
    private OutlineData outlineData = null;
    private Object outlineObject = null;
    private String XMLObject;
    private final MarkedContentGenerator content = new MarkedContentGenerator();
    private PdfImageData pdfImages = new PdfImageData();
    private PdfImageData pdfBackgroundImages = new PdfImageData();
    private PdfData pdfData;
    private PdfData pdfBackgroundData;
    public static PdfHeightTable currentHeightLookupData = null;
    public static boolean isRunningOnMac = false;
    public static boolean isRunningOnWindows = false;
    public static boolean isRunningOnLinux = false;
    public static boolean clipOnMac = false;
    public static boolean debugPrint = false;
    private boolean hasViewListener = false;
    private RefreshLayout viewListener = new RefreshLayout();
    private boolean oddPagesOnly = false;
    private boolean evenPagesOnly = false;
    private boolean pagesPrintedInReverse = false;
    private boolean stopPrinting = false;
    private String pdfVersion = "";
    private int lastWidth;
    private int lastPage;
    public static boolean isDraft = true;
    private boolean useForms = true;
    private Graphics2D g2 = null;
    private boolean hasEmbeddedFonts = false;
    private String fontsInFile = "";
    public static int dpi = 72;
    public static boolean embedWidthData = false;
    private boolean hasOutline = false;
    private int start = 0;
    private int end = -1;
    public static final boolean inDemo = false;
    public static float multiplyer = 1.0f;
    public static boolean hires = false;
    private static int GLOBAL_IMAGE_UPSCALE = 1;
    private PdfStreamDecoder currentPrintDecoder = null;
    private DynamicVectorRenderer printRender = null;
    private int lastPrintedPage = -1;
    public static final int TEXT = 1;
    public static final int RAWIMAGES = 2;
    public static final int FINALIMAGES = 4;
    protected static final int PAGEDATA = 8;
    public static final int RAWCOMMANDS = 16;
    public static final int CLIPPEDIMAGES = 32;
    public static final int TEXTCOLOR = 64;
    public static final int CMYKIMAGES = 128;
    public static final int XFORMMETADATA = 256;
    public static final int COLOR = 512;
    public static final int RENDERTEXT = 1;
    public static final int RENDERIMAGES = 2;
    private byte[][] annotList;
    private int annotPage = -1;
    private boolean isForm = false;
    private static int extractionMode = 7;
    protected static int renderMode = 7;
    private PdfStreamDecoder current;
    Map pagesReferences = new Hashtable();
    private Map pagesRead = new HashMap();
    PdfObject globalResources;
    public static boolean enforceFontSubstitution = false;
    private boolean showImageable = false;
    public static String defaultFont = null;
    private Map pageFormats = new Hashtable();
    private static final String separator = System.getProperty("file.separator");
    private static boolean isXMLExtraction = true;
    private boolean includeImages;
    private StatusBar statusBar = null;
    public static boolean use13jPEGConversion = false;
    private boolean usePageScaling = false;
    boolean useHiResImageForDisplay = false;
    private boolean operationSuccessful = true;
    private String pageErrorMessages = "";
    String filename;
    private ObjectStore backgroundObjectStoreRef = new ObjectStore();
    private SetOfIntegerSyntax range;
    private int[] listOfPages;
    private static final boolean flattenDebug = false;
    public static final int TEXTGLYPHPRINT = 1;
    public static final int NOTEXTPRINT = 0;
    public static final int TEXTSTRINGPRINT = 2;
    private int lastPageDecoded = -1;
    private boolean isCustomPrinting = false;
    public static final int SUBSTITUTE_FONT_USING_FILE_NAME = 1;
    public static final int SUBSTITUTE_FONT_USING_POSTSCRIPT_NAME = 2;
    public static final int SUBSTITUTE_FONT_USING_FAMILY_NAME = 3;
    public static final int SUBSTITUTE_FONT_USING_FULL_FONT_NAME = 4;
    public static final int SUBSTITUTE_FONT_USING_POSTSCRIPT_NAME_USE_FAMILY_NAME_IF_DUPLICATES = 5;
    private static int fontSubstitutionMode = 1;
    ObjectStore objectPrintStoreRef = new ObjectStore();
    public static final int BORDER_SHOW = 1;
    public static final int BORDER_HIDE = 0;
    public static int CURRENT_BORDER_STYLE = 1;
    public static boolean showErrorMessages;
    public static boolean useFullSizeImage;
    public static int samplingUsed;
    protected int specialMode = -1;
    private boolean isOpen = false;
    private int textPrint = 0;
    private int minimumCacheSize = -1;
    String decodeStatus = "";
    private int currentPrintPage = 0;
    private boolean imagesProcessedFully;
    private boolean hasNonEmbeddedCIDFonts;
    private String nonEmbeddedCIDFonts = "";
    private Object customSwingHandle;
    private Object userExpressionEngine;
    private boolean generateGlyphOnRender;
    private boolean thumbnailsBeingDrawn;
    private float oldScaling = -1.0f;
    private boolean useJavascript = true;
    private boolean centerOnScaling = true;
    public static boolean extAtBestQuality;
    Point coords = null;
    private int pageMode = 1;

    static {
        try {
            String name = System.getProperty("os.name");
            if (name.equals("Mac OS X")) {
                isRunningOnMac = true;
            } else if (name.startsWith("Windows")) {
                isRunningOnWindows = true;
            } else if (name.equals("Linux")) {
                isRunningOnLinux = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        showErrorMessages = false;
        samplingUsed = -1;
        extAtBestQuality = false;
    }

    public int getPageFromObjectRef(String ref) {
        return this.pageLookup.convertObjectToPageNumber(ref);
    }

    public void setBorderStyle(int style) {
        CURRENT_BORDER_STYLE = style;
    }

    public int getBorderStyle() {
        return CURRENT_BORDER_STYLE;
    }

    protected void setMultiPageOffsets(int[] xReached, int[] yReached) {
        if (this.formsAvailable && this.formRenderer != null) {
            this.formRenderer.getCompData().setPageDisplacements(xReached, yReached);
        }
    }

    public void setPrintIndent(int oddPages, int evenPages) {
        this.duplexGapOdd = oddPages;
        this.duplexGapEven = evenPages;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public Document getMarkedContent() {
        return this.content.getMarkedContentTree(this.currentPdfFile, this, this.pageLookup);
    }

    public void setPageData(PdfPageData pageData) {
        this.pageData = pageData;
    }

    public void setAlternativeOutlines(Rectangle[] outlines, String altName) {
        this.alternateOutlines = outlines;
        this.altName = altName;
        this.repaint();
    }

    public void flushAdditionalPages() {
        this.pages.clearAdditionalPages();
        this.xOffset = 0;
        this.additionalPageCount = 0;
    }

    public void addAdditionalPage(DynamicVectorRenderer dynamicRenderer, int pageWidth, int origPageWidth) {
        this.pages.addAdditionalPage(dynamicRenderer, pageWidth, origPageWidth);
        if (this.additionalPageCount == 0) {
            this.lastWidth = this.xOffset + origPageWidth;
            this.xOffset += pageWidth;
        } else {
            this.xOffset += pageWidth;
            this.lastWidth += this.lastPage;
        }
        ++this.additionalPageCount;
        this.lastPage = pageWidth;
        this.updateUI();
    }

    public int getXDisplacement() {
        return this.lastWidth;
    }

    public int getAdditionalPageCount() {
        return this.additionalPageCount;
    }

    public void updatePageNumberDisplayed(int page) {
        if (page != -1 && this.customSwingHandle != null) {
            ((GUIFactory)this.customSwingHandle).setPage(page);
        }
    }

    public int getlastPageDecoded() {
        return this.lastPageDecoded;
    }

    public void setlastPageDecoded(int page) {
        this.lastPageDecoded = page;
    }

    public void setSubstitutedFontAliases(String fontFileName, String[] aliases) {
        if (aliases != null) {
            String name = fontFileName.toLowerCase();
            int count = aliases.length;
            int i = 0;
            while (i < count) {
                String alias = aliases[i].toLowerCase();
                if (!alias.equals(name)) {
                    FontMappings.fontSubstitutionAliasTable.put(alias, name);
                }
                ++i;
            }
        }
    }

    private String addFonts(String fontDirs, String failed) {
        StringTokenizer fontPaths = new StringTokenizer(fontDirs, ",");
        while (fontPaths.hasMoreTokens()) {
            String fontPath = fontPaths.nextToken();
            if (!fontPath.endsWith("/") & !fontPath.endsWith("\\")) {
                fontPath = String.valueOf(fontPath) + separator;
            }
            PdfDecoder.addTTDir(fontPath, failed);
        }
        return failed;
    }

    public void resetViewableArea() {
        if (this.viewableArea != null) {
            this.viewableArea = null;
            this.setPageRotation(this.displayRotation);
            this.repaint();
        }
    }

    public AffineTransform setViewableArea(Rectangle viewport) throws PdfException {
        if (viewport != null) {
            double x = viewport.getX();
            double y = viewport.getY();
            double w = viewport.getWidth();
            double h = viewport.getHeight();
            double crw = this.pageData.getCropBoxWidth(this.pageNumber);
            double crh = this.pageData.getCropBoxHeight(this.pageNumber);
            if (x < 0.0 || y < 0.0 || x + w > crw || y + h > crh) {
                throw new PdfException("Viewport is not totally enclosed within displayed panel.");
            }
            if (crw != w || crh != h) {
                this.viewableArea = viewport;
                this.currentDisplay.setOptimiseDrawing(false);
                this.setPageRotation(this.displayRotation);
                this.repaint();
            }
        } else {
            this.resetViewableArea();
        }
        return this.viewScaling;
    }

    public static String setFontDirs(String[] fontDirs) {
        String failed = null;
        if (FontMappings.fontSubstitutionTable == null) {
            FontMappings.fontSubstitutionTable = new HashMap();
            FontMappings.fontSubstitutionFontID = new HashMap();
            FontMappings.fontPossDuplicates = new HashMap();
            FontMappings.fontPropertiesTable = new HashMap();
        }
        try {
            if (fontDirs == null) {
                LogWriter.writeLog((String)"Null font parameter passed");
                FontMappings.fontSubstitutionAliasTable.clear();
                FontMappings.fontSubstitutionLocation.clear();
                FontMappings.fontSubstitutionTable.clear();
                FontMappings.fontSubstitutionFontID.clear();
                FontMappings.fontPossDuplicates.clear();
                FontMappings.fontPropertiesTable.clear();
            } else {
                int count = fontDirs.length;
                int i = 0;
                while (i < count) {
                    String fontPath = fontDirs[i];
                    if (!fontPath.endsWith("/") & !fontPath.endsWith("\\")) {
                        fontPath = String.valueOf(fontPath) + separator;
                    }
                    if (debugFonts) {
                        System.out.println("Looking in " + fontPath + " for fonts");
                    }
                    failed = PdfDecoder.addTTDir(fontPath, failed);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LogWriter.writeLog((String)("Unable to run setFontDirs " + e.getMessage()));
        }
        return failed;
    }

    private static String addTTDir(String fontPath, String failed) {
        File currentDir;
        if (FontMappings.fontSubstitutionTable == null) {
            FontMappings.fontSubstitutionTable = new HashMap();
            FontMappings.fontSubstitutionFontID = new HashMap();
            FontMappings.fontPossDuplicates = new HashMap();
            FontMappings.fontPropertiesTable = new HashMap();
        }
        if ((currentDir = new File(fontPath)).exists() && currentDir.isDirectory()) {
            String[] files = currentDir.list();
            if (files != null) {
                int count = files.length;
                int i = 0;
                while (i < count) {
                    String currentFont = files[i];
                    PdfDecoder.addFontFile(currentFont, fontPath);
                    ++i;
                }
            }
        } else {
            failed = failed == null ? fontPath : String.valueOf(failed) + ',' + fontPath;
        }
        return failed;
    }

    public static void setFontSubstitutionMode(int mode) {
        fontSubstitutionMode = mode;
    }

    public static int getFontSubstitutionMode() {
        return fontSubstitutionMode;
    }

    public static void addFontFile(String currentFont, String fontPath) {
        if (FontMappings.fontSubstitutionTable == null) {
            FontMappings.fontSubstitutionTable = new HashMap();
            FontMappings.fontSubstitutionFontID = new HashMap();
            FontMappings.fontPossDuplicates = new HashMap();
            FontMappings.fontPropertiesTable = new HashMap();
        }
        if (fontPath != null && !fontPath.endsWith("/") && !fontPath.endsWith("\\")) {
            fontPath = String.valueOf(fontPath) + separator;
        }
        String name = currentFont.toLowerCase();
        int type = StandardFonts.getFontType((String)name);
        if (debugFonts) {
            System.out.println(String.valueOf(type) + " " + name);
        }
        if (type != 8) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(String.valueOf(fontPath) + currentFont);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (in != null) {
                int pointer = currentFont.indexOf(46);
                String fontName = pointer == -1 ? currentFont.toLowerCase() : currentFont.substring(0, pointer).toLowerCase();
                if (debugFonts) {
                    System.out.println("Added " + fontName);
                }
                if (fontSubstitutionMode == 1) {
                    if (type == 1228944677) {
                        FontMappings.fontSubstitutionTable.put(fontName, "/Type1");
                    } else {
                        FontMappings.fontSubstitutionTable.put(fontName, "/TrueType");
                    }
                    FontMappings.fontSubstitutionLocation.put(fontName, String.valueOf(fontPath) + currentFont);
                    FontMappings.fontPropertiesTable.put(fontName, StandardFonts.getFontDetails((int)type, (String)(String.valueOf(fontPath) + currentFont)));
                } else if (type == 7 || type == 1217103210) {
                    if (fontSubstitutionMode == 5) {
                        String[] postscriptNames = new String[]{};
                        try {
                            postscriptNames = StandardFonts.readNamesFromFont((int)type, (String)(String.valueOf(fontPath) + currentFont), (int)2);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        String[] familyNames = new String[]{};
                        try {
                            familyNames = StandardFonts.readNamesFromFont((int)type, (String)(String.valueOf(fontPath) + currentFont), (int)3);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        int fontCount = postscriptNames.length;
                        int ii = 0;
                        while (ii < fontCount) {
                            if (postscriptNames[ii] == null) {
                                postscriptNames[ii] = Strip.stripAllSpaces((String)fontName);
                            }
                            if (familyNames[ii] == null) {
                                familyNames[ii] = Strip.stripAllSpaces((String)fontName);
                            }
                            Object fontSubValue = FontMappings.fontSubstitutionTable.get(postscriptNames[ii]);
                            Object possDuplicate = FontMappings.fontPossDuplicates.get(postscriptNames[ii]);
                            if (fontSubValue == null && possDuplicate == null) {
                                FontMappings.fontSubstitutionTable.put(postscriptNames[ii], "/TrueType");
                                FontMappings.fontSubstitutionLocation.put(postscriptNames[ii], String.valueOf(fontPath) + currentFont);
                                FontMappings.fontSubstitutionFontID.put(postscriptNames[ii], new Integer(ii));
                                FontMappings.fontPossDuplicates.put(postscriptNames[ii], familyNames[ii]);
                            } else if (!familyNames[ii].equals(postscriptNames[ii])) {
                                FontMappings.fontSubstitutionTable.put(postscriptNames[ii], "/TrueType");
                                FontMappings.fontSubstitutionLocation.put(postscriptNames[ii], String.valueOf(fontPath) + currentFont);
                                FontMappings.fontSubstitutionFontID.put(postscriptNames[ii], new Integer(ii));
                                FontMappings.fontPropertiesTable.put(postscriptNames[ii], StandardFonts.getFontDetails((int)type, (String)(String.valueOf(fontPath) + currentFont)));
                                if (!possDuplicate.equals("DONE")) {
                                    FontMappings.fontPossDuplicates.put(postscriptNames[ii], "DONE");
                                    FontMappings.fontSubstitutionTable.remove(postscriptNames[ii]);
                                    FontMappings.fontSubstitutionTable.put(familyNames[ii], "/TrueType");
                                    String font = (String)FontMappings.fontSubstitutionLocation.get(postscriptNames[ii]);
                                    FontMappings.fontSubstitutionLocation.remove(postscriptNames[ii]);
                                    FontMappings.fontSubstitutionLocation.put(familyNames[ii], font);
                                    FontMappings.fontSubstitutionFontID.remove(postscriptNames[ii]);
                                    FontMappings.fontSubstitutionFontID.put(familyNames[ii], new Integer(ii));
                                    FontMappings.fontPropertiesTable.remove(familyNames[ii]);
                                    FontMappings.fontPropertiesTable.put(familyNames[ii], StandardFonts.getFontDetails((int)type, (String)(String.valueOf(fontPath) + currentFont)));
                                }
                            }
                            ++ii;
                        }
                    } else {
                        String[] fontNames = new String[]{};
                        try {
                            fontNames = StandardFonts.readNamesFromFont((int)type, (String)(String.valueOf(fontPath) + currentFont), (int)fontSubstitutionMode);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        int i = 0;
                        while (i < fontNames.length) {
                            if (fontNames[i] == null) {
                                fontNames[i] = Strip.stripAllSpaces((String)fontName);
                            }
                            FontMappings.fontSubstitutionTable.put(fontNames[i], "/TrueType");
                            FontMappings.fontSubstitutionLocation.put(fontNames[i], String.valueOf(fontPath) + currentFont);
                            FontMappings.fontSubstitutionFontID.put(fontNames[i], new Integer(i));
                            FontMappings.fontPropertiesTable.put(fontNames[i], StandardFonts.getFontDetails((int)type, (String)(String.valueOf(fontPath) + currentFont)));
                            ++i;
                        }
                    }
                }
            } else {
                LogWriter.writeLog((String)("No fonts found at " + fontPath));
            }
        }
    }

    public int getPageAlignment() {
        return this.alignment;
    }

    public final void init(boolean newEmbedWidthData) {
        embedWidthData = newEmbedWidthData;
    }

    public PdfDecoder(boolean newRender) {
        this.pages = new SingleDisplay(this);
        this.renderPage = newRender;
        this.setLayout(null);
        this.startup();
    }

    public PdfDecoder(int mode, boolean newRender) {
        this.pages = new SingleDisplay(this);
        this.renderPage = newRender;
        extractionMode = 1;
        this.setLayout(null);
        this.init(true);
        this.startup();
        PdfStreamDecoder.runningStoryPad = true;
    }

    private void startup() {
        String debugFlag;
        this.formsAvailable = PdfStreamDecoder.isFormSupportAvailable();
        if (this.formsAvailable) {
            this.formRenderer = new DefaultAcroRenderer();
            this.setJavascript();
            this.formRenderer.resetHandler(null, this, 5);
            this.formRenderer.resetHandler(null, this, 7);
        }
        if ((debugFlag = System.getProperty("debug")) != null) {
            LogWriter.setupLogFile((boolean)true, (int)1, (String)"", (String)"v", (boolean)false);
        }
        try {
            String fontMaps = System.getProperty("org.jpedal.fontmaps");
            if (fontMaps != null) {
                StringTokenizer fontPaths = new StringTokenizer(fontMaps, ",");
                while (fontPaths.hasMoreTokens()) {
                    String fontPath = fontPaths.nextToken();
                    StringTokenizer values = new StringTokenizer(fontPath, "=:");
                    int count = values.countTokens() - 1;
                    String[] nameInPDF = new String[count];
                    String key = values.nextToken();
                    int i = 0;
                    while (i < count) {
                        nameInPDF[i] = values.nextToken();
                        ++i;
                    }
                    this.setSubstitutedFontAliases(key, nameInPDF);
                }
            }
        }
        catch (Exception e) {
            LogWriter.writeLog((String)("Unable to read org.jpedal.fontmaps " + e.getMessage()));
        }
        try {
            String fontDirs = System.getProperty("org.jpedal.fontdirs");
            String failed = null;
            if (fontDirs != null) {
                failed = this.addFonts(fontDirs, failed);
            }
            if (failed != null) {
                LogWriter.writeLog((String)("Could not find " + failed));
            }
        }
        catch (Exception e) {
            LogWriter.writeLog((String)("Unable to read FontDirs " + e.getMessage()));
        }
        if (this.renderPage) {
            this.setToolTipText("image preview");
            this.highlightFont = new Font("Lucida", 1, this.size);
            this.setPreferredSize(new Dimension(100, 100));
        }
    }

    public PdfDecoder() {
        this.pages = new SingleDisplay(this);
        this.renderPage = true;
        this.setLayout(null);
        this.startup();
    }

    public final void closePdfFile() {
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        this.displayScaling = null;
        this.lastPageDecoded = -1;
        this.stopDecoding();
        this.pages.disableScreen();
        this.pagesRead.clear();
        if (this.javascript != null) {
            this.javascript.closeFile();
        }
        this.overlayType.clear();
        this.overlayColors.clear();
        this.overlayObj.clear();
        this.overlayTypeG.clear();
        this.overlayColorsG.clear();
        this.overlayObjG.clear();
        if (this.formsAvailable) {
            this.currentAcroFormData = null;
            if (this.formRenderer != null) {
                this.formRenderer.openFile(this.pageCount);
                this.formRenderer.resetFormData((Object)this.currentAcroFormData, this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.formKids);
            }
        }
        if (this.hasViewListener) {
            this.hasViewListener = false;
            this.pages.flushPageCaches();
            this.removeComponentListener(this.viewListener);
        }
        if (this.currentPdfFile != null) {
            this.currentPdfFile.closePdfFile();
        }
        this.currentPdfFile = null;
        this.pages.disableScreen();
        this.currentDisplay.flush();
        this.objectStoreRef.flush();
        ObjectStore.flushPages();
        this.objectPrintStoreRef.flush();
        this.oldScaling = -1.0f;
        this.pageCount = 0;
    }

    public final byte[] getPdfBuffer() {
        byte[] buf = null;
        if (this.currentPdfFile != null) {
            buf = this.currentPdfFile.getPdfBuffer();
        }
        return buf;
    }

    public final PdfData getPdfBackgroundData() {
        return this.pdfBackgroundData;
    }

    public final PdfData getPdfData() throws PdfException {
        if ((extractionMode & 1) == 0) {
            throw new PdfException("[PDF] Page data object requested will be empty as text extraction disabled. Enable with PdfDecoder method setExtractionMode(PdfDecoder.TEXT | other values");
        }
        return this.pdfData;
    }

    public final PdfPageData getPdfBackgroundPageData() {
        return this.pageData;
    }

    public final boolean hasOutline() {
        return this.hasOutline;
    }

    public final Document getOutlineAsXML() {
        if (this.outlineData == null && this.outlineObject != null) {
            try {
                this.outlineData = new OutlineData(this.pageCount);
                this.outlineData.readOutlineFileMetadata(this.outlineObject, this.currentPdfFile, this.pageLookup);
            }
            catch (Exception e) {
                System.out.println("Exception " + e + " accessing outline " + this.outlineObject);
                this.outlineData = null;
            }
        }
        if (this.outlineData != null) {
            return this.outlineData.getList();
        }
        return null;
    }

    public final PdfPageData getPdfPageData() {
        return this.pageData;
    }

    public void setPagePrintRange(int start, int end) throws PdfException {
        this.start = start;
        this.end = end;
        if (end == Integer.MAX_VALUE) {
            end = this.pageCount;
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (start < 1 || end < 1 || start > this.pageCount || end > this.pageCount) {
            throw new PdfException(String.valueOf(Messages.getMessage((String)"PdfViewerPrint.InvalidPageRange")) + ' ' + start + ' ' + end);
        }
    }

    public void setPrintPageMode(int mode) {
        this.oddPagesOnly = (mode & 0x10) == 16;
        this.evenPagesOnly = (mode & 0x20) == 32;
        this.pagesPrintedInReverse = (mode & 0x40) == 64;
    }

    /*
     * Unable to fully structure code
     */
    public void setPagePrintRange(SetOfIntegerSyntax range) throws PdfException {
        block8: {
            if (range == null) {
                throw new PdfException("[PDF] null page range entered");
            }
            this.range = range;
            this.start = range.next(0);
            rangeCount = 0;
            ii = 0;
            while (ii < this.pageCount) {
                if (range.contains(ii)) {
                    ++rangeCount;
                }
                ++ii;
            }
            this.listOfPages = new int[rangeCount + 1];
            i = this.start;
            this.end = this.start;
            if (!range.contains(0x7FFFFFFF)) ** GOTO lbl19
            this.end = this.pageCount;
            break block8;
lbl-1000:
            // 1 sources

            {
                ++i;
lbl19:
                // 2 sources

                ** while (range.next((int)i) != -1)
            }
lbl20:
            // 1 sources

            this.end = i;
        }
        if (this.start > this.end) {
            tmp = this.start;
            this.start = this.end;
            this.end = tmp;
        }
        j = 0;
        ii = this.start;
        while (ii < this.end + 1) {
            if (!(!range.contains(ii) || this.oddPagesOnly && (ii & 1) != 1 || this.evenPagesOnly && (ii & 1) != 0)) {
                this.listOfPages[j] = ii - this.start;
                ++j;
            }
            ++ii;
        }
        if (this.start < 1 || this.end < 1 || this.start > this.pageCount || this.end > this.pageCount) {
            throw new PdfException(String.valueOf(Messages.getMessage((String)"PdfViewerPrint.InvalidPageRange")) + ' ' + this.start + ' ' + this.end);
        }
    }

    public void setTextPrint(int textPrint) {
        this.textPrint = textPrint;
    }

    public void setCenterOnScaling(boolean center) {
        this.centerOnScaling = center;
    }

    public int print(Graphics graphics, PageFormat pf, int page) throws PrinterException {
        int i;
        block115: {
            int firstPage;
            int lastPage;
            double scaling;
            float dy;
            float dx;
            PdfObject Resources;
            PdfPageObject pdfObject;
            block114: {
                boolean debugRemote = false;
                pdfObject = null;
                Resources = null;
                if (this.stopPrinting) {
                    this.stopPrinting = false;
                    this.start = 0;
                    this.end = 0;
                    return 1;
                }
                i = 0;
                dx = 0.0f;
                dy = 0.0f;
                if (this.range == null && (this.oddPagesOnly || this.evenPagesOnly)) {
                    page *= 2;
                } else if (this.range != null) {
                    page = this.listOfPages[page];
                }
                scaling = 1.0;
                if (this.usePageScaling) {
                    scaling = this.scaling;
                }
                lastPage = this.end;
                firstPage = this.start;
                if (this.pagesPrintedInReverse) {
                    firstPage = this.start;
                    lastPage = this.end;
                    page = this.end - page;
                } else if (this.end != -1 && this.end < this.start) {
                    firstPage = this.end;
                    lastPage = this.start;
                    page = this.start - page;
                } else {
                    page = this.start + page;
                }
                if (this.end == -1) {
                    ++page;
                }
                this.currentPrintPage = page;
                if (!(page > this.pageCount | this.end != -1 & page > lastPage)) break block114;
                this.currentPrintPage = -1;
                if (debugPrint) {
                    System.out.println("no such page");
                }
                return 1;
            }
            try {
                if (!(this.end == -1 | page >= firstPage & page <= lastPage)) break block115;
                this.operationSuccessful = true;
                this.pageErrorMessages = "";
                try {
                    double newScaling;
                    int iH;
                    int clipH;
                    int clipW;
                    int clipY;
                    int clipX;
                    String currentPageOffset = (String)this.pagesReferences.get(new Integer(page));
                    if (currentPageOffset == null && !this.isCustomPrinting) break block115;
                    if (this.currentPdfFile == null && !this.isCustomPrinting) {
                        throw new PrinterException("File not open - did you call closePdfFile() inside a loop and not reopen");
                    }
                    if (!this.isCustomPrinting) {
                        pdfObject = new PdfPageObject(currentPageOffset);
                        this.currentPdfFile.readObject((PdfObject)pdfObject, currentPageOffset, false, null);
                        Resources = pdfObject.getDictionary(2004251818);
                        byte[][] annotList = pdfObject.getKeyArray(1044338049);
                        this.printAnnots = null;
                        if (annotList != null) {
                            this.printAnnots = new PdfAnnots(this.currentPdfFile, null);
                            this.printAnnots.readAnnots(annotList);
                        }
                    }
                    if (this.printHotspots != null && !this.isCustomPrinting) {
                        this.printHotspots.flushAnnotationsDisplayed();
                    }
                    if (this.lastPrintedPage != page) {
                        this.currentPrintDecoder = new PdfStreamDecoder(true);
                        this.currentPrintDecoder.setExternalImageRender(this.customImageHandler);
                        this.currentPrintDecoder.setTextPrint(this.textPrint);
                        this.currentPrintDecoder.optimiseDisplayForPrinting();
                        this.currentPrintDecoder.setStore(this.objectPrintStoreRef);
                        if (!this.isCustomPrinting) {
                            try {
                                this.currentPrintDecoder.init(true, this.renderPage, renderMode, 0, this.pageData, page, null, this.currentPdfFile);
                            }
                            catch (PdfException ee) {
                                throw new PdfFontException(ee.getMessage());
                            }
                            if (this.globalResources != null) {
                                this.currentPrintDecoder.readResources(this.globalResources, true);
                            }
                            if (Resources != null) {
                                this.currentPrintDecoder.readResources(Resources, true);
                            }
                        }
                    }
                    AffineTransform printScaling = new AffineTransform();
                    int mediaW = this.pageData.getMediaBoxWidth(page);
                    int mediaH = this.pageData.getMediaBoxHeight(page);
                    int mediaX = this.pageData.getMediaBoxX(page);
                    int mediaY = this.pageData.getMediaBoxY(page);
                    int crx = clipX = this.pageData.getCropBoxX(page);
                    int cry = clipY = this.pageData.getCropBoxY(page);
                    int crw = clipW = this.pageData.getCropBoxWidth(page) + 1;
                    int crh = clipH = this.pageData.getCropBoxHeight(page) + 1;
                    int rotation = this.pageData.getRotation(this.currentPrintPage);
                    if (this.usePDFPaperSize) {
                        this.createCustomPaper(pf, clipW, clipH);
                    }
                    int iX = (int)pf.getImageableX();
                    int iY = (int)pf.getImageableY();
                    int iW = (int)pf.getImageableWidth() - 1;
                    boolean needsTurning = iW > (iH = (int)pf.getImageableHeight() - 1) && crw < crh || iW < iH && crw > crh;
                    this.docIsLandscaped = false;
                    if ((this.displayRotation == 0 && needsTurning || crw >= crh) && this.printOnlyVisible) {
                        this.docIsLandscaped = true;
                    }
                    if (!this.isPrintAutoRotateAndCenter && !this.usePDFPaperSize) {
                        needsTurning = rotation == 90 || rotation == 270 ? !needsTurning : false;
                    }
                    if (this.docIsLandscaped && this.isPrintAutoRotateAndCenter) {
                        needsTurning = false;
                    }
                    if (needsTurning) {
                        mediaW = this.pageData.getMediaBoxHeight(page);
                        mediaH = this.pageData.getMediaBoxWidth(page);
                        mediaX = this.pageData.getMediaBoxY(page);
                        mediaY = this.pageData.getMediaBoxX(page);
                        crx = clipX = this.pageData.getCropBoxY(page);
                        cry = clipY = this.pageData.getCropBoxX(page);
                        crw = clipW = this.pageData.getCropBoxHeight(page) + 1;
                        crh = clipH = this.pageData.getCropBoxWidth(page) + 1;
                    }
                    if (this.showImageable) {
                        Rectangle printableArea = new Rectangle(iX, iY, iW, iH);
                        Graphics2D printableG2 = (Graphics2D)graphics;
                        printableG2.setColor(Color.red);
                        printableG2.fill(printableArea);
                        printableG2.setColor(Color.white);
                        int xx = 0;
                        while (xx < 1000) {
                            printableG2.draw(new Line2D.Float(xx, 0.0f, xx, 1000.0f));
                            printableG2.draw(new Line2D.Float(0.0f, xx, 1000.0f, xx));
                            xx += 50;
                        }
                        printableG2.draw(printableArea);
                        printableG2.draw(new Line2D.Float(iX, iY, iX + iW, iY + iH));
                        printableG2.draw(new Line2D.Float(iX, iY + iH, iX + iW, iY));
                    }
                    double pScale = 1.0;
                    int print_x_size = crw;
                    int print_y_size = crh;
                    if (this.usePageScaling && (print_x_size = (int)((double)crw * scaling)) > iW | (print_y_size = (int)((double)crh * scaling)) > iH) {
                        print_x_size = crw;
                        print_y_size = crh;
                        scaling = 1.0;
                    }
                    double pageScaleX = (double)iW / (double)print_x_size;
                    double pageScaleY = (double)iH / (double)print_y_size;
                    boolean scaledOnX = true;
                    if (pageScaleX < pageScaleY) {
                        newScaling = pageScaleX;
                    } else {
                        scaledOnX = false;
                        newScaling = pageScaleY;
                    }
                    boolean hasScaling = false;
                    if (this.usePageScaling) {
                        pScale = newScaling;
                        if (print_x_size > iW | print_y_size > iH) {
                            print_x_size = (int)((double)print_x_size * pScale);
                            print_y_size = (int)((double)print_y_size * pScale);
                        }
                    } else {
                        switch (this.pageScalingMode) {
                            case 1: {
                                pScale = newScaling;
                                hasScaling = true;
                                break;
                            }
                            case 2: {
                                if (newScaling < 1.0) {
                                    pScale = newScaling;
                                }
                                hasScaling = true;
                                break;
                            }
                        }
                        dx = -iX;
                        dy = -iY;
                        if (this.pageScalingMode == 1 || pScale < 1.0) {
                            if (scaledOnX) {
                                dx = 0.0f;
                            } else {
                                dy = 0.0f;
                            }
                        }
                        if (!(!this.centerOnScaling || !hasScaling && !this.isPrintAutoRotateAndCenter || this.docIsLandscaped && this.isPrintAutoRotateAndCenter)) {
                            printScaling.translate(((double)iW - (double)crw * pScale) / 2.0, ((double)iH - (double)crh * pScale) / 2.0);
                        }
                    }
                    if (needsTurning) {
                        if (this.usePDFPaperSize && iW < iH && !this.oldSetup) {
                            printScaling.scale(-1.0, 1.0);
                            printScaling.translate(-iX, 0.0);
                        } else if (!(this.isPrintAutoRotateAndCenter || rotation != 0 && rotation != 180)) {
                            printScaling.scale(1.0, -1.0);
                            printScaling.translate(0.0, -iY);
                        } else {
                            printScaling.scale(-1.0, 1.0);
                            printScaling.translate(-iX, 0.0);
                        }
                        printScaling.scale(pScale, pScale);
                        printScaling.rotate(1.5707963267948966);
                        if (hasScaling || this.isPrintAutoRotateAndCenter) {
                            printScaling.translate((double)(-dy) / pScale, (double)(-dx) / pScale);
                        }
                        printScaling.translate(cry, -crx);
                    } else {
                        printScaling.translate(-((double)crx * pScale), (double)cry * pScale);
                        printScaling.translate(iX, iY);
                        if (pScale != 1.0) {
                            if (this.usePageScaling) {
                                printScaling.translate(print_x_size, print_y_size);
                                printScaling.scale(1.0, -1.0);
                                printScaling.translate(-print_x_size, 0.0);
                            } else {
                                printScaling.translate((double)print_x_size * pScale, (double)print_y_size * pScale);
                                printScaling.scale(1.0, -1.0);
                                printScaling.translate((double)(-print_x_size) * pScale, 0.0);
                            }
                            printScaling.scale(pScale, pScale);
                        } else {
                            printScaling.translate(print_x_size, print_y_size);
                            printScaling.scale(1.0, -1.0);
                            printScaling.translate(-print_x_size, 0.0);
                            printScaling.scale(scaling, scaling);
                        }
                    }
                    crx = clipX;
                    cry = clipY;
                    crw = clipW;
                    crh = clipH;
                    RepaintManager currentManager = RepaintManager.currentManager(this);
                    currentManager.setDoubleBufferingEnabled(false);
                    Graphics2D g2 = (Graphics2D)graphics;
                    g2.setRenderingHints(ColorSpaces.hints);
                    g2.transform(printScaling);
                    boolean drawOutline = false;
                    SingleDisplay sd = new SingleDisplay(this);
                    Rectangle vr = sd.getDisplayedRectangle();
                    if (this.printOnlyVisible) {
                        AffineTransform translation = new AffineTransform();
                        AffineTransform enlarge = new AffineTransform();
                        AffineTransform moveToCorner = new AffineTransform();
                        AffineTransform centerOnScreen = new AffineTransform();
                        double sCH = 0.0;
                        double sCW = 0.0;
                        double sCFinal = 0.0;
                        boolean override = false;
                        double[] newVr = this.workoutParameters(this.displayRotation, this.scaling, vr, print_x_size, print_y_size);
                        this.clipVr = this.workoutClipping(this.displayRotation, this.scaling, vr, print_x_size, print_y_size);
                        if (this.docIsLandscaped) {
                            if (this.isPrintAutoRotateAndCenter) {
                                sCH = (double)(iH - 2 * this.insetH) / (newVr[2] * pScale);
                                sCFinal = sCW = (double)(iW - 2 * this.insetW) / (newVr[3] * pScale);
                                override = true;
                                if (sCH < sCFinal) {
                                    sCFinal = sCH;
                                    override = false;
                                }
                            }
                            if (override) {
                                this.isPrintAutoRotateAndCenter = false;
                            }
                            if (!this.isPrintAutoRotateAndCenter) {
                                moveToCorner.translate(-(((double)iW - ((double)crw + 0.0 / pScale) * pScale) / 2.0) / pScale, -(((double)iH - ((double)crh + 0.0 / pScale) * pScale) / 2.0) / pScale);
                                g2.transform(moveToCorner);
                                sCH = (double)(iH - 2 * this.insetH) / (newVr[3] * pScale);
                                sCFinal = sCW = (double)(iW - 2 * this.insetW) / (newVr[2] * pScale);
                                if (sCH < sCFinal) {
                                    sCFinal = sCH;
                                }
                                translation.translate(newVr[0] + (double)this.insetW / sCFinal, newVr[1] + (double)this.insetH / sCFinal);
                                enlarge.scale(sCFinal, sCFinal);
                                g2.transform(enlarge);
                                g2.transform(translation);
                                if (sCFinal == sCW) {
                                    centerOnScreen.translate(0.0, ((double)(iH / 2) - newVr[3] * pScale * sCFinal / 2.0) / sCFinal / pScale);
                                } else {
                                    centerOnScreen.translate(((double)(iW / 2) - newVr[2] * pScale * sCFinal / 2.0) / sCFinal / pScale, 0.0);
                                }
                                g2.transform(centerOnScreen);
                                g2.clip(this.clipVr);
                            } else if (this.isPrintAutoRotateAndCenter) {
                                moveToCorner.translate(0.0, -((double)iH - ((double)crh + 0.0 / pScale) * pScale) / pScale);
                                g2.transform(moveToCorner);
                                sCH = (double)(iH - 2 * this.insetH) / (newVr[2] * pScale);
                                sCFinal = sCW = (double)(iW - 2 * this.insetW) / (newVr[3] * pScale);
                                if (sCH < sCFinal) {
                                    sCFinal = sCH;
                                }
                                translation.rotate(1.5707963267948966);
                                translation.translate(0.0, -newVr[3]);
                                translation.translate(newVr[0] + (double)this.insetW / sCFinal, newVr[1] - (double)this.insetH / sCFinal);
                                enlarge.scale(sCFinal, sCFinal);
                                g2.transform(enlarge);
                                g2.transform(translation);
                                if (sCFinal == sCW) {
                                    centerOnScreen.translate(((double)(iH / 2) - newVr[2] * pScale * sCFinal / 2.0) / sCFinal / pScale, 0.0);
                                } else {
                                    centerOnScreen.translate(0.0, -((double)(iW / 2) - newVr[3] * pScale * sCFinal / 2.0) / sCFinal / pScale);
                                }
                                g2.transform(centerOnScreen);
                                g2.clip(this.clipVr);
                            }
                        } else {
                            sCH = (double)(iH - 2 * this.insetW) / (newVr[2] * pScale);
                            sCW = (double)iW / (newVr[3] * pScale);
                            sCFinal = sCW;
                            if (!(sCH < sCFinal)) {
                                override = true;
                            }
                            if (override) {
                                this.isPrintAutoRotateAndCenter = false;
                            }
                            if (!this.isPrintAutoRotateAndCenter) {
                                moveToCorner.translate(-(Math.abs(((double)iW - ((double)crw + 0.0 / pScale) * pScale) / 2.0) / pScale), -(Math.abs(((double)iH - ((double)crh + 0.0 / pScale) * pScale) / 2.0) / pScale));
                                g2.transform(moveToCorner);
                                sCH = (double)(iH - 2 * this.insetH) / (newVr[3] * pScale);
                                sCFinal = sCW = (double)(iW - 2 * this.insetW) / (newVr[2] * pScale);
                                if (sCH < sCFinal) {
                                    sCFinal = sCH;
                                }
                                translation.translate(newVr[0] + (double)this.insetW / sCFinal, newVr[1] + (double)this.insetH / sCFinal);
                                enlarge.scale(sCFinal, sCFinal);
                                g2.transform(enlarge);
                                g2.transform(translation);
                                if (sCFinal == sCW) {
                                    centerOnScreen.translate(0.0, ((double)(iH / 2) - newVr[3] * sCFinal / 2.0) / sCFinal);
                                } else {
                                    centerOnScreen.translate(((double)(iW / 2) - newVr[2] * sCFinal / 2.0) / sCFinal, 0.0);
                                }
                                g2.transform(centerOnScreen);
                                g2.clip(this.clipVr);
                            } else {
                                moveToCorner.translate(-(((double)iW - ((double)crw + 0.0 / pScale) * pScale) / 2.0) / pScale, -(((double)iH - ((double)crh + 0.0 / pScale) * pScale) / 2.0) / pScale);
                                g2.transform(moveToCorner);
                                sCH = (double)(iH - 2 * this.insetH) / (newVr[2] * pScale);
                                sCFinal = sCW = (double)(iW - 2 * this.insetW) / (newVr[3] * pScale);
                                if (sCH < sCFinal) {
                                    sCFinal = sCH;
                                }
                                translation.rotate(1.5707963267948966);
                                translation.translate(0.0, -newVr[3]);
                                translation.translate(newVr[0] + (double)this.insetW / sCFinal, newVr[1] - (double)this.insetH / sCFinal);
                                enlarge.scale(sCFinal, sCFinal);
                                g2.transform(enlarge);
                                g2.transform(translation);
                                if (sCFinal == sCW) {
                                    centerOnScreen.translate(((double)(iH / 2) - newVr[2] * sCFinal / 2.0) / sCFinal, 0.0);
                                } else {
                                    centerOnScreen.translate(0.0, -((double)(iW / 2) - newVr[3] * sCFinal / 2.0) / sCFinal);
                                }
                                g2.transform(centerOnScreen);
                                g2.clip(this.clipVr);
                            }
                        }
                    }
                    if (this.useARGBFix && ColorSpaceConvertor.isUsingARGB) {
                        g2.translate(pf.getImageableX(), pf.getImageableY());
                        Color alphaWhite = new Color(255, 255, 255, 1);
                        g2.setColor(alphaWhite);
                        g2.drawLine(0, 0, 1, 1);
                    }
                    if (this.showImageable) {
                        g2.setColor(Color.black);
                        if (needsTurning) {
                            g2.draw(new Rectangle(mediaY, mediaX, mediaH, mediaW));
                            g2.drawLine(mediaY, mediaX, mediaH + mediaY, mediaW + mediaX);
                            g2.drawLine(mediaY, mediaW + mediaX, mediaH + mediaY, mediaX);
                        } else {
                            g2.draw(new Rectangle(mediaX, mediaY, mediaW, mediaH));
                            g2.drawLine(mediaX, mediaY, mediaW + mediaX, mediaH + mediaY);
                            g2.drawLine(mediaX, mediaH + mediaY, mediaW + mediaX, mediaY);
                        }
                        g2.setColor(highlightColor);
                        if (needsTurning) {
                            g2.draw(new Rectangle(cry, crx, crh, crw));
                            g2.drawLine(cry, crx, crh + cry, crw + crx);
                            g2.drawLine(cry, crw + crx, crh + cry, crx);
                        } else {
                            g2.draw(new Rectangle(crx, cry, crw, crh));
                            g2.drawLine(crx, cry, crw + crx, crh + cry);
                            g2.drawLine(crx, crh + cry, crw + crx, cry);
                        }
                    } else if (needsTurning) {
                        g2.clip(new Rectangle(cry, crx, crh, crw));
                    } else {
                        g2.clip(new Rectangle(crx, cry, crw, crh));
                    }
                    this.currentPrintDecoder.getRenderer().setScalingValues((double)crx, (double)(crh + cry), (float)pScale);
                    if (this.lastPrintedPage != page) {
                        if (!this.isCustomPrinting) {
                            try {
                                this.currentPrintDecoder.decodePageContent((PdfObject)pdfObject, 0, 0, null, null);
                                Integer keyG = new Integer(-1);
                                int[] typeG = (int[])this.overlayTypeG.get(keyG);
                                Color[] colorsG = (Color[])this.overlayColorsG.get(keyG);
                                Object[] objG = (Object[])this.overlayObjG.get(keyG);
                                this.currentPrintDecoder.getRenderer().drawAdditionalObjectsOverPage(typeG, colorsG, objG);
                                Integer key = new Integer(page);
                                int[] type = (int[])this.overlayType.get(key);
                                Color[] colors = (Color[])this.overlayColors.get(key);
                                Object[] obj = (Object[])this.overlayObj.get(key);
                                this.currentPrintDecoder.getRenderer().drawAdditionalObjectsOverPage(type, colors, obj);
                            }
                            catch (PdfException e2) {
                                e2.printStackTrace();
                                throw new PrinterException(e2.getMessage());
                            }
                        }
                        this.lastPrintedPage = page;
                    }
                    if (this.duplexGapOdd != 0 || this.duplexGapEven != 0) {
                        Shape clip = g2.getClip();
                        if (page % 2 != 1) {
                            g2.translate(this.duplexGapEven, 0);
                        } else {
                            g2.translate(this.duplexGapOdd, 0);
                        }
                        if (clip != null) {
                            g2.setClip(clip);
                        }
                    }
                    if (!this.isCustomPrinting) {
                        this.currentPrintDecoder.print(g2, null, this.showImageable, this.currentPrintPage);
                    } else if (this.printRender == null) {
                        System.out.println("No data for page " + page);
                        LogWriter.writeLog((String)("No data for page " + page));
                    } else {
                        this.printRender.paint(g2, null, null, null, false, false);
                    }
                    g2.setClip(null);
                    if (!this.isCustomPrinting && this.printAnnots != null && this.printHotspots != null) {
                        this.printHotspots.setHotspots(this.printAnnots);
                    }
                    if (this.printHotspots != null) {
                        this.printHotspots.addHotspotsToDisplay(g2, this.userAnnotIcons, page);
                    }
                    if (this.formsAvailable && this.formRenderer != null) {
                        this.formRenderer.getCompData().setPageValues((float)scaling, 0);
                        this.formRenderer.createDisplayComponentsForPage(page);
                        this.formRenderer.getCompData().renderFormsOntoG2((Object)g2, page, (float)scaling, 0, this.displayRotation);
                    }
                    if (this.useBorder && this.myBorder != null) {
                        this.myBorder.paintBorder(this, g2, crx, cry, crw, crh);
                    }
                    currentManager.setDoubleBufferingEnabled(true);
                    if (!this.currentPrintDecoder.isPageSuccessful()) {
                        this.operationSuccessful = false;
                        this.pageErrorMessages = String.valueOf(this.pageErrorMessages) + this.currentPrintDecoder.getPageFailureMessage();
                    }
                    if (!this.operationSuccessful && debugPrint) {
                        System.out.println("Not Successful=" + this.operationSuccessful + '\n' + this.pageErrorMessages);
                    }
                }
                catch (PdfFontException e) {
                    this.operationSuccessful = false;
                    this.pageErrorMessages = String.valueOf(this.pageErrorMessages) + "Missing substitute fonts\n";
                    if (debugPrint) {
                        System.out.println("Exception e=" + (Object)((Object)e));
                    }
                }
                catch (PdfException e) {
                    e.printStackTrace();
                }
            }
            catch (Error err) {
                this.operationSuccessful = false;
                this.pageErrorMessages = String.valueOf(this.pageErrorMessages) + "Memory Error on printing\n";
                if (!debugPrint) break block115;
                System.out.println("Error=" + err);
            }
        }
        if (!this.operationSuccessful) {
            i = 1;
        }
        return i;
    }

    private Rectangle workoutClipping(int displayRotation, float scaling, Rectangle vr, int print_x_size, int print_y_size) {
        Rectangle cRect = null;
        double x = vr.getX();
        double y = vr.getY();
        double w = vr.getWidth();
        double h = vr.getHeight();
        int newX = 0;
        int newY = 0;
        int newW = 0;
        int newH = 0;
        switch (displayRotation) {
            case 0: {
                newX = (int)((float)(vr.x - this.insetW) / this.scaling);
                newY = (int)((float)print_y_size - (float)(vr.y + vr.height - this.insetH) / this.scaling);
                newW = (int)((float)vr.width / this.scaling) - 1;
                newH = (int)((float)vr.height / this.scaling);
                break;
            }
            case 90: {
                newX = (int)((y - (double)this.insetH) / (double)this.scaling);
                newY = (int)((x - (double)this.insetW) / (double)this.scaling);
                newW = (int)(h / (double)this.scaling);
                newH = (int)(w / (double)this.scaling);
                break;
            }
            case 180: {
                newY = (int)(y / (double)this.scaling - (double)((float)this.insetH / this.scaling));
                newX = (int)((double)print_x_size - (x + w - (double)this.insetW) / (double)this.scaling);
                newW = (int)(w / (double)this.scaling);
                newH = (int)(h / (double)this.scaling);
                break;
            }
            case 270: {
                newX = (int)((double)print_x_size - (y + h - (double)this.insetH) / (double)this.scaling);
                newY = (int)((double)print_y_size - (x + w - (double)this.insetW) / (double)this.scaling);
                newW = (int)(h / (double)this.scaling);
                newH = (int)(w / (double)this.scaling);
            }
        }
        cRect = new Rectangle(newX, newY, newW, newH);
        return cRect;
    }

    private double[] workoutParameters(int rotation, float scale, Rectangle rect, int xSize, int ySize) {
        double[] nRect = new double[4];
        double x = rect.getX();
        double y = rect.getY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        double newX = 0.0;
        double newY = 0.0;
        double newW = 0.0;
        double newH = 0.0;
        switch (rotation) {
            case 0: {
                newX = -((x - (double)this.insetW) / (double)this.scaling);
                newY = -((double)ySize - (y + h - (double)this.insetH) / (double)this.scaling);
                newW = w / (double)this.scaling;
                newH = h / (double)this.scaling;
                break;
            }
            case 90: {
                newX = -((y - (double)this.insetH) / (double)this.scaling);
                newY = -((x - (double)this.insetW) / (double)this.scaling);
                newW = h / (double)this.scaling;
                newH = w / (double)this.scaling;
                break;
            }
            case 180: {
                newY = -((y - (double)this.insetH) / (double)this.scaling);
                newX = -((double)xSize - (x + w - (double)this.insetW) / (double)this.scaling);
                newW = w / (double)this.scaling;
                newH = h / (double)this.scaling;
                break;
            }
            case 270: {
                newX = -((double)xSize - (y + h - (double)this.insetW) / (double)this.scaling);
                newY = -((double)ySize - (x + w - (double)this.insetH) / (double)this.scaling);
                newW = h / (double)this.scaling;
                newH = w / (double)this.scaling;
            }
        }
        nRect[0] = newX;
        nRect[1] = newY;
        nRect[2] = newW;
        nRect[3] = newH;
        return nRect;
    }

    private void createCustomPaper(PageFormat pf, int clipW, int clipH) {
        Paper customPaper = new Paper();
        if (this.pageCount == 1) {
            customPaper.setSize(clipW, clipH);
            customPaper.setImageableArea(0.0, 0.0, clipW, clipH);
        } else {
            int paperClipW = 0;
            int paperClipH = 0;
            int t = this.start;
            while (t <= this.end) {
                if (clipW <= this.pageData.getMediaBoxWidth(t) + 1 && clipH <= this.pageData.getMediaBoxHeight(t) + 1) {
                    paperClipW = this.pageData.getMediaBoxWidth(t) + 1;
                    paperClipH = this.pageData.getMediaBoxHeight(t) + 1;
                }
                ++t;
            }
            customPaper.setSize(paperClipW, paperClipH);
            customPaper.setImageableArea(0.0, 0.0, clipW, clipH);
        }
        pf.setPaper(customPaper);
    }

    public BufferedImage getPageAsImage(int pageIndex) throws PdfException {
        return this.getPageAsImage(pageIndex, false);
    }

    public BufferedImage getPageAsTransparentImage(int pageIndex) throws PdfException {
        return this.getPageAsImage(pageIndex, true);
    }

    private BufferedImage getPageAsImage(int pageIndex, boolean imageIsTransparent) throws PdfException {
        BufferedImage image = null;
        String upScale = System.getProperty("org.jpedal.upscale");
        if (upScale != null) {
            this.isOptimisedImage = true;
            try {
                GLOBAL_IMAGE_UPSCALE = Integer.parseInt(upScale);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (extAtBestQuality) {
            useFullSizeImage = true;
            multiplyer = GLOBAL_IMAGE_UPSCALE;
            image = this.getPageAsImageSub(pageIndex, imageIsTransparent);
            if (samplingUsed != -1) {
                multiplyer = samplingUsed;
                image = this.getPageAsImageSub(pageIndex, imageIsTransparent);
                samplingUsed = -1;
                multiplyer = 1.0f;
            }
            useFullSizeImage = false;
            this.getPageAsImageSub(pageIndex, imageIsTransparent);
        } else {
            multiplyer = GLOBAL_IMAGE_UPSCALE;
            image = this.getPageAsImageSub(pageIndex, imageIsTransparent);
        }
        this.isOptimisedImage = false;
        return image;
    }

    private BufferedImage getPageAsImageSub(int pageIndex, boolean imageIsTransparent) throws PdfException {
        BufferedImage image = null;
        if (pageIndex > this.pageCount | pageIndex < 1) {
            LogWriter.writeLog((String)("Page " + pageIndex + " not in range"));
        } else {
            PdfAnnots printAnnots = null;
            Object printAnnotObject = null;
            String currentPageOffset = (String)this.pagesReferences.get(new Integer(pageIndex));
            if (currentPageOffset != null) {
                int w;
                int h;
                if (this.currentPdfFile == null) {
                    throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                }
                PdfPageObject pdfObject = new PdfPageObject(currentPageOffset);
                this.currentPdfFile.resetCache();
                this.currentPdfFile.readObject((PdfObject)pdfObject, currentPageOffset, false, null);
                PdfObject Resources = pdfObject.getDictionary(2004251818);
                if (this.printHotspots != null) {
                    this.printHotspots.flushAnnotationsDisplayed();
                }
                if (!extAtBestQuality) {
                    multiplyer = this.pageData.getScalingValue();
                }
                AffineTransform imageScaling = this.setPageParametersForImage(1.0f * multiplyer, pageIndex);
                int mediaW = this.pageData.getMediaBoxWidth(pageIndex);
                int mediaH = this.pageData.getMediaBoxHeight(pageIndex);
                int rotation = this.pageData.getRotation(pageIndex);
                int crw = this.pageData.getCropBoxWidth(pageIndex);
                int crh = this.pageData.getCropBoxHeight(pageIndex);
                int crx = this.pageData.getCropBoxX(pageIndex);
                int cry = this.pageData.getCropBoxY(pageIndex);
                boolean rotated = false;
                if (rotation == 90 || rotation == 270) {
                    h = (int)((float)crw * multiplyer);
                    w = (int)((float)crh * multiplyer);
                    rotated = true;
                } else {
                    w = (int)((float)crw * multiplyer);
                    h = (int)((float)crh * multiplyer);
                }
                image = new BufferedImage(w, h, 2);
                Graphics graphics = image.getGraphics();
                Graphics2D g2 = (Graphics2D)graphics;
                if (!imageIsTransparent) {
                    g2.setColor(Color.white);
                    g2.fillRect(0, 0, w, h);
                }
                ObjectStore localStore = new ObjectStore();
                PdfStreamDecoder currentImageDecoder = new PdfStreamDecoder();
                currentImageDecoder.setExternalImageRender(this.customImageHandler);
                currentImageDecoder.setName(this.filename);
                currentImageDecoder.setStore(localStore);
                if (imageIsTransparent) {
                    DynamicVectorRenderer imageDisplay = new DynamicVectorRenderer(this.pageNumber, false, 5000, localStore);
                    currentImageDecoder.init(true, this.renderPage, renderMode, 0, this.pageData, pageIndex, imageDisplay, this.currentPdfFile);
                } else {
                    currentImageDecoder.init(true, this.renderPage, renderMode, 0, this.pageData, pageIndex, null, this.currentPdfFile);
                }
                if (this.globalResources != null) {
                    currentImageDecoder.readResources(this.globalResources, true);
                }
                if (Resources != null) {
                    currentImageDecoder.readResources(Resources, true);
                }
                currentImageDecoder.getRenderer().setScalingValues((double)crx, (double)((float)crh * multiplyer + (float)cry), 1.0f);
                g2.setRenderingHints(ColorSpaces.hints);
                g2.transform(imageScaling);
                if (rotated) {
                    if (rotation == 90) {
                        if (cry < 0) {
                            g2.translate(-crx, -cry);
                        } else {
                            g2.translate(-crx, cry);
                        }
                    } else if (cry < 0) {
                        g2.translate(-crx, mediaH - crh + cry);
                    } else {
                        g2.translate(-crx, mediaH - crh - cry);
                    }
                }
                currentImageDecoder.setDirectRendering(g2);
                if (pdfObject != null) {
                    currentImageDecoder.decodePageContent((PdfObject)pdfObject, 0, 0, null, null);
                }
                g2.setClip(null);
                if (printAnnots != null && this.printHotspots != null) {
                    this.printHotspots.setHotspots(printAnnots);
                }
                if (this.printHotspots != null) {
                    this.printHotspots.addHotspotsToDisplay(g2, this.userAnnotIcons, pageIndex);
                }
                if (this.formsAvailable && this.formRenderer != null) {
                    this.formRenderer.getCompData().setPageValues(this.scaling, 0);
                    this.formRenderer.createDisplayComponentsForPage(pageIndex);
                    this.formRenderer.getCompData().renderFormsOntoG2((Object)g2, pageIndex, this.scaling, 0, this.displayRotation);
                    this.formRenderer.getCompData().resetScaledLocation(this.oldScaling, this.displayRotation, 0);
                }
                localStore.flush();
            }
            if (!this.isOptimisedImage && !imageIsTransparent && image != null) {
                image = ColorSpaceConvertor.convertToRGB(image);
            }
        }
        return image;
    }

    public final void flushObjectValues(boolean reinit) {
        if (this.pdfData != null) {
            this.pdfData.flushTextList(reinit);
        }
        if (this.currentAcroFormData != null) {
            this.currentAcroFormData = new PdfFormData(false);
        }
        if (this.pdfImages != null && reinit) {
            this.pdfImages.clearImageData();
        }
    }

    public final PdfImageData getPdfImageData() {
        return this.pdfImages;
    }

    public final PdfImageData getPdfBackgroundImageData() {
        return this.pdfBackgroundImages;
    }

    public final PdfAnnots getPdfAnnotsData(AcroRenderer formRenderer) {
        if (this.annotsData == null) {
            try {
                if (this.annotList != null) {
                    this.annotsData = new PdfAnnots(this.currentPdfFile, null);
                    this.annotsData.readAnnots(this.annotList);
                }
            }
            catch (Exception e) {
                LogWriter.writeLog((String)("[PDF] " + e + " with annotation"));
            }
        }
        return this.annotsData;
    }

    private void readAcroForm(Object currentFormOffset) {
        String value;
        String formObject = "";
        this.formKids.clear();
        HashMap<String, Map> kidData = new HashMap<String, Map>();
        if (!this.useForms) {
            return;
        }
        LogWriter.writeLog((String)"Form data being read");
        Vector<String> queue = new Vector<String>();
        Map values = currentFormOffset instanceof String ? this.currentPdfFile.readObject(new PdfObject((String)currentFormOffset), (String)currentFormOffset, false, null) : (Map)currentFormOffset;
        boolean bl = this.isXFA = values.get("XFA") != null;
        if (this.isXFA) {
            Object vals;
            if (this.currentAcroFormData == null) {
                this.currentAcroFormData = new PdfFormData(false);
            }
            if ((vals = values.get("XFA")) instanceof String) {
                String xfaValue = (String)vals;
                if (xfaValue.endsWith(" R")) {
                    byte[] stream = this.currentPdfFile.readStream(xfaValue, true);
                } else if (xfaValue.indexOf(91) == -1) {
                    LogWriter.writeFormLog((String)"{PdfDecoder.readAcroForm} Not implemented - XFA form stream in PdfDecoder as Object is direct eg. /XFA 23 0 R", (boolean)false);
                } else {
                    xfaValue = Strip.removeArrayDeleminators((String)xfaValue);
                    StringTokenizer tokens = new StringTokenizer(xfaValue, "()", true);
                    while (tokens.hasMoreTokens()) {
                        String dataRef;
                        String nextValue = tokens.nextToken();
                        if (!nextValue.equals("(")) continue;
                        nextValue = tokens.nextToken();
                        tokens.nextToken();
                        if (nextValue.equals("template")) {
                            dataRef = tokens.nextToken().trim();
                            try {
                                this.currentAcroFormData.setXFAFormData(0, this.currentPdfFile.readStream(dataRef, true));
                            }
                            catch (PdfException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (nextValue.equals("datasets")) {
                            dataRef = tokens.nextToken().trim();
                            try {
                                this.currentAcroFormData.setXFAFormData(1, this.currentPdfFile.readStream(dataRef, true));
                            }
                            catch (PdfException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (!nextValue.equals("config")) continue;
                        dataRef = tokens.nextToken().trim();
                        try {
                            this.currentAcroFormData.setXFAFormData(2, this.currentPdfFile.readStream(dataRef, true));
                        }
                        catch (PdfException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                System.out.println("Not implemented -XFA form function in PdfDecoder");
                if (showErrorMessages) {
                    JOptionPane.showMessageDialog(null, "Not implemented -XFA form function in PdfDecoder");
                }
            }
        }
        if ((value = (String)values.get("Fields")) != null) {
            int p = value.indexOf(93);
            if (p != 0) {
                value = value.substring(0, p + 1);
            }
            value = Strip.removeArrayDeleminators((String)value);
            boolean fieldsToProcess = true;
            StringTokenizer initialValues = new StringTokenizer(value, "R");
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("T", "x");
            fields.put("TM", "x");
            fields.put("TU", "x");
            fields.put("CA", "x");
            fields.put("R", "x");
            fields.put("V", "x");
            fields.put("RC", "x");
            fields.put("DA", "x");
            fields.put("DV", "x");
            fields.put("JS", "x");
            if (initialValues.hasMoreTokens()) {
                formObject = this.stripNulls(String.valueOf(initialValues.nextToken().trim()) + " R");
                while (initialValues.hasMoreTokens()) {
                    queue.addElement(this.stripNulls(String.valueOf(initialValues.nextToken().trim()) + " R"));
                }
            } else {
                fieldsToProcess = false;
            }
            StringTokenizer kidObjects = null;
            HashMap<String, String> names = new HashMap<String, String>();
            while (fieldsToProcess) {
                int kidCount;
                String kids;
                Map formData = this.currentPdfFile.readObject(new PdfObject(formObject), formObject, false, fields);
                Map parentData = (Map)kidData.get(formObject);
                if (formData.containsKey("T")) {
                    String valueFromFDF;
                    String name;
                    if (formData.containsKey("Kids")) {
                        name = (String)this.currentPdfFile.resolveToMapOrString((Object)"T", formData.get("T"));
                        String parentRef = (String)formData.get("Parent");
                        while (parentRef != null) {
                            Map parentObj = this.currentPdfFile.readObject(new PdfObject(parentRef), parentRef, false, fields);
                            String parentName = (String)this.currentPdfFile.resolveToMapOrString((Object)"T", parentObj.get("T"));
                            if (parentName == null) continue;
                            name = String.valueOf(parentName) + '.' + name;
                            parentRef = (String)parentObj.get("Parent");
                        }
                        formData.put("T", name);
                        names.put(formObject, name);
                    } else {
                        Object parent = formData.get("Parent");
                        if (parent == null) {
                            formData.put("T", this.currentPdfFile.resolveToMapOrString((Object)"T", formData.get("T")));
                        } else {
                            formData.put("T", names.get(parent) + "." + this.currentPdfFile.resolveToMapOrString((Object)"T", formData.get("T")));
                        }
                    }
                    if (this.fdfData != null && (valueFromFDF = (String)this.fdfData.get(name = (String)formData.get("T"))) != null) {
                        formData.put("V", valueFromFDF);
                    }
                }
                if (parentData != null) {
                    Iterator i = parentData.keySet().iterator();
                    while (i.hasNext()) {
                        Object key = i.next();
                        Object kidValue = parentData.get(key);
                        if (formData.containsKey(key)) continue;
                        formData.put(key, kidValue);
                    }
                }
                boolean flatten = true;
                String fieldType = (String)formData.get("FT");
                if (fieldType != null && fieldType.indexOf("Btn") != -1) {
                    String flag = (String)formData.get("Ff");
                    if (flag == null) {
                        flatten = false;
                    } else {
                        int flagValue = Integer.parseInt(flag);
                        if ((flagValue & 0x10000) != 65536) {
                            flatten = false;
                        }
                    }
                }
                if ((kids = (String)formData.get("Kids")) != null) {
                    String initialPageList = kids;
                    if (initialPageList.startsWith("[")) {
                        initialPageList = Strip.removeArrayDeleminators((String)initialPageList).trim();
                    }
                    kidObjects = new StringTokenizer(initialPageList, "R");
                    kidCount = flatten ? 1 : kidObjects.countTokens();
                } else {
                    kidCount = 0;
                }
                String type = (String)formData.get("Type");
                if (kidCount > 1 || type != null && type.equals("/Annot")) {
                    if (this.currentAcroFormData == null) {
                        this.currentAcroFormData = new PdfFormData(false);
                    }
                    if (kidCount == 0) {
                        kidCount = 1;
                    }
                    this.currentAcroFormData.incrementCount(kidCount);
                    if (this.pageCount < 2) {
                        formData.put("PageNumber", "1");
                    }
                    if (formData.containsKey("P")) {
                        try {
                            Object rawValue = formData.get("P");
                            if (rawValue != null && this.pageLookup != null && rawValue instanceof String) {
                                int page = this.pageLookup.convertObjectToPageNumber((String)rawValue);
                                formData.put("PageNumber", String.valueOf(page));
                            }
                        }
                        catch (Exception rawValue) {
                            // empty catch block
                        }
                    }
                    if (kidCount > 1) {
                        String kidrefs = (String)formData.get("Kids");
                        kidObjects = new StringTokenizer(Strip.removeArrayDeleminators((String)kidrefs), "R");
                        HashMap<String, Map> formObjects = new HashMap<String, Map>();
                        while (kidObjects.hasMoreTokens()) {
                            String next_value = String.valueOf(kidObjects.nextToken().trim()) + " R";
                            this.formKids.put(next_value, formObject);
                            Map kidValue = this.currentPdfFile.readObject(new PdfObject(next_value), next_value, false, fields);
                            kidValue.put("PageNumber", "1");
                            String correctedName = (String)formData.get("T");
                            if (correctedName != null) {
                                kidValue.put("T", correctedName);
                            }
                            if (kidValue.containsKey("P")) {
                                try {
                                    Object rawValue = kidValue.get("P");
                                    if (rawValue != null && this.pageLookup != null && rawValue instanceof String) {
                                        int page = this.pageLookup.convertObjectToPageNumber((String)rawValue);
                                        kidValue.put("PageNumber", String.valueOf(page));
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            formObjects.put(next_value, kidValue);
                        }
                        formData.put("Kids", formObjects);
                    }
                    formData.put("obj", formObject);
                    try {
                        this.currentAcroFormData.addFormElement(formData);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (kidCount == 1) {
                    while (kidObjects.hasMoreTokens()) {
                        String next_value = String.valueOf(kidObjects.nextToken().trim()) + " R";
                        queue.addElement(next_value);
                        formData.remove("Kids");
                        kidData.put(next_value, formData);
                    }
                }
                if (queue.isEmpty()) break;
                formObject = (String)queue.firstElement();
                queue.removeElement(formObject);
            }
        }
    }

    private String stripNulls(String rawString) {
        int ptr = rawString.lastIndexOf("null");
        if (ptr == -1) {
            return rawString;
        }
        return rawString.substring(ptr + 4).trim();
    }

    public final void setRenderMode(int mode) {
        renderMode = mode;
        extractionMode = mode;
    }

    public final void setExtractionMode(int mode) {
        extractionMode = mode;
    }

    public static void modifyJPedalParameters(Map values) throws PdfException {
        Iterator keys = values.keySet().iterator();
        while (keys.hasNext()) {
            Object nextKey = keys.next();
            if (nextKey instanceof Integer) {
                Integer key = (Integer)nextKey;
                Object rawValue = values.get(key);
                if (key.equals(JPedalSettings.TEXT_INVERTED_COLOUR)) {
                    if (rawValue instanceof Color) {
                        backgroundColor = (Color)rawValue;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.TEXT_INVERTED_COLOUR expects a Color value");
                }
                if (key.equals(JPedalSettings.TEXT_HIGHLIGHT_COLOUR)) {
                    if (rawValue instanceof Color) {
                        highlightColor = (Color)rawValue;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.TEXT_HIGHLIGHT_COLOUR expects a Color value");
                }
                if (key.equals(JPedalSettings.TEXT_PRINT_NON_EMBEDDED_FONTS)) {
                    if (rawValue instanceof Boolean) {
                        Boolean value = (Boolean)rawValue;
                        PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts = value;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.TEXT_PRINT_NON_EMBEDDED_FONTS expects a Boolean value");
                }
                if (key.equals(JPedalSettings.DISPLAY_INVISIBLE_TEXT)) {
                    if (rawValue instanceof Boolean) {
                        Boolean value = (Boolean)rawValue;
                        PdfStreamDecoder.showInvisibleText = value;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.DISPLAY_INVISIBLE_TEXT expects a Boolean value");
                }
                if (key.equals(JPedalSettings.CACHE_LARGE_FONTS)) {
                    if (rawValue instanceof Integer) {
                        Integer value = (Integer)rawValue;
                        FontData.maxSizeAllowedInMemory = value;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.CACHE_LARGE_FONTS expects an Integer value");
                }
                if (key.equals(JPedalSettings.IMAGE_UPSCALE)) {
                    int upScaleVal = 0;
                    if (rawValue instanceof Integer) {
                        String upScale = System.getProperty("org.jpedal.upscale");
                        GLOBAL_IMAGE_UPSCALE = (Integer)rawValue;
                        if (upScale != null) {
                            try {
                                upScaleVal = Integer.parseInt(upScale);
                            }
                            catch (NumberFormatException nfe) {
                                System.out.println("Parameter of \"org.jpedal.upscale\" is not a valid number, the value form the map will be used instead");
                                upScaleVal = 1;
                            }
                            if (upScaleVal != GLOBAL_IMAGE_UPSCALE) {
                                GLOBAL_IMAGE_UPSCALE = (Integer)rawValue;
                                throw new PdfException("JPedalSettings.IMAGE_UPSCALE - second parameter of a different value has already been passed as JVM command");
                            }
                            GLOBAL_IMAGE_UPSCALE = upScaleVal;
                        }
                        if (GLOBAL_IMAGE_UPSCALE >= 1) continue;
                        GLOBAL_IMAGE_UPSCALE = 1;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.IMAGE_UPSCALE expects an Integer value");
                }
                if (key.equals(JPedalSettings.IMAGE_HIRES)) {
                    if (rawValue instanceof Boolean) {
                        Boolean value = (Boolean)rawValue;
                        hires = value;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.IMAGE_HIRES expects a Boolean value");
                }
                if (key.equals(JPedalSettings.EXTRACT_AT_BEST_QUALITY)) {
                    if (rawValue instanceof Boolean) {
                        Boolean value = (Boolean)rawValue;
                        extAtBestQuality = value;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.EXTRACT_AT_BEST_QUALITY expects a Boolean value");
                }
                throw new PdfException("Unknown or unsupported key " + key);
            }
            throw new PdfException("Unknown or unsupported key (not Integer) " + nextKey);
        }
    }

    public final void markAllPagesAsUnread() {
    }

    public final boolean isForm() {
        return this.isForm;
    }

    public final PdfFormData getPdfFormData() {
        return this.currentAcroFormData;
    }

    protected Map readObjectForPage(PdfObject pdfObject, String currentPageOffset, int page, boolean redraw) {
        Map values = this.currentPdfFile.readObject(pdfObject, currentPageOffset, false, null);
        if (this.formsAvailable && this.renderPage && !this.stopDecoding) {
            if (this.formRenderer != null && this.currentAcroFormData != null && !this.stopDecoding) {
                this.formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation);
                this.formRenderer.createDisplayComponentsForPage(page);
            }
            if (redraw) {
                this.lastFormPage = -1;
                this.lastEnd = -1;
                this.lastStart = -1;
            }
        }
        return values;
    }

    public final PdfFileInformation getFileInformationData() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.readPdfFileMetadata(this.XMLObject);
        }
        return null;
    }

    public final void setExtractionMode(int mode, int imageDpi, float scaling) {
        if (dpi % 72 != 0) {
            LogWriter.writeLog((String)"Dpi is not a factor of 72- this may cause problems");
        }
        dpi = imageDpi;
        this.scaling = scaling;
        this.pageData.setScalingValue(scaling);
        extractionMode = mode;
    }

    public final PdfAnnots decodePageForAnnotations(int i) {
        if (i == this.annotPage) {
            return this.annotsData;
        }
        this.annotsData = null;
        if (i > this.pageCount) {
            LogWriter.writeLog((String)"Page out of bounds");
        } else {
            String currentPageOffset = (String)this.pagesReferences.get(new Integer(i));
            if (currentPageOffset != null) {
                PdfPageObject pdfObject = new PdfPageObject(currentPageOffset);
                this.currentPdfFile.readObject((PdfObject)pdfObject, currentPageOffset, false, null);
                byte[][] annotList = pdfObject.getKeyArray(1044338049);
                if (annotList != null) {
                    this.annotsData = new PdfAnnots(this.currentPdfFile, null);
                    this.annotsData.readAnnots(annotList);
                }
                this.annotPage = i;
            }
        }
        return this.annotsData;
    }

    public final BufferedImage getPageAsThumbnail(int pageNumber, int h) {
        DynamicVectorRenderer imageDisplay = new DynamicVectorRenderer(pageNumber, true, 1000, this.objectStoreRef);
        imageDisplay.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
        try {
            if (pageNumber > this.pageCount) {
                LogWriter.writeLog((String)("Page " + pageNumber + " out of bounds"));
            } else {
                int mediaX = this.pageData.getMediaBoxX(pageNumber);
                int mediaY = this.pageData.getMediaBoxY(pageNumber);
                int mediaW = this.pageData.getMediaBoxWidth(pageNumber);
                int mediaH = this.pageData.getMediaBoxHeight(pageNumber);
                String currentPageOffset = (String)this.pagesReferences.get(new Integer(pageNumber));
                if (currentPageOffset != null) {
                    PdfPageObject pdfObject = new PdfPageObject(currentPageOffset);
                    this.currentPdfFile.readObject((PdfObject)pdfObject, currentPageOffset, false, null);
                    PdfObject Resources = pdfObject.getDictionary(2004251818);
                    if (pdfObject != null) {
                        PdfStreamDecoder imageDecoder = new PdfStreamDecoder(this.useHiResImageForDisplay);
                        imageDecoder.setExternalImageRender(this.customImageHandler);
                        imageDecoder.setName(this.filename);
                        imageDecoder.setStore(this.objectStoreRef);
                        imageDecoder.init(true, true, renderMode, 0, this.pageData, pageNumber, imageDisplay, this.currentPdfFile);
                        if (this.globalResources != null) {
                            imageDecoder.readResources(this.globalResources, true);
                        }
                        if (Resources != null) {
                            imageDecoder.readResources(Resources, true);
                        }
                        int rotation = this.pageData.getRotation(pageNumber);
                        imageDisplay.init(mediaW, mediaH, rotation);
                        imageDecoder.decodePageContent((PdfObject)pdfObject, mediaX, mediaY, null, null);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BufferedImage image = this.getImageFromRenderer(h, imageDisplay, pageNumber);
        return image;
    }

    public void setStatusBarObject(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    public void waitForRenderingToFinish() {
        while (this.isDecoding()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isDecoding() {
        boolean decodeStatus = true;
        if (!(this.isDecoding || this.pages.isDecoding() || this.current != null && !this.current.exitedDecoding())) {
            decodeStatus = false;
        }
        return decodeStatus;
    }

    public final void stopPrinting() {
        this.stopPrinting = true;
    }

    public void stopDecoding() {
        if (this.stopDecoding) {
            return;
        }
        this.pages.stopGeneratingPage();
        this.stopDecoding = true;
        if (this.currentPdfFile != null) {
            this.currentPdfFile.setInterruptRefReading(true);
        }
        if (this.current != null) {
            this.current.terminateDecoding();
        }
        while (this.isDecoding()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.currentPdfFile != null) {
            this.currentPdfFile.setInterruptRefReading(false);
        }
        this.stopDecoding = false;
        if (this.renderPage && this.formsAvailable && this.formRenderer != null) {
            this.formRenderer.removeDisplayComponentsFromScreen();
        }
    }

    public DynamicVectorRenderer getDynamicRenderer() {
        return this.currentDisplay;
    }

    public DynamicVectorRenderer getDynamicRenderer(boolean reset) {
        DynamicVectorRenderer latestVersion = this.currentDisplay;
        if (reset) {
            this.currentDisplay = new DynamicVectorRenderer(0, this.objectStoreRef, false);
        }
        return latestVersion;
    }

    public final void decodePageForMarkedContent(String ref, Object pageStream) throws Exception {
        if (!this.stopDecoding) {
            int page = ref.indexOf(32) != -1 ? this.pageLookup.convertObjectToPageNumber(ref) : Integer.parseInt(ref);
            String currentPageOffset = (String)this.pagesReferences.get(new Integer(page));
            if (currentPageOffset != null && this.currentPdfFile == null) {
                throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
            }
            PdfPageObject pdfObject = new PdfPageObject(currentPageOffset);
            this.currentPdfFile.readObject((PdfObject)pdfObject, currentPageOffset, false, null);
            PdfObject Resources = pdfObject.getDictionary(2004251818);
            if (pdfObject != null) {
                PdfStreamDecoder current = new PdfStreamDecoder(this.useHiResImageForDisplay);
                current.setName(this.filename);
                current.setStore(this.objectStoreRef);
                current.includeImages();
                current.setStatusBar(this.statusBar);
                int mode = 7;
                if (!this.stopDecoding) {
                    current.init(true, false, renderMode, mode, this.pageData, page, null, this.currentPdfFile);
                    if (this.globalResources != null) {
                        current.readResources(this.globalResources, true);
                    }
                    if (Resources != null) {
                        current.readResources(Resources, true);
                    }
                }
                current.setMapForMarkedContent(pageStream);
                current.decodePageContent((PdfObject)pdfObject, 0, 0, null, null);
            }
        }
    }

    public final void decodeOtherPages(int pageCount) {
        this.pages.decodeOtherPages(this.pageNumber, pageCount);
    }

    public final void decodePage(int page) throws Exception {
        this.lastPageDecoded = page;
        this.decodeStatus = "";
        if (this.displayView != 1) {
            return;
        }
        this.stopDecoding();
        this.currentPdfFile.resetCache();
        if (this.isDecoding) {
            LogWriter.writeLog((String)"[PDF]WARNING - this file is being decoded already");
            this.isDecoding = false;
        } else {
            try {
                this.isDecoding = true;
                this.cursorBoxOnScreen = null;
                if (this.renderPage && this.formsAvailable && this.formRenderer != null) {
                    this.formRenderer.removeDisplayComponentsFromScreen();
                    this.lastFormPage = -1;
                }
                this.currentDisplay.flush();
                this.pages.refreshDisplay();
                if (page > this.pageCount || page < 1) {
                    LogWriter.writeLog((String)"Page out of bounds");
                } else if (!this.stopDecoding) {
                    Timer t = null;
                    if (this.statusBar != null) {
                        ProgressListener listener = new ProgressListener();
                        t = new Timer(500, listener);
                        t.start();
                    }
                    this.pageNumber = page;
                    String currentPageOffset = (String)this.pagesReferences.get(new Integer(page));
                    if (currentPageOffset != null && this.currentPdfFile == null) {
                        throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                    }
                    PdfPageObject pdfObject = new PdfPageObject(currentPageOffset);
                    this.currentPdfFile.readObject((PdfObject)pdfObject, currentPageOffset, false, null);
                    PdfObject Resources = pdfObject.getDictionary(2004251818);
                    if (pdfObject != null && !this.stopDecoding) {
                        if (!this.showAnnotations || page > 100) {
                            if (this.annotPage != page) {
                                this.annotPage = page;
                                this.annotList = pdfObject.getKeyArray(1044338049);
                                this.annotsData = null;
                            }
                            if (this.renderPage && !this.stopDecoding) {
                                this.pagesRead.put(new Integer(page), "x");
                                this.annotsData = this.getPdfAnnotsData(this.formRenderer);
                            }
                            if (this.formsAvailable && this.showAnnotations && this.annotsData != null) {
                                this.formRenderer.resetAnnotData((Object)this.annotsData, this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.formKids);
                            }
                        }
                        byte[][] pageContents = pdfObject.getKeyArray(1216184967);
                        if (this.displayHotspots != null && !this.stopDecoding) {
                            this.displayHotspots.flushAnnotationsDisplayed();
                        }
                        if (pageContents != null && !this.stopDecoding) {
                            this.current = new PdfStreamDecoder(this.useHiResImageForDisplay);
                            this.current.setExternalImageRender(this.customImageHandler);
                            this.current.setName(this.filename);
                            this.current.setStore(this.objectStoreRef);
                            if (this.includeImages) {
                                this.current.includeImages();
                            }
                            this.current.setStatusBar(this.statusBar);
                            this.currentDisplay.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
                            if (!this.stopDecoding) {
                                this.current.init(true, this.renderPage, renderMode, extractionMode, this.pageData, page, this.currentDisplay, this.currentPdfFile);
                            }
                            if (this.globalResources != null) {
                                this.current.readResources(this.globalResources, true);
                            }
                            if (Resources != null) {
                                this.current.readResources(Resources, true);
                            }
                            if (!this.stopDecoding) {
                                this.current.setStatusBar(this.statusBar);
                            }
                            int mediaW = this.pageData.getMediaBoxWidth(this.pageNumber);
                            int mediaH = this.pageData.getMediaBoxHeight(this.pageNumber);
                            int rotation = this.pageData.getRotation(this.pageNumber);
                            this.currentDisplay.init(mediaW, mediaH, rotation);
                            if (this.g2 != null) {
                                this.current.setDirectRendering(this.g2);
                            }
                            try {
                                if (!this.stopDecoding) {
                                    this.current.decodePageContent((PdfObject)pdfObject, 0, 0, null, null);
                                }
                            }
                            catch (Error err) {
                                this.decodeStatus = String.valueOf(this.decodeStatus) + "Error in decoding page " + err.toString();
                            }
                            if (!this.stopDecoding) {
                                this.hasEmbeddedFonts = this.current.hasEmbeddedFonts();
                                this.fontsInFile = PdfStreamDecoder.getFontsInFile();
                                this.pdfData = this.current.getText();
                                if (embedWidthData) {
                                    this.pdfData.widthIsEmbedded();
                                }
                                this.pdfData.maxX = mediaW;
                                this.pdfData.maxY = mediaH;
                                this.pdfImages = this.current.getImages();
                                this.pageLines = this.current.getPageLines();
                            }
                            this.imagesProcessedFully = this.current.getPageDecodeStatus(2);
                            this.hasNonEmbeddedCIDFonts = this.current.getPageDecodeStatus(4);
                            this.nonEmbeddedCIDFonts = this.current.getPageDecodeStatusReport(4);
                            this.current = null;
                        }
                    }
                    if (t != null) {
                        t.stop();
                        this.statusBar.setProgress(100);
                    }
                    this.isDecoding = false;
                    if (this.formsAvailable && this.renderPage && !this.stopDecoding) {
                        if (this.formRenderer != null && !this.formRenderer.ignoreForms()) {
                            this.formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation);
                            this.formRenderer.createDisplayComponentsForPage(page);
                        }
                        if (this.javascript != null && this.useJavascript && this.formRenderer != null) {
                            this.formRenderer.getActionHandler().PO(this.pageNumber);
                            this.formRenderer.getActionHandler().O(this.pageNumber);
                        }
                        this.validate();
                    }
                    if (this.annotsData != null && this.displayHotspots != null && !this.stopDecoding) {
                        this.displayHotspots.setHotspots(this.annotsData);
                    }
                }
                this.current = null;
                this.currentDisplay.flagDecodingFinished();
            }
            finally {
                this.isDecoding = false;
            }
        }
    }

    public void printAdditionalObjectsOverPage(int page, int[] type, Color[] colors, Object[] obj) throws PdfException {
        Integer key = new Integer(page);
        if (obj == null) {
            this.overlayType.remove(key);
            this.overlayColors.remove(key);
            this.overlayObj.remove(key);
        } else {
            int[] oldType = (int[])this.overlayType.get(key);
            if (oldType == null) {
                this.overlayType.put(key, type);
            } else {
                int oldLength = oldType.length;
                int newLength = type.length;
                int[] combined = new int[oldLength + newLength];
                System.arraycopy(oldType, 0, combined, 0, oldLength);
                System.arraycopy(type, 0, combined, oldLength, newLength);
                this.overlayType.put(key, combined);
            }
            Color[] oldCol = (Color[])this.overlayColors.get(key);
            if (oldCol == null) {
                this.overlayColors.put(key, colors);
            } else {
                int oldLength = oldCol.length;
                int newLength = colors.length;
                Color[] combined = new Color[oldLength + newLength];
                System.arraycopy(oldCol, 0, combined, 0, oldLength);
                System.arraycopy(colors, 0, combined, oldLength, newLength);
                this.overlayColors.put(key, combined);
            }
            Object[] oldObj = (Object[])this.overlayObj.get(key);
            if (oldType == null) {
                this.overlayObj.put(key, obj);
            } else {
                int oldLength = oldObj.length;
                int newLength = obj.length;
                Object[] combined = new Object[oldLength + newLength];
                System.arraycopy(oldObj, 0, combined, 0, oldLength);
                System.arraycopy(obj, 0, combined, oldLength, newLength);
                this.overlayObj.put(key, combined);
            }
        }
    }

    public void printAdditionalObjectsOverAllPages(int[] type, Color[] colors, Object[] obj) throws PdfException {
        Integer key = new Integer(-1);
        if (obj == null) {
            this.overlayTypeG.remove(key);
            this.overlayColorsG.remove(key);
            this.overlayObjG.remove(key);
        } else {
            int[] oldType = (int[])this.overlayTypeG.get(key);
            if (oldType == null) {
                this.overlayTypeG.put(key, type);
            } else {
                int oldLength = oldType.length;
                int newLength = type.length;
                int[] combined = new int[oldLength + newLength];
                System.arraycopy(oldType, 0, combined, 0, oldLength);
                System.arraycopy(type, 0, combined, oldLength, newLength);
                this.overlayTypeG.put(key, combined);
            }
            Color[] oldCol = (Color[])this.overlayColorsG.get(key);
            if (oldCol == null) {
                this.overlayColorsG.put(key, colors);
            } else {
                int oldLength = oldCol.length;
                int newLength = colors.length;
                Color[] combined = new Color[oldLength + newLength];
                System.arraycopy(oldCol, 0, combined, 0, oldLength);
                System.arraycopy(colors, 0, combined, oldLength, newLength);
                this.overlayColorsG.put(key, combined);
            }
            Object[] oldObj = (Object[])this.overlayObjG.get(key);
            if (oldType == null) {
                this.overlayObjG.put(key, obj);
            } else {
                int oldLength = oldObj.length;
                int newLength = obj.length;
                Object[] combined = new Object[oldLength + newLength];
                System.arraycopy(oldObj, 0, combined, 0, oldLength);
                System.arraycopy(obj, 0, combined, oldLength, newLength);
                this.overlayObjG.put(key, combined);
            }
        }
    }

    public void drawAdditionalObjectsOverPage(int page, int[] type, Color[] colors, Object[] obj) throws PdfException {
        if (page == this.pageNumber) {
            this.currentDisplay.drawAdditionalObjectsOverPage(type, colors, obj);
        }
        this.pages.refreshDisplay();
    }

    public void flushAdditionalObjectsOnPage(int page) throws PdfException {
        if (page == this.pageNumber) {
            this.currentDisplay.flushAdditionalObjOnPage();
        }
        this.pages.refreshDisplay();
    }

    public void useHiResScreenDisplay(boolean value) {
        this.useHiResImageForDisplay = value;
    }

    public final void decodePageInBackground(int i) throws Exception {
        if (this.isBackgroundDecoding) {
            LogWriter.writeLog((String)"[PDF]WARNING - this file is being decoded already in background");
        } else {
            this.isBackgroundDecoding = true;
            if (i > this.pageCount) {
                LogWriter.writeLog((String)"Page out of bounds");
            } else {
                String currentPageOffset = (String)this.pagesReferences.get(new Integer(i));
                if (currentPageOffset != null) {
                    if (this.currentPdfFile == null) {
                        throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                    }
                    PdfPageObject pdfObject = new PdfPageObject(currentPageOffset);
                    this.currentPdfFile.readObject((PdfObject)pdfObject, currentPageOffset, false, null);
                    PdfObject Resources = pdfObject.getDictionary(2004251818);
                    if (pdfObject != null) {
                        PdfStreamDecoder backgroundDecoder = new PdfStreamDecoder();
                        backgroundDecoder.setExternalImageRender(this.customImageHandler);
                        backgroundDecoder.setName(this.filename);
                        backgroundDecoder.setStore(this.backgroundObjectStoreRef);
                        backgroundDecoder.init(true, false, 0, extractionMode, this.pageData, i, null, this.currentPdfFile);
                        if (this.globalResources != null) {
                            backgroundDecoder.readResources(this.globalResources, true);
                        }
                        if (Resources != null) {
                            backgroundDecoder.readResources(Resources, true);
                        }
                        backgroundDecoder.decodePageContent((PdfObject)pdfObject, 0, 0, null, null);
                        this.pdfBackgroundData = backgroundDecoder.getText();
                        if (embedWidthData) {
                            this.pdfBackgroundData.widthIsEmbedded();
                        }
                        int mediaW = this.pageData.getMediaBoxWidth(i);
                        int mediaH = this.pageData.getMediaBoxHeight(i);
                        this.pdfBackgroundData.maxX = mediaW;
                        this.pdfBackgroundData.maxY = mediaH;
                        this.pdfBackgroundImages = backgroundDecoder.getImages();
                    }
                }
            }
            this.isBackgroundDecoding = false;
        }
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    public final boolean isEncrypted() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isEncrypted();
        }
        return false;
    }

    public final boolean isPasswordSupplied() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isPasswordSupplied();
        }
        return false;
    }

    public boolean isFileViewable() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isFileViewable();
        }
        return false;
    }

    public boolean isExtractionAllowed() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isExtractionAllowed();
        }
        return false;
    }

    public int getPDFflag(Integer i) {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.getPDFflag(i);
        }
        return -1;
    }

    private void verifyAccess() {
        if (this.currentPdfFile != null) {
            try {
                this.openPdfFile();
            }
            catch (Exception e) {
                LogWriter.writeLog((String)("Exception " + e + " opening file"));
            }
        }
    }

    public final void setDefaultDisplayFont(String fontName) throws PdfFontException {
        boolean isFontInstalled = false;
        String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int count = fontList.length;
        int i = 0;
        while (i < count) {
            if (fontList[i].toLowerCase().equals(fontName.toLowerCase())) {
                isFontInstalled = true;
                defaultFont = fontList[i];
                i = count;
            }
            ++i;
        }
        if (!isFontInstalled) {
            throw new PdfFontException("Font " + fontName + " is not available.");
        }
    }

    public final void setEncryptionPassword(String password) throws PdfException {
        if (this.currentPdfFile == null) {
            throw new PdfException("Must open PdfDecoder file first");
        }
        this.currentPdfFile.setEncryptionPassword(password);
        this.verifyAccess();
    }

    public final void openPdfArray(byte[] data) throws PdfException {
        LogWriter.writeMethod((String)"{openPdfArray}", (int)0);
        this.globalResources = null;
        this.pagesReferences.clear();
        try {
            this.currentPdfFile = new PdfReader();
            this.currentPdfFile.openPdfFile(data);
            this.openPdfFile();
            if (this.stopDecoding) {
                this.closePdfFile();
            }
            this.objectStoreRef.storeFileName("r" + System.currentTimeMillis());
        }
        catch (Exception e) {
            throw new PdfException("[PDF] OpenPdfArray generated exception " + e.getMessage());
        }
    }

    public final void openPdfFile(String filename) throws PdfException {
        this.displayScaling = null;
        LogWriter.writeMethod((String)("{openPdfFile " + filename + '}'), (int)0);
        this.filename = filename;
        this.globalResources = null;
        this.pagesReferences.clear();
        this.objectStoreRef.storeFileName(filename);
        this.currentPdfFile = new PdfReader();
        if (!this.stopDecoding) {
            this.currentPdfFile.openPdfFile(filename);
        }
        if (!this.stopDecoding) {
            this.openPdfFile();
        }
        if (this.stopDecoding) {
            this.closePdfFile();
        }
    }

    public final void openPdfFile(String filename, String password) throws PdfException {
        this.displayScaling = null;
        LogWriter.writeMethod((String)("{openPdfFile " + filename + '}'), (int)0);
        this.filename = filename;
        this.globalResources = null;
        this.pagesReferences.clear();
        this.objectStoreRef.storeFileName(filename);
        this.currentPdfFile = new PdfReader(password);
        if (!this.stopDecoding) {
            this.currentPdfFile.openPdfFile(filename);
        }
        if (!this.stopDecoding) {
            this.openPdfFile();
        }
        if (this.stopDecoding) {
            this.closePdfFile();
        }
    }

    public void setDownloadWindomPosition(int x, int y) {
        this.coords = new Point(x, y);
    }

    public final void openPdfFileFromURL(String pdfUrl) throws PdfException {
        LogWriter.writeMethod((String)("{openPdfFileFromURL " + pdfUrl + '}'), (int)0);
        this.displayScaling = null;
        this.globalResources = null;
        this.pagesReferences.clear();
        if (this.download == null) {
            this.download = new JFrame();
            this.p = new JPanel(new GridBagLayout());
            this.pb = new JProgressBar();
            this.downloadMessage = new JLabel();
            this.downloadFile = new JLabel();
            this.turnOff = new JLabel();
        }
        try {
            int read;
            URL url = new URL(pdfUrl);
            InputStream is = url.openStream();
            String filename = url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
            this.tempURLFile = File.createTempFile(filename.substring(0, filename.lastIndexOf(46)), filename.substring(filename.lastIndexOf(46)));
            FileOutputStream fos = new FileOutputStream(this.tempURLFile);
            if (this.useDownloadWindow && !this.downloadCreated) {
                this.createDownloadWindow();
            }
            this.download.setLocation(this.coords.x - this.download.getWidth() / 2, this.coords.y - this.download.getHeight() / 2);
            this.download.setVisible(true);
            int fileLength = url.openConnection().getContentLength();
            this.pb.setMinimum(0);
            this.pb.setMaximum(fileLength);
            String message = Messages.getMessage((String)"PageLayoutViewMenu.DownloadWindowMessage");
            message = message.replaceAll("FILENAME", filename);
            this.downloadFile.setText(message);
            Font f = this.turnOff.getFont();
            this.turnOff.setFont(new Font(f.getName(), f.getStyle(), 8));
            this.turnOff.setAlignmentY(1.0f);
            this.turnOff.setText(Messages.getMessage((String)"PageLayoutViewMenu.DownloadWindowTurnOff"));
            byte[] buffer = new byte[4096];
            int current = 0;
            String rate = "kb";
            int mod = 1000;
            if (fileLength > 1000000) {
                rate = "mb";
                mod = 1000000;
            }
            String progress = Messages.getMessage((String)"PageLayoutViewMenu.DownloadWindowProgress");
            progress = fileLength < 1000000 ? progress.replaceAll("DVALUE", String.valueOf(fileLength / mod) + " " + rate) : progress.replaceAll("DVALUE", String.valueOf(fileLength / mod) + "." + fileLength % mod / 10000 + " " + rate);
            while ((read = is.read(buffer)) != -1) {
                current += read;
                this.downloadCount += read;
                if (fileLength < 1000000) {
                    this.downloadMessage.setText(progress.replaceAll("DSOME", String.valueOf(current / mod) + rate));
                } else {
                    this.downloadMessage.setText(progress.replaceAll("DSOME", String.valueOf(current / mod) + "." + current % mod / 10000 + " " + rate));
                }
                this.pb.setValue(current);
                this.download.repaint();
                fos.write(buffer, 0, read);
            }
            fos.flush();
            is.close();
            fos.close();
            this.downloadMessage.setText("Download of " + filename + " is complete.");
        }
        catch (IOException e) {
            LogWriter.writeLog((String)("[PDF] Exception " + e + " opening URL " + pdfUrl));
            e.printStackTrace();
        }
        this.download.setVisible(false);
        this.currentPdfFile = new PdfReader();
        this.openPdfFile(this.tempURLFile.getAbsolutePath());
        this.objectStoreRef.storeFileName(this.tempURLFile.getName().substring(0, this.tempURLFile.getName().lastIndexOf(46)));
        if (this.stopDecoding) {
            this.closePdfFile();
        }
    }

    private void createDownloadWindow() {
        if (this.download == null) {
            this.download = new JFrame();
            this.p = new JPanel(new GridBagLayout());
            this.pb = new JProgressBar();
            this.downloadMessage = new JLabel();
            this.downloadFile = new JLabel();
            this.turnOff = new JLabel();
        }
        this.download.setResizable(false);
        this.download.setTitle(Messages.getMessage((String)"PageLayoutViewMenu.DownloadWindowTitle"));
        BoxLayout bl = new BoxLayout(this.p, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        this.downloadFile.setSize(250, this.downloadFile.getHeight());
        this.downloadFile.setMinimumSize(new Dimension(250, 15));
        this.downloadFile.setMaximumSize(new Dimension(250, 15));
        this.downloadFile.setPreferredSize(new Dimension(250, 15));
        this.p.add((Component)this.downloadFile, gbc);
        gbc.gridy = 1;
        this.downloadMessage.setSize(250, this.downloadFile.getHeight());
        this.downloadMessage.setMinimumSize(new Dimension(250, 15));
        this.downloadMessage.setMaximumSize(new Dimension(250, 15));
        this.downloadMessage.setPreferredSize(new Dimension(250, 15));
        this.p.add((Component)this.downloadMessage, gbc);
        gbc.gridy = 2;
        this.pb.setSize(260, this.downloadFile.getHeight());
        this.pb.setMinimumSize(new Dimension(260, 20));
        this.pb.setMaximumSize(new Dimension(260, 20));
        this.pb.setPreferredSize(new Dimension(260, 20));
        this.p.add((Component)this.pb, gbc);
        gbc.gridy = 3;
        this.p.add((Component)this.turnOff, gbc);
        this.download.getContentPane().add(this.p);
        this.download.setSize(320, 100);
        this.downloadCreated = true;
    }

    private void openPdfFile() throws PdfException {
        this.isOpen = false;
        LogWriter.writeMethod((String)"{openPdfFile}", (int)0);
        boolean decodingStaus = this.stopDecoding;
        this.stopDecoding();
        this.stopDecoding = decodingStaus;
        this.pageNumber = 1;
        this.lastFormPage = -1;
        this.lastEnd = -1;
        this.lastStart = -1;
        this.annotPage = -1;
        if (this.filename != null && this.filename.toLowerCase().endsWith(".fdf")) {
            Map data;
            byte[] pdfFile;
            int i = this.filename.lastIndexOf(47);
            if (i == -1) {
                i = this.filename.lastIndexOf(92);
            }
            String path = "";
            if (i != -1) {
                path = this.filename.substring(0, i + 1);
            }
            if ((pdfFile = this.currentPdfFile.getByteTextStringValue((data = this.currentPdfFile.readFDF()).get("F"), this.fdfData)) != null) {
                this.filename = String.valueOf(path) + this.currentPdfFile.getTextString(pdfFile);
            }
            this.objectStoreRef.storeFileName(this.filename);
            this.currentPdfFile.openPdfFile(this.filename);
            this.fdfData = (Map)data.get("Fields");
        } else {
            this.fdfData = null;
        }
        try {
            this.isDecoding = true;
            this.pages.resetCachedValues();
            if (this.hasViewListener) {
                this.pages.flushPageCaches();
                this.removeComponentListener(this.viewListener);
            }
            if (!this.stopDecoding) {
                this.currentPdfFile.setCacheSize(this.minimumCacheSize);
                this.lastPrintedPage = -1;
                this.currentPrintDecoder = null;
                if (this.javascript != null) {
                    this.javascript.reset();
                }
                if (this.formsAvailable && this.formRenderer != null) {
                    this.formRenderer.getCompData().setRootDisplayComponent((Object)this);
                    this.formRenderer.removeDisplayComponentsFromScreen();
                }
            }
            if (!this.stopDecoding) {
                this.pageData = new PdfPageData();
                this.pdfVersion = this.currentPdfFile.getType();
                LogWriter.writeLog((String)("Pdf version : " + this.pdfVersion));
                if (this.pdfVersion == null) {
                    this.currentPdfFile = null;
                    this.isDecoding = false;
                    throw new PdfException("No version on first line ");
                }
                if (this.pdfVersion.indexOf("1.5") != -1) {
                    LogWriter.writeLog((String)"Please note Pdf version 1.5  some features not fully supported ");
                } else if (this.pdfVersion.indexOf("1.6") != -1) {
                    LogWriter.writeLog((String)"Please note Pdf version 1.6  new features not fully supported ");
                }
                LogWriter.writeMethod((String)"{about to read ref table}", (int)0);
            }
            String root_id = this.currentPdfFile.readReferenceTable();
            Map values = null;
            PdfPageObject pdfObject = null;
            boolean ignoreRecursion = true;
            LogWriter.writeMethod((String)"{about to read catalog}", (int)0);
            if (root_id != null) {
                values = this.currentPdfFile.readObject(new PdfObject(root_id), root_id, false, null);
                pdfObject = new PdfPageObject(root_id);
                pdfObject.ignoreRecursion(true);
                this.currentPdfFile.readObject((PdfObject)pdfObject, root_id, false, null);
            }
            if (!this.isEncrypted() || this.isPasswordSupplied()) {
                String value;
                int type = pdfObject.getParameterConstant(608780341);
                if (type != 540096309 && (value = (String)values.get("Pages")) != null) {
                    pdfObject = new PdfPageObject(value);
                    pdfObject.ignoreRecursion(false);
                    this.currentPdfFile.readObject((PdfObject)pdfObject, value, false, null);
                }
                if (pdfObject != null) {
                    LogWriter.writeLog((String)"Pages being read ");
                    this.pageNumber = 1;
                    this.pageLookup = new PageLookup();
                    if (this.formRenderer != null) {
                        this.formRenderer.resetAnnotData(null, this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.formKids);
                    }
                    this.readAllPageReferences(true, (PdfObject)pdfObject, new HashMap(), new HashMap());
                    this.pageCount = this.pageNumber - 1;
                    this.pageNumber = 0;
                    if (this.pageCount == 0) {
                        LogWriter.writeLog((String)"No pages found");
                    }
                }
                this.XMLObject = (String)values.get("Metadata");
                this.setJavascript();
                Object names = null;
                try {
                    names = values.get("Names");
                    if (names != null) {
                        this.currentPdfFile.readNames(names, this.javascript);
                    }
                }
                catch (Exception e) {
                    LogWriter.writeLog((String)("Exception reading Names " + names + ' ' + this.objectStoreRef.fullFileName));
                }
                this.isXFA = false;
                this.outlineObject = values.get("Outlines");
                this.outlineData = null;
                this.hasOutline = this.outlineObject != null;
                Object rawValue = values.get("AcroForm");
                if (rawValue != null) {
                    this.readAcroForm(rawValue);
                    this.isForm = true;
                } else {
                    this.currentAcroFormData = null;
                    this.isForm = false;
                }
                Object obj = values.get("StructTreeRoot");
                Map markInfo = null;
                Map structTreeRoot = null;
                if (obj != null) {
                    structTreeRoot = obj instanceof String ? this.currentPdfFile.readObject(new PdfObject((String)obj), (String)obj, false, null) : (Map)obj;
                }
                if ((obj = values.get("MarkInfo")) != null) {
                    markInfo = obj instanceof String ? this.currentPdfFile.readObject(new PdfObject((String)obj), (String)obj, false, null) : (Map)obj;
                }
                this.content.setRootValues(structTreeRoot, markInfo);
                if (this.formsAvailable && this.formRenderer != null) {
                    this.formRenderer.openFile(this.pageCount);
                    this.formRenderer.resetFormData((Object)this.currentAcroFormData, this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.formKids);
                }
            }
            this.currentOffset = null;
            this.pages.disableScreen();
            if (!this.stopDecoding) {
                this.pages.stopGeneratingPage();
            }
            this.displayView = this.pageCount < 2 ? 1 : this.pageMode;
            this.setDisplayView(this.displayView, this.alignment);
            this.isOpen = true;
        }
        catch (PdfException e) {
            this.isDecoding = false;
            throw new PdfException(String.valueOf(e.getMessage()) + " opening file");
        }
        this.isDecoding = false;
    }

    public void setPageMode(int mode) {
        this.pageMode = mode;
    }

    public Javascript getJavascript() {
        return this.javascript;
    }

    private void setJavascript() {
        if (this.javascript == null && this.useJavascript) {
            this.javascript = new Javascript();
        }
        if (this.javascript != null) {
            this.javascript.setUserExpressionEngine((ExpressionEngine)this.userExpressionEngine);
        }
        this.formRenderer.setJavaScriptObject(this.javascript, this.userExpressionEngine);
        this.javascript.setRenderer(this.formRenderer);
        if (this.currentPdfFile != null) {
            this.currentPdfFile.setJavaScriptObject(this.javascript);
        }
    }

    private void readAllPageReferences(boolean ignoreRecursion, PdfObject pdfObject, Map rotations, Map parents) {
        LogWriter.writeMethod((String)"{readAllPageReferences}", (int)0);
        boolean debug = false;
        int rotation = 0;
        String currentPageOffset = pdfObject.getObjectRefAsString();
        int type = pdfObject.getParameterConstant(608780341);
        if (type == -1) {
            type = 825701731;
        }
        int rawRotation = pdfObject.getInt(1144088180);
        String parent = pdfObject.getStringKey(1110793845);
        if (rawRotation == -1) {
            while (parent != null && rawRotation == -1) {
                Object savedRotation;
                if (parent != null && (savedRotation = rotations.get(parent)) != null) {
                    rawRotation = (Integer)savedRotation;
                }
                if (rawRotation != -1) continue;
                parent = (String)parents.get(parent);
            }
            if (rawRotation != -1) {
                rotations.put(currentPageOffset, new Integer(rawRotation));
                parents.put(currentPageOffset, parent);
            }
        } else {
            rotations.put(currentPageOffset, new Integer(rawRotation));
            parents.put(currentPageOffset, parent);
        }
        if (rawRotation != -1) {
            rotation = rawRotation;
        }
        this.pageData.setPageRotation(rotation, this.pageNumber);
        float[] mediaBox = pdfObject.getFloatArray(1313305473);
        float[] cropBox = pdfObject.getFloatArray(1076199815);
        if (mediaBox != null) {
            this.pageData.setMediaBox(mediaBox);
        }
        if (cropBox != null) {
            this.pageData.setCropBox(cropBox);
        }
        if (this.stopDecoding) {
            return;
        }
        if (type == 825701731) {
            this.globalResources = pdfObject.getDictionary(2004251818);
            byte[][] kidList = pdfObject.getKeyArray(456733763);
            int kidCount = 0;
            if (kidList != null) {
                kidCount = kidList.length;
            }
            if (kidCount > 0) {
                int ii = 0;
                while (ii < kidCount) {
                    String nextValue = new String(kidList[ii]);
                    PdfPageObject nextObject = new PdfPageObject(nextValue);
                    nextObject.ignoreRecursion(ignoreRecursion);
                    this.currentPdfFile.readObject((PdfObject)nextObject, nextValue, false, null);
                    this.readAllPageReferences(ignoreRecursion, (PdfObject)nextObject, rotations, parents);
                    ++ii;
                }
            }
        } else if (type == 540096309) {
            byte[][] annotList;
            this.pagesReferences.put(new Integer(this.pageNumber), currentPageOffset);
            this.pageLookup.put(currentPageOffset, this.pageNumber);
            this.pageData.checkSizeSet(this.pageNumber);
            if (this.formRenderer != null && this.pageNumber < 101 && (annotList = pdfObject.getKeyArray(1044338049)) != null) {
                PdfAnnots annotsData = null;
                try {
                    if (annotList != null) {
                        annotsData = new PdfAnnots(this.currentPdfFile, "" + this.pageNumber);
                        annotsData.readAnnots(annotList);
                    }
                }
                catch (Exception e) {
                    LogWriter.writeLog((String)("[PDF] " + e + " with annotation"));
                }
                if (this.formsAvailable && this.showAnnotations && annotsData != null) {
                    this.formRenderer.resetAnnotData((Object)annotsData, this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.formKids);
                }
            }
            ++this.pageNumber;
        }
    }

    private static ArrayList getDirectoryMatches(String sDirectoryName) throws IOException {
        sDirectoryName = sDirectoryName.replaceAll("\\.", "/");
        URL u = Thread.currentThread().getContextClassLoader().getResource(sDirectoryName);
        ArrayList<String> retValue = new ArrayList<String>(0);
        String s = u.toString();
        System.out.println("scanning " + s);
        if (s.startsWith("jar:") && s.endsWith(sDirectoryName)) {
            int idx = s.lastIndexOf(sDirectoryName);
            s = s.substring(0, idx);
            System.out.println("entry= " + s);
            URL url = new URL(s);
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            JarFile jar = conn.getJarFile();
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (!(!entry.isDirectory() & entry.getName().startsWith(sDirectoryName))) continue;
                String fontName = entry.getName();
                int i = fontName.lastIndexOf(47);
                fontName = fontName.substring(i + 1);
                retValue.add(fontName);
            }
        } else {
            LogWriter.writeLog((String)("Path: " + s));
        }
        return retValue;
    }

    private static ArrayList readIndirectValues(InputStream in) throws IOException {
        String nextValue;
        BufferedReader inpStream = new BufferedReader(new InputStreamReader(in));
        ArrayList<String> fonts = new ArrayList<String>(0);
        while ((nextValue = inpStream.readLine()) != null) {
            fonts.add(nextValue);
        }
        inpStream.close();
        return fonts;
    }

    public boolean addSubstituteFonts(String fontPath, boolean enforceMapping) {
        boolean hasFonts;
        block11: {
            hasFonts = false;
            try {
                String[] dirs = new String[]{"tt", "t1c", "t1"};
                String[] types = new String[]{"/TrueType", "/Type1C", "/Type1"};
                enforceFontSubstitution = enforceMapping;
                ClassLoader loader = this.getClass().getClassLoader();
                InputStream in = loader.getResourceAsStream(fontPath);
                LogWriter.writeLog((String)("Looking for root " + fontPath));
                if (in != null) {
                    LogWriter.writeLog((String)("Adding fonts fonts found in  tt,t1c,t1 sub-directories of " + fontPath));
                    hasFonts = true;
                    int i = 0;
                    while (i < dirs.length) {
                        String path;
                        if (!fontPath.endsWith("/")) {
                            fontPath = String.valueOf(fontPath) + '/';
                        }
                        if ((in = loader.getResourceAsStream(path = String.valueOf(fontPath) + dirs[i] + '/')) != null) {
                            System.out.println("Found  " + path + ' ' + in);
                            try {
                                ArrayList fonts = in instanceof ByteArrayInputStream ? PdfDecoder.readIndirectValues(in) : PdfDecoder.getDirectoryMatches(path);
                                int count = fonts.size();
                                int ii = 0;
                                while (ii < count) {
                                    String value = (String)fonts.get(ii);
                                    if (value != null) {
                                        int pointer = value.indexOf(46);
                                        String fontName = pointer == -1 ? value : value.substring(0, pointer);
                                        FontMappings.fontSubstitutionTable.put(fontName.toLowerCase(), types[i]);
                                        FontMappings.fontSubstitutionLocation.put(fontName.toLowerCase(), String.valueOf(path) + value);
                                        ++ii;
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Exception e) {
                                LogWriter.writeLog((String)("Exception " + e + " reading substitute fonts"));
                                System.out.println("Exception " + e + " reading substitute fonts");
                            }
                        }
                        ++i;
                    }
                    break block11;
                }
                LogWriter.writeLog((String)("No fonts found at " + fontPath));
            }
            catch (Exception e) {
                LogWriter.writeLog((String)("Exception adding substitute fonts " + e.getMessage()));
            }
        }
        return hasFonts;
    }

    public Map getUserIconsForAnnotations() {
        return this.userAnnotIcons;
    }

    public void addUserIconsForAnnotations(int page, String type, Image[] icons) {
        if (this.userAnnotIcons == null) {
            this.userAnnotIcons = new Hashtable();
        }
        this.userAnnotIcons.put(String.valueOf(page) + "-" + type, icons);
        if (this.displayHotspots == null) {
            this.displayHotspots = new Hotspots();
            this.printHotspots = new Hotspots();
        }
        this.displayHotspots.checkType(type);
        this.printHotspots.checkType(type);
    }

    public void createPageHostspots(String[] annotationTypes, String string) {
        this.displayHotspots = new Hotspots(annotationTypes, string);
        this.printHotspots = new Hotspots(annotationTypes, string);
    }

    public void setThumbnailsDrawing(boolean b) {
        this.thumbnailsBeingDrawn = b;
        this.pages.setThumbnailsDrawing(b);
    }

    public void showImageableArea() {
        this.showImageable = true;
    }

    public int getNumberOfPages() {
        if (this.range != null) {
            int rangeCount = 0;
            int ii = 1;
            while (ii < this.pageCount + 1) {
                if (!(!this.range.contains(ii) || this.oddPagesOnly && (ii & 1) != 1 || this.evenPagesOnly && (ii & 1) != 0)) {
                    ++rangeCount;
                }
                ++ii;
            }
            return rangeCount;
        }
        int count = 1;
        if (this.end != -1 && (count = this.end - this.start + 1) < 0) {
            count = 2 - count;
        }
        if (this.oddPagesOnly || this.evenPagesOnly) {
            return (count + 1) / 2;
        }
        return count;
    }

    public PageFormat getPageFormat(int p) throws IndexOutOfBoundsException {
        int actualPage = this.end == -1 ? p + 1 : (this.end > this.start ? this.start + p : this.start - p);
        Object returnValue = this.pageFormats.get(new Integer(actualPage));
        if (debugPrint) {
            System.out.println("======================================================\nspecific for page=" + returnValue + " Get page format for page p=" + p + " start=" + this.start + " pf=" + this.pageFormats + ' ' + this.pageFormats.keySet());
        }
        if (returnValue == null) {
            returnValue = this.pageFormats.get("standard");
        }
        PageFormat pf = new PageFormat();
        if (returnValue != null) {
            pf = (PageFormat)returnValue;
        }
        if (this.usePDFPaperSize) {
            int crw = this.pageData.getCropBoxWidth(actualPage);
            int crh = this.pageData.getCropBoxHeight(actualPage);
            this.createCustomPaper(pf, crw, crh);
        }
        if (!this.isPrintAutoRotateAndCenter) {
            pf.setOrientation(1);
        }
        if (debugPrint) {
            System.out.println("Page format used=" + pf);
            System.out.println("Orientation=" + pf.getOrientation());
            System.out.println("Width=" + pf.getWidth() + " imageableW=" + pf.getImageableWidth());
            System.out.println("Height=" + pf.getHeight() + " imageableH=" + pf.getImageableHeight());
        }
        return pf;
    }

    public Printable getPrintable(int page) throws IndexOutOfBoundsException {
        return this;
    }

    public void setPageFormat(int p, PageFormat pf) {
        if (debugPrint) {
            System.out.println("Set page format for page " + p);
        }
        this.pageFormats.put(new Integer(p), pf);
    }

    public void setPageFormat(PageFormat pf) {
        if (debugPrint) {
            System.out.println("Set page format Standard for page");
            System.out.println("---------------------------------");
            System.out.println("Page format used=" + pf);
            System.out.println("Orientation=" + pf.getOrientation());
            System.out.println("Width=" + pf.getWidth() + " imageableW=" + pf.getImageableWidth());
            System.out.println("Height=" + pf.getHeight() + " imageableH=" + pf.getImageableHeight());
            System.out.println("---------------------------------");
        }
        this.pageFormats.put("standard", pf);
    }

    public static boolean isXMLExtraction() {
        return isXMLExtraction;
    }

    public static void useTextExtraction() {
        isXMLExtraction = false;
    }

    public static void useXMLExtraction() {
        isXMLExtraction = true;
    }

    public void clearScreen() {
        this.currentDisplay.flush();
        this.pages.refreshDisplay();
    }

    public void setStreamCacheSize(int size) {
        this.minimumCacheSize = size;
    }

    public void addImage(BufferedImage img) {
        this.currentDisplay.drawImage(img);
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public Map resolveFormReference(String ref) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("T", "x");
        fields.put("TM", "x");
        fields.put("TU", "x");
        fields.put("CA", "x");
        fields.put("R", "x");
        fields.put("V", "x");
        fields.put("RC", "x");
        fields.put("DA", "x");
        fields.put("DV", "x");
        return this.currentPdfFile.readObject(new PdfObject(ref), ref, false, fields);
    }

    public final boolean PDFContainsEmbeddedFonts() throws Exception {
        boolean hasEmbeddedFonts = false;
        int page = 1;
        while (page < this.pageCount + 1) {
            String currentPageOffset = (String)this.pagesReferences.get(new Integer(page));
            if (currentPageOffset != null) {
                PdfPageObject pdfObject = new PdfPageObject(currentPageOffset);
                Map values = this.currentPdfFile.readObject((PdfObject)pdfObject, currentPageOffset, false, null);
                PdfObject Resources = pdfObject.getDictionary(2004251818);
                String value = (String)values.get("Contents");
                if (value != null) {
                    PdfStreamDecoder current = new PdfStreamDecoder();
                    current.setExternalImageRender(this.customImageHandler);
                    current.init(true, this.renderPage, renderMode, extractionMode, this.pageData, page, this.currentDisplay, this.currentPdfFile);
                    if (this.globalResources != null) {
                        current.readResources(this.globalResources, true);
                    }
                    if (Resources != null) {
                        current.readResources(Resources, true);
                    }
                    if (hasEmbeddedFonts = current.hasEmbeddedFonts()) {
                        page = this.pageCount;
                    }
                }
            }
            ++page;
        }
        return hasEmbeddedFonts;
    }

    public String getFontsInFile() {
        if (this.fontsInFile == null) {
            return "No fonts defined";
        }
        return this.fontsInFile;
    }

    public void includeImagesInStream() {
        this.includeImages = true;
    }

    public PageLines getPageLines() {
        return this.pageLines;
    }

    public void setEnableLegacyJPEGConversion(boolean newjPEGConversion) {
        use13jPEGConversion = newjPEGConversion;
    }

    public AcroRenderer getFormRenderer() {
        if (!this.formsAvailable) {
            return null;
        }
        return this.formRenderer;
    }

    public boolean isPageSuccessful() {
        return this.operationSuccessful;
    }

    public String getPageDecodeReport() {
        return this.decodeStatus;
    }

    public String getPageFailureMessage() {
        return this.pageErrorMessages;
    }

    public BufferedImage getSelectedRectangleOnscreen(float t_x1, float t_y1, float t_x2, float t_y2, float scaling) {
        int mediaBoxH = this.pageData.getMediaBoxHeight(this.pageNumber);
        int crw = this.pageData.getCropBoxWidth(this.pageNumber);
        int crh = this.pageData.getCropBoxHeight(this.pageNumber);
        int crx = this.pageData.getCropBoxX(this.pageNumber);
        int cry = this.pageData.getCropBoxY(this.pageNumber);
        if (t_y2 < (float)cry) {
            t_y2 = cry;
        }
        if (t_x1 < (float)crx) {
            t_x1 = crx;
        }
        if (t_y1 > (float)(crh + cry)) {
            t_y1 = crh + cry;
        }
        if (t_x2 > (float)(crx + crw)) {
            t_x2 = crx + crw;
        }
        if (t_x2 - t_x1 < 1.0f || t_y1 - t_y2 < 1.0f) {
            return null;
        }
        float scalingFactor = scaling / 100.0f;
        float imgWidth = t_x2 - t_x1;
        float imgHeight = t_y1 - t_y2;
        BufferedImage img = new BufferedImage((int)(imgWidth * scalingFactor), (int)(imgHeight * scalingFactor), 1);
        Graphics2D g2 = img.createGraphics();
        if (cry > 0) {
            cry = mediaBoxH - crh - cry;
        }
        AffineTransform scaleAf = this.getScalingForImage(this.pageNumber, 0, scalingFactor);
        int cx = -crx;
        int cy = -cry;
        scaleAf.translate(cx, -cy);
        scaleAf.translate(-(t_x1 - (float)crx), (float)mediaBoxH - t_y1 - (float)cry);
        AffineTransform af = g2.getTransform();
        g2.transform(scaleAf);
        if (this.currentDisplay.addBackground()) {
            g2.setColor(this.currentDisplay.getBackgroundColor());
            g2.fill(new Rectangle(crx, cry, crw, crh));
        }
        this.currentDisplay.setOptimsePainting(true);
        this.currentDisplay.paint(g2, null, null, null, false, false);
        if (this.formsAvailable && this.formRenderer != null) {
            this.formRenderer.getCompData().renderFormsOntoG2((Object)g2, this.pageNumber, scaling, 0, this.displayRotation);
            this.formRenderer.getCompData().resetScaledLocation(this.oldScaling, this.displayRotation, 0);
        }
        if (!this.showAnnotations && this.annotsData != null && this.displayHotspots != null) {
            this.displayHotspots.setHotspots(this.annotsData);
        }
        g2.setTransform(af);
        g2.dispose();
        return img;
    }

    public ObjectStore getObjectStore() {
        return this.objectStoreRef;
    }

    public void setObjectStore(ObjectStore newStore) {
        this.objectStoreRef = newStore;
    }

    public PdfGroupingAlgorithms getGroupingObject() throws PdfException {
        PdfData textData = this.getPdfData();
        if (textData == null) {
            return null;
        }
        return new PdfGroupingAlgorithms(textData);
    }

    public PdfGroupingAlgorithms getBackgroundGroupingObject() {
        PdfData textData = this.pdfBackgroundData;
        if (textData == null) {
            return null;
        }
        return new PdfGroupingAlgorithms(textData);
    }

    public final String getPDFVersion() {
        return this.pdfVersion;
    }

    public Map resolveToMapOrString(String string, Object rawAnnotDetails) {
        Map returnValue = null;
        if (rawAnnotDetails instanceof Map) {
            returnValue = (Map)((Map)rawAnnotDetails).get(string);
        }
        if (returnValue == null) {
            return (Map)this.currentPdfFile.resolveToMapOrString((Object)string, rawAnnotDetails);
        }
        return returnValue;
    }

    public void resetForNonPDFPage() {
        this.displayScaling = null;
        this.currentDisplay.setHiResImageForDisplayMode(false);
        this.fontsInFile = "";
        this.pageCount = 1;
        this.hasOutline = false;
        if (this.formsAvailable && this.formRenderer != null) {
            this.formRenderer.removeDisplayComponentsFromScreen();
        }
        this.pageData = new PdfPageData();
    }

    public static void setDebugPrint(boolean newDebugPrint) {
        debugPrint = newDebugPrint;
    }

    public void setDisplayView(int displayView, int orientation) {
        boolean needsReset;
        this.alignment = orientation;
        if (this.pages != null) {
            this.pages.stopGeneratingPage();
        }
        boolean bl = needsReset = displayView != 1 || this.displayView != 1;
        if (needsReset && (this.displayView == 3 || displayView == 3)) {
            needsReset = false;
        }
        if (displayView != 1) {
            needsReset = true;
        }
        boolean hasChanged = displayView != this.displayView;
        this.displayView = displayView;
        if (displayView == 1) {
            this.pages = new SingleDisplay(this.pageNumber, this.pageCount, this.currentDisplay);
        } else {
            this.currentHighlightedObject = null;
            if (needsReset) {
                this.setPageRotation(this.displayRotation);
                this.pages = new MultiDisplay(this.pageNumber, this.pageCount, null, displayView, this.customSwingHandle);
            } else {
                this.pages = new MultiDisplay(this.pageNumber, this.pageCount, this.currentDisplay, displayView, this.customSwingHandle);
            }
        }
        if (this.hasViewListener) {
            this.hasViewListener = false;
            this.removeComponentListener(this.viewListener);
        }
        if (this.currentOffset == null) {
            this.currentOffset = new PageOffsets(this.pageCount, this.pageData);
        }
        this.pages.setup(this.useAcceleration, this.currentOffset, this);
        this.pages.init(this.scaling, this.pageCount, this.displayRotation, this.pageNumber, this.currentDisplay, true, this.pageData, this.insetW, this.insetH);
        this.lastFormPage = -1;
        this.lastEnd = -1;
        this.lastStart = -1;
        this.pages.refreshDisplay();
        this.updateUI();
        if (!this.hasViewListener) {
            this.hasViewListener = true;
            this.addComponentListener(this.viewListener);
        }
        if (this.pageNumber > 0) {
            if (hasChanged && displayView == 1) {
                try {
                    this.unsetScaling();
                    this.setPageParameters(this.scaling, this.pageNumber, this.displayRotation);
                    this.invalidate();
                    this.updateUI();
                    this.decodePage(this.pageNumber);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (displayView != 1) {
                int yCord = this.getYCordForPage(this.pageNumber, -2.0f);
                Rectangle r = this.getVisibleRect();
                this.scrollRectToVisible(new Rectangle(0, yCord, (int)r.getWidth() - 1, (int)r.getHeight() - 1));
                this.scrollRectToVisible(new Rectangle(0, yCord, (int)r.getWidth() - 1, (int)r.getHeight() - 1));
            }
        }
    }

    public boolean isXFAForm() {
        return this.isXFA;
    }

    public boolean hasJavascript() {
        return this.javascript != null && this.javascript.hasJavascript();
    }

    public int getCurrentPrintPage() {
        return this.currentPrintPage;
    }

    public void resetCurrentPrintPage() {
        this.currentPrintPage = 0;
    }

    public boolean hasAllImages() {
        return this.imagesProcessedFully;
    }

    public boolean getPageDecodeStatus(int status) {
        if (status == 4) {
            return this.hasNonEmbeddedCIDFonts;
        }
        if (status == 2) {
            return this.imagesProcessedFully;
        }
        new RuntimeException("Unknown paramter");
        return false;
    }

    public String getPageDecodeStatusReport(int status) {
        if (status == 4) {
            return this.nonEmbeddedCIDFonts;
        }
        new RuntimeException("Unknown paramter");
        return "";
    }

    public void setPrintAutoRotateAndCenter(boolean value) {
        this.isPrintAutoRotateAndCenter = value;
    }

    public void setPrintCurrentView(boolean value) {
        this.printOnlyVisible = value;
    }

    public void addExternalHandler(Object newHandler, int type) {
        switch (type) {
            case 1: {
                this.customImageHandler = (ImageHandler)newHandler;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (!this.formsAvailable) break;
                this.formRenderer.setFormFactory((FormFactory)newHandler);
                break;
            }
            case 4: {
                this.customSwingHandle = newHandler;
                break;
            }
            case 6: {
                this.userExpressionEngine = newHandler;
                this.setJavascript();
                break;
            }
            case 7: {
                if (this.formRenderer == null) break;
                this.formRenderer.resetHandler(newHandler, this, 7);
                break;
            }
            case 5: {
                if (this.formRenderer == null) break;
                this.formRenderer.resetHandler(newHandler, this, 5);
                break;
            }
            case 8: {
                this.pages.setThumbnailPanel((GUIThumbnailPanel)newHandler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type");
            }
        }
    }

    public int getYCordForPage(int page, float scaling) {
        if (scaling == -2.0f || scaling != -1.0f && scaling != this.oldScaling) {
            this.oldScaling = scaling;
            this.pages.setPageOffsets(this.pageCount, page);
        }
        return this.pages.getYCordForPage(page);
    }

    public void unsetScaling() {
        this.displayScaling = null;
    }

    public Object getFormDataForField(String formName) {
        Object formData = null;
        if (this.formRenderer != null) {
            formData = this.formRenderer.getFormDataAsObject(formName);
        }
        return formData;
    }

    public Set getNamesForAllFields() throws PdfException {
        if (this.formRenderer == null) {
            System.out.println("================No DATA=====================");
            return new HashSet();
        }
        HashSet set = new HashSet();
        List forms = this.formRenderer.getComponentNameList();
        if (forms != null) {
            set.addAll(forms);
        }
        return set;
    }

    public Integer getFormComponentType(String name) {
        Integer type = FormFactory.UNKNOWN;
        if (this.formRenderer != null) {
            type = this.formRenderer.getCompData().getTypeValueByName(name);
        }
        return type;
    }

    public PdfObjectReader getIO() {
        return this.currentPdfFile;
    }

    public boolean isThumbnailsDrawing() {
        return this.thumbnailsBeingDrawn;
    }

    public void setPageCount(int numPages) {
        this.pageCount = numPages;
    }

    public boolean isPDF() {
        return this.isPDf;
    }

    public void setPDF(boolean isPDf) {
        this.isPDf = isPDf;
    }

    public boolean isMultiPageTiff() {
        return this.isMultiPageTiff;
    }

    public void setMultiPageTiff(boolean isMultiPageTiff) {
        this.isMultiPageTiff = isMultiPageTiff;
    }

    public String getFileName() {
        return this.filename;
    }

    public boolean isUseDownloadWindow() {
        return this.useDownloadWindow;
    }

    public void setUseDownloadWindow(boolean useDownloadWindow) {
        this.useDownloadWindow = useDownloadWindow;
    }

    private class ProgressListener
    implements ActionListener {
        private ProgressListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            PdfDecoder.this.statusBar.setProgress((int)((PdfDecoder)PdfDecoder.this).statusBar.percentageDone);
        }
    }

    private class RefreshLayout
    extends ComponentAdapter {
        Timer t = null;
        java.util.Timer t2 = null;

        private RefreshLayout() {
        }

        public void componentMoved(ComponentEvent e) {
            this.startTimer();
        }

        public void componentResized(ComponentEvent e) {
            this.startTimer();
        }

        private void startTimer() {
            if (this.t2 != null) {
                this.t2.cancel();
            }
            PageListener listener = new PageListener();
            this.t2 = new java.util.Timer();
            this.t2.schedule((TimerTask)listener, 500L);
        }

        class PageListener
        extends TimerTask {
            PageListener() {
            }

            public void run() {
                ((RefreshLayout)RefreshLayout.this).PdfDecoder.this.pages.decodeOtherPages(((RefreshLayout)RefreshLayout.this).PdfDecoder.this.pageNumber, ((RefreshLayout)RefreshLayout.this).PdfDecoder.this.pageCount);
            }
        }
    }
}

