/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.fileformat.reader;

import com.sun.media.imageioimpl.plugins.jpeg2000.BitsPerComponentBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ColorSpecificationBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ComponentMappingBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.DataEntryURLBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.FileTypeBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.HeaderBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.PaletteBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ResolutionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.SignatureBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.UUIDBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.UUIDListBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.XMLBox;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.fileformat.FileFormatBoxes;
import jj2000.j2k.io.RandomAccessIO;

public class FileFormatReader
implements FileFormatBoxes {
    private RandomAccessIO in;
    private Vector codeStreamPos;
    private Vector codeStreamLength;
    private ColorModel colorModel = null;
    private J2KMetadata metadata;
    private int width;
    private int height;
    private int numComp;
    private int bitDepth;
    private int compressionType;
    private int unknownColor;
    private int intelProp;
    private byte[] bitDepths;
    private byte[][] lut;
    private byte[] compSize;
    private short[] comps;
    private byte[] type;
    private byte[] maps;
    private short[] channels;
    private short[] cType;
    private short[] associations;
    private int colorSpaceType;
    private ICC_Profile profile;

    public FileFormatReader(RandomAccessIO randomAccessIO, J2KMetadata j2KMetadata) {
        this.in = randomAccessIO;
        this.metadata = j2KMetadata;
    }

    public void readFileFormat() throws IOException, EOFException {
        boolean bl = false;
        long l = 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            int n = this.in.getPos();
            if (this.in.readInt() != 12 || this.in.readInt() != 1783636000 || this.in.readInt() != 218793738) {
                this.in.seek(n);
                short s = this.in.readShort();
                if (s != -177) {
                    throw new Error("File is neither valid JP2 file nor valid JPEG 2000 codestream");
                }
                this.in.seek(n);
                if (this.codeStreamPos == null) {
                    this.codeStreamPos = new Vector();
                }
                this.codeStreamPos.addElement(new Integer(n));
                return;
            }
            if (this.metadata != null) {
                this.metadata.addNode(new SignatureBox());
            }
            while (!bl3) {
                int n2;
                n = this.in.getPos();
                if (n + (n2 = this.in.readInt()) == this.in.length()) {
                    bl3 = true;
                }
                int n3 = this.in.readInt();
                if (n2 == 0) {
                    bl3 = true;
                    n2 = this.in.length() - this.in.getPos();
                } else {
                    if (n2 == 1) {
                        l = this.in.readLong();
                        throw new IOException("File too long.");
                    }
                    l = 0L;
                }
                n = this.in.getPos();
                n2 -= 8;
                switch (n3) {
                    case 1718909296: {
                        this.readFileTypeBox(n2 + 8, l);
                        break;
                    }
                    case 1785737827: {
                        if (!bl2) {
                            throw new Error("Invalid JP2 file: JP2Header box not found before Contiguous codestream box ");
                        }
                        this.readContiguousCodeStreamBox(n2 + 8, l);
                        break;
                    }
                    case 1785737832: {
                        if (bl2) {
                            throw new Error("Invalid JP2 file: Multiple JP2Header boxes found");
                        }
                        this.readJP2HeaderBox(n2 + 8);
                        bl2 = true;
                        n2 = 0;
                        break;
                    }
                    case 1768449138: {
                        this.readImageHeaderBox(n2);
                        break;
                    }
                    case 1685074537: {
                        this.readIntPropertyBox(n2);
                        break;
                    }
                    case 2020437024: {
                        this.readXMLBox(n2);
                        break;
                    }
                    case 1969843814: {
                        n2 = 0;
                        break;
                    }
                    case 1970628964: {
                        this.readUUIDBox(n2);
                        break;
                    }
                    case 1969451892: {
                        this.readUUIDListBox(n2);
                        break;
                    }
                    case 1970433056: {
                        this.readURLBox(n2);
                        break;
                    }
                    case 1885564018: {
                        this.readPaletteBox(n2 + 8);
                        break;
                    }
                    case 1651532643: {
                        this.readBitsPerComponentBox(n2);
                        break;
                    }
                    case 1668112752: {
                        this.readComponentMappingBox(n2);
                        break;
                    }
                    case 1668246642: {
                        this.readColourSpecificationBox(n2);
                        break;
                    }
                    case 1667523942: {
                        this.readChannelDefinitionBox(n2);
                        break;
                    }
                    case 1919251232: {
                        n2 = 0;
                        break;
                    }
                    case 1919251299: 
                    case 1919251300: {
                        this.readResolutionBox(n3, n2);
                        break;
                    }
                    default: {
                        if (this.metadata == null) break;
                        byte[] byArray = new byte[n2];
                        this.in.readFully(byArray, 0, n2);
                        this.metadata.addNode(new Box(n2 + 8, n3, l, byArray));
                    }
                }
                if (bl3) continue;
                this.in.seek(n + n2);
            }
        }
        catch (EOFException eOFException) {
            throw new Error("EOF reached before finding Contiguous Codestream Box");
        }
        if (this.codeStreamPos.size() == 0) {
            throw new Error("Invalid JP2 file: Contiguous codestream box missing");
        }
    }

    public boolean readFileTypeBox(int n, long l) throws IOException, EOFException {
        boolean bl = false;
        if (n == 1) {
            l = this.in.readLong();
            throw new IOException("File too long.");
        }
        if (this.in.readInt() != 1785737760) {
            return false;
        }
        int n2 = this.in.readInt();
        int n3 = (n - 16) / 4;
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = this.in.readInt();
            if (nArray[i] != 1785737760) continue;
            bl = true;
        }
        if (!bl) {
            return false;
        }
        if (this.metadata != null) {
            this.metadata.addNode(new FileTypeBox(1785737760, n2, nArray));
        }
        return true;
    }

    public boolean readJP2HeaderBox(int n) throws IOException, EOFException {
        if (n == 0) {
            throw new Error("Zero-length of JP2Header Box");
        }
        return true;
    }

    public boolean readImageHeaderBox(int n) throws IOException, EOFException {
        if (n == 0) {
            throw new Error("Zero-length of JP2Header Box");
        }
        this.height = this.in.readInt();
        this.width = this.in.readInt();
        this.numComp = this.in.readShort();
        this.bitDepth = this.in.readByte();
        this.compressionType = this.in.readByte();
        this.unknownColor = this.in.readByte();
        this.intelProp = this.in.readByte();
        if (this.metadata != null) {
            this.metadata.addNode(new HeaderBox(this.height, this.width, this.numComp, this.bitDepth, this.compressionType, this.unknownColor, this.intelProp));
        }
        return true;
    }

    public boolean readContiguousCodeStreamBox(int n, long l) throws IOException, EOFException {
        int n2 = this.in.getPos();
        if (this.codeStreamPos == null) {
            this.codeStreamPos = new Vector();
        }
        this.codeStreamPos.addElement(new Integer(n2));
        if (this.codeStreamLength == null) {
            this.codeStreamLength = new Vector();
        }
        this.codeStreamLength.addElement(new Integer(n));
        return true;
    }

    public void readIntPropertyBox(int n) throws IOException {
        if (this.metadata != null) {
            byte[] byArray = new byte[n];
            this.in.readFully(byArray, 0, n);
            this.metadata.addNode(new Box(n + 8, 1785737833, byArray));
        }
    }

    public void readXMLBox(int n) throws IOException {
        if (this.metadata != null) {
            byte[] byArray = new byte[n];
            this.in.readFully(byArray, 0, n);
            this.metadata.addNode(new XMLBox(byArray));
        }
    }

    public void readURLBox(int n) throws IOException {
        if (this.metadata != null) {
            byte[] byArray = new byte[n];
            this.in.readFully(byArray, 0, n);
            this.metadata.addNode(new DataEntryURLBox(byArray));
        }
    }

    public void readUUIDBox(int n) throws IOException {
        if (this.metadata != null) {
            byte[] byArray = new byte[n];
            this.in.readFully(byArray, 0, n);
            this.metadata.addNode(new UUIDBox(byArray));
        }
    }

    public void readUUIDListBox(int n) throws IOException {
        if (this.metadata != null) {
            byte[] byArray = new byte[n];
            this.in.readFully(byArray, 0, n);
            this.metadata.addNode(new UUIDListBox(byArray));
        }
    }

    public void readPaletteBox(int n) throws IOException {
        int n2;
        int n3 = this.in.getPos();
        short s = this.in.readShort();
        int n4 = this.in.readByte();
        this.compSize = new byte[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            this.compSize[n2] = this.in.readByte();
        }
        this.lut = new byte[n4][s];
        for (n2 = 0; n2 < s; ++n2) {
            for (int i = 0; i < n4; ++i) {
                int n5 = 1 + (this.compSize[i] & 0x7F);
                if (n5 > 32) {
                    n5 = 32;
                }
                int n6 = n5 + 7 >> 3;
                int n7 = (1 << n5) - 1;
                byte[] byArray = new byte[n6];
                this.in.readFully(byArray, 0, n6);
                int n8 = 0;
                for (int j = 0; j < n6; ++j) {
                    n8 = byArray[j] + (n8 << 8);
                }
                this.lut[i][n2] = (byte)n8;
            }
        }
        if (this.metadata != null) {
            this.metadata.addNode(new PaletteBox(n, this.compSize, this.lut));
        }
    }

    public void readComponentMappingBox(int n) throws IOException {
        int n2 = n / 4;
        this.comps = new short[n2];
        this.type = new byte[n2];
        this.maps = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            this.comps[i] = this.in.readShort();
            this.type[i] = this.in.readByte();
            this.maps[i] = this.in.readByte();
        }
        if (this.metadata != null) {
            this.metadata.addNode(new ComponentMappingBox(this.comps, this.type, this.maps));
        }
    }

    public void readChannelDefinitionBox(int n) throws IOException {
        int n2 = this.in.readShort();
        this.channels = new short[n2];
        this.cType = new short[n2];
        this.associations = new short[n2];
        for (int i = 0; i < n2; ++i) {
            this.channels[i] = this.in.readShort();
            this.cType[i] = this.in.readShort();
            this.associations[i] = this.in.readShort();
        }
        if (this.metadata != null) {
            this.metadata.addNode(new ChannelDefinitionBox(this.channels, this.cType, this.associations));
        }
    }

    public void readBitsPerComponentBox(int n) throws IOException {
        this.bitDepths = new byte[n];
        this.in.readFully(this.bitDepths, 0, n);
        if (this.metadata != null) {
            this.metadata.addNode(new BitsPerComponentBox(this.bitDepths));
        }
    }

    public void readColourSpecificationBox(int n) throws IOException {
        byte by = this.in.readByte();
        byte by2 = this.in.readByte();
        byte by3 = this.in.readByte();
        if (by == 2) {
            byte[] byArray = new byte[n - 3];
            this.in.readFully(byArray, 0, byArray.length);
            this.profile = ICC_Profile.getInstance(byArray);
        } else {
            this.colorSpaceType = this.in.readInt();
        }
        if (this.metadata != null) {
            this.metadata.addNode(new ColorSpecificationBox(by, by2, by3, this.colorSpaceType, this.profile));
        }
    }

    public void readResolutionBox(int n, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        this.in.readFully(byArray, 0, n2);
        if (this.metadata != null) {
            this.metadata.addNode(new ResolutionBox(n, byArray));
        }
    }

    public long[] getCodeStreamPos() {
        int n = this.codeStreamPos.size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = ((Integer)this.codeStreamPos.elementAt(i)).longValue();
        }
        return lArray;
    }

    public int getFirstCodeStreamPos() {
        return (Integer)this.codeStreamPos.elementAt(0);
    }

    public int getFirstCodeStreamLength() {
        return (Integer)this.codeStreamLength.elementAt(0);
    }

    public ColorModel getColorModel() {
        if (this.lut != null && this.numComp == 1) {
            int n = this.lut.length;
            int n2 = 1 + (this.bitDepth & 0x7F);
            if (this.maps == null) {
                this.maps = new byte[n];
                for (int i = 0; i < n; ++i) {
                    this.maps[i] = (byte)i;
                }
            }
            if (n == 3) {
                this.colorModel = new IndexColorModel(n2, this.lut[0].length, this.lut[this.maps[0]], this.lut[this.maps[1]], this.lut[this.maps[2]]);
            } else if (n == 4) {
                this.colorModel = new IndexColorModel(n2, this.lut[0].length, this.lut[this.maps[0]], this.lut[this.maps[1]], this.lut[this.maps[2]], this.lut[this.maps[3]]);
            }
        } else if (this.channels != null) {
            int n;
            boolean bl;
            int n3;
            boolean bl2 = false;
            int n4 = this.numComp - 1;
            for (int i = 0; i < this.channels.length; ++i) {
                if (this.cType[i] != 1 || this.channels[i] != n4) continue;
                bl2 = true;
            }
            boolean[] blArray = new boolean[]{false};
            if (bl2) {
                int n5;
                blArray = new boolean[n4];
                for (n5 = 0; n5 < n4; ++n5) {
                    blArray[n5] = false;
                }
                for (n5 = 0; n5 < this.channels.length; ++n5) {
                    if (this.cType[n5] != 2) continue;
                    blArray[this.associations[n5] - 1] = true;
                }
                for (n5 = 1; n5 < n4; ++n5) {
                    blArray[0] = blArray[0] & blArray[n5];
                }
            }
            ColorSpace colorSpace = null;
            if (this.profile != null) {
                colorSpace = new ICC_ColorSpace(this.profile);
            } else if (this.colorSpaceType == 16) {
                colorSpace = ColorSpace.getInstance(1000);
            } else if (this.colorSpaceType == 17) {
                colorSpace = ColorSpace.getInstance(1003);
            } else if (this.colorSpaceType == 18) {
                colorSpace = ColorSpace.getInstance(1002);
            }
            int[] nArray = new int[this.numComp];
            for (n3 = 0; n3 < this.numComp; ++n3) {
                nArray[n3] = this.bitDepths != null ? (this.bitDepths[n3] & 0x7F) + 1 : (this.bitDepth & 0x7F) + 1;
            }
            n3 = 1 + (this.bitDepth & 0x7F);
            boolean bl3 = bl = (this.bitDepth & 0x80) == 128;
            if (this.bitDepths != null) {
                boolean bl4 = bl = (this.bitDepths[0] & 0x80) == 128;
            }
            if (this.bitDepths != null) {
                for (n = 0; n < this.numComp; ++n) {
                    if (nArray[n] <= n3) continue;
                    n3 = nArray[n];
                }
            }
            n = -1;
            if (n3 <= 8) {
                n = 0;
            } else if (n3 <= 16) {
                n = bl ? 2 : 1;
            } else if (n3 <= 32) {
                n = 3;
            }
            if (n == -1) {
                return null;
            }
            if (colorSpace != null) {
                this.colorModel = new ComponentColorModel(colorSpace, nArray, bl2, blArray[0], bl2 ? 3 : 1, n);
            }
        }
        return this.colorModel;
    }
}

