/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.stream;

import com.sun.media.imageio.stream.FileChannelImageOutputStream;
import com.sun.media.imageioimpl.common.PackageUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.Locale;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.stream.FileCacheImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class ChannelImageOutputStreamSpi
extends ImageOutputStreamSpi {
    public ChannelImageOutputStreamSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), WritableByteChannel.class);
    }

    public ImageOutputStream createOutputStreamInstance(Object object, boolean bl, File file) throws IOException {
        Closeable closeable;
        if (object == null || !(object instanceof WritableByteChannel)) {
            throw new IllegalArgumentException("Cannot create ImageOutputStream from " + object.getClass().getName());
        }
        ImageOutputStreamImpl imageOutputStreamImpl = null;
        if (object instanceof FileChannel) {
            closeable = (FileChannel)object;
            try {
                ((FileChannel)closeable).map(FileChannel.MapMode.READ_ONLY, ((FileChannel)closeable).position(), 1L);
                imageOutputStreamImpl = new FileChannelImageOutputStream((FileChannel)object);
            }
            catch (NonReadableChannelException nonReadableChannelException) {
                // empty catch block
            }
        }
        if (imageOutputStreamImpl == null) {
            closeable = Channels.newOutputStream((WritableByteChannel)object);
            if (bl) {
                try {
                    imageOutputStreamImpl = new FileCacheImageOutputStream((OutputStream)closeable, file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (imageOutputStreamImpl == null) {
                imageOutputStreamImpl = new MemoryCacheImageOutputStream((OutputStream)closeable);
            }
        }
        return imageOutputStreamImpl;
    }

    public String getDescription(Locale locale) {
        return "NIO Channel ImageOutputStream";
    }
}

