/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import java.awt.image.ColorModel;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChannelDefinitionBox
extends Box {
    private short num;
    private short[] channels;
    private short[] types;
    private short[] associations;

    private static int computeLength(ColorModel colorModel) {
        int n = colorModel.getComponentSize().length - 1;
        return 10 + (colorModel.isAlphaPremultiplied() ? n * 18 : n * 12);
    }

    public static void fillBasedOnBands(int n, boolean bl, short[] sArray, short[] sArray2, short[] sArray3) {
        int n2;
        int n3 = n * (bl ? 3 : 2);
        if (bl) {
            for (n2 = n * 2; n2 < n3; ++n2) {
                sArray[n2] = (short)(n2 - n * 2);
                sArray2[n2] = 2;
                sArray3[n2] = (short)(n2 + 1 - n * 2);
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            int n4 = n2 + n;
            sArray[n2] = (short)n2;
            sArray2[n2] = 0;
            sArray3[n4] = sArray3[n2] = (short)(n2 + 1);
            sArray[n4] = (short)n;
            sArray2[n4] = 1;
        }
    }

    public ChannelDefinitionBox(ColorModel colorModel) {
        super(ChannelDefinitionBox.computeLength(colorModel), 1667523942, null);
        short s = (short)(colorModel.getComponentSize().length - 1);
        this.num = (short)(s * (colorModel.isAlphaPremultiplied() ? 3 : 2));
        this.channels = new short[this.num];
        this.types = new short[this.num];
        this.associations = new short[this.num];
        ChannelDefinitionBox.fillBasedOnBands(s, colorModel.isAlphaPremultiplied(), this.channels, this.types, this.associations);
    }

    public ChannelDefinitionBox(byte[] byArray) {
        super(8 + byArray.length, 1667523942, byArray);
    }

    public ChannelDefinitionBox(short[] sArray, short[] sArray2, short[] sArray3) {
        super(10 + sArray.length * 6, 1667523942, null);
        this.num = (short)sArray.length;
        this.channels = sArray;
        this.types = sArray2;
        this.associations = sArray3;
    }

    public ChannelDefinitionBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if ("NumberOfDefinition".equals(string)) {
                this.num = Box.getShortElementValue(node2);
            }
            if (!"Definitions".equals(string)) continue;
            this.channels = new short[this.num];
            this.types = new short[this.num];
            this.associations = new short[this.num];
            NodeList nodeList2 = node2.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                node2 = nodeList2.item(j);
                string = node2.getNodeName();
                if ("ChannelNumber".equals(string)) {
                    this.channels[n] = Box.getShortElementValue(node2);
                }
                if ("ChannelType".equals(string)) {
                    this.types[n] = Box.getShortElementValue(node2);
                }
                if (!"Association".equals(string)) continue;
                this.associations[n++] = Box.getShortElementValue(node2);
            }
        }
    }

    protected void parse(byte[] byArray) {
        this.num = (short)(byArray[0] << 8 | byArray[1]);
        this.channels = new short[this.num];
        this.types = new short[this.num];
        this.associations = new short[this.num];
        int n = 2;
        for (int i = 0; i < this.num; ++i) {
            this.channels[i] = (short)(((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF));
            this.types[i] = (short)(((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF));
            this.associations[i] = (short)(((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF));
        }
    }

    public short[] getChannel() {
        return this.channels;
    }

    public short[] getTypes() {
        return this.types;
    }

    public short[] getAssociation() {
        return this.associations;
    }

    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("NumberOfDefinition");
        iIOMetadataNode2.setUserObject(new Short(this.num));
        iIOMetadataNode2.setNodeValue("" + this.num);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("Definitions");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        for (int i = 0; i < this.num; ++i) {
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("ChannelNumber");
            iIOMetadataNode3.setUserObject(new Short(this.channels[i]));
            iIOMetadataNode3.setNodeValue("" + this.channels[i]);
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode3 = new IIOMetadataNode("ChannelType");
            iIOMetadataNode3.setUserObject(new Short(this.types[i]));
            iIOMetadataNode3.setNodeValue("" + this.types[i]);
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode3 = new IIOMetadataNode("Association");
            iIOMetadataNode3.setUserObject(new Short(this.associations[i]));
            iIOMetadataNode3.setNodeValue("" + this.associations[i]);
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        }
        return iIOMetadataNode;
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        int n = this.num * 6 + 2;
        this.data = new byte[n];
        this.data[0] = (byte)(this.num >> 8);
        this.data[1] = (byte)(this.num & 0xFF);
        int n2 = 2;
        for (int i = 0; i < this.num; ++i) {
            this.data[n2++] = (byte)(this.channels[i] >> 8);
            this.data[n2++] = (byte)(this.channels[i] & 0xFF);
            this.data[n2++] = (byte)(this.types[i] >> 8);
            this.data[n2++] = (byte)(this.types[i] & 0xFF);
            this.data[n2++] = (byte)(this.associations[i] >> 8);
            this.data[n2++] = (byte)(this.associations[i] & 0xFF);
        }
    }
}

