/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.clib.CLibImageWriter;
import com.sun.media.imageioimpl.plugins.clib.OutputStreamAdapter;
import com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriteParam;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.jpeg.Encoder;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

final class CLibJPEGImageWriter
extends CLibImageWriter {
    private Encoder encoder;

    private static BufferedImage convertTo3BandRGB(RenderedImage renderedImage) {
        BufferedImage bufferedImage;
        Raster raster;
        if (renderedImage == null) {
            throw new IllegalArgumentException("im == null");
        }
        ColorModel colorModel = renderedImage.getColorModel();
        if (!(colorModel instanceof IndexColorModel)) {
            throw new IllegalArgumentException("!(im.getColorModel() instanceof IndexColorModel)");
        }
        if (renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1) {
            raster = renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY());
            if (raster.getWidth() != renderedImage.getWidth() || raster.getHeight() != renderedImage.getHeight()) {
                raster = raster.createChild(raster.getMinX(), raster.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), raster.getMinX(), raster.getMinY(), null);
            }
        } else {
            raster = renderedImage.getData();
        }
        if ((bufferedImage = ((IndexColorModel)colorModel).convertToIntDiscrete(raster, false)).getSampleModel().getNumBands() == 4) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            WritableRaster writableRaster2 = writableRaster.createWritableChild(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, new int[]{0, 1, 2});
            PackedColorModel packedColorModel = (PackedColorModel)bufferedImage.getColorModel();
            int n = packedColorModel.getComponentSize(0) + packedColorModel.getComponentSize(1) + packedColorModel.getComponentSize(2);
            DirectColorModel directColorModel = new DirectColorModel(n, packedColorModel.getMask(0), packedColorModel.getMask(1), packedColorModel.getMask(2));
            bufferedImage = new BufferedImage(directColorModel, writableRaster2, false, null);
        }
        return bufferedImage;
    }

    CLibJPEGImageWriter(ImageWriterSpi imageWriterSpi) throws IOException {
        super(imageWriterSpi);
        try {
            this.encoder = new Encoder();
            this.encoder.setExtend(0);
        }
        catch (Throwable throwable) {
            throw new IIOException("codecLib error", throwable);
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new CLibJPEGImageWriteParam(this.getLocale());
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        int[] nArray;
        if (this.output == null) {
            throw new IllegalStateException("output == null");
        }
        OutputStreamAdapter outputStreamAdapter = null;
        if (!(this.output instanceof ImageOutputStream)) {
            throw new IllegalArgumentException("!(output instanceof ImageOutputStream)");
        }
        outputStreamAdapter = new OutputStreamAdapter((ImageOutputStream)this.output);
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        if (renderedImage.getColorModel() instanceof IndexColorModel) {
            renderedImage = CLibJPEGImageWriter.convertTo3BandRGB(renderedImage);
        }
        ImageUtil.canEncodeImage(this, renderedImage.getColorModel(), renderedImage.getSampleModel());
        int n = renderedImage.getColorModel().getComponentSize(0);
        if ((imageWriteParam == null || imageWriteParam.getCompressionMode() == 2 && !imageWriteParam.isCompressionLossless()) && n > 12) {
            throw new IIOException("JPEG baseline encoding is limited to 12 bits: " + this);
        }
        if (imageWriteParam != null && imageWriteParam.getCompressionMode() == 2) {
            if (imageWriteParam.isCompressionLossless()) {
                try {
                    if (n >= 2 && n <= 16 && n % 8 != 0) {
                        this.encoder.setDepth(n);
                    }
                    if (imageWriteParam.getCompressionType().equalsIgnoreCase("JPEG-LOSSLESS")) {
                        this.encoder.setMode(1);
                    }
                    this.encoder.setMode(2);
                }
                catch (Throwable throwable) {
                    throw new IIOException("codecLib error", throwable);
                }
            } else {
                try {
                    this.encoder.setMode(0);
                    this.encoder.setQuality((int)(imageWriteParam.getCompressionQuality() * 100.0f));
                }
                catch (Throwable throwable) {
                    throw new IIOException("codecLib error", throwable);
                }
            }
        } else {
            try {
                this.encoder.setMode(0);
                this.encoder.setQuality(75);
            }
            catch (Throwable throwable) {
                throw new IIOException("codecLib error", throwable);
            }
        }
        if (imageWriteParam == null || imageWriteParam.getCompressionMode() == 2 && !imageWriteParam.isCompressionLossless()) {
            int[] nArray2 = new int[5];
            nArray2[0] = 2;
            nArray2[1] = 9;
            nArray2[2] = 4;
            nArray2[3] = 3;
            nArray = nArray2;
            nArray2[4] = 11;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 2;
            nArray = nArray3;
            nArray3[1] = 3;
        }
        int[] nArray4 = nArray;
        mediaLibImage mediaLibImage2 = this.getMediaLibImage(renderedImage, imageWriteParam, false, nArray4);
        try {
            if (mediaLibImage2.getChannels() == 2) {
                this.encoder.setType(2);
            } else if (mediaLibImage2.getChannels() == 4) {
                if (mediaLibImage2.getFormat() == 11) {
                    this.encoder.setType(11);
                } else if (mediaLibImage2.getFormat() == 14) {
                    this.encoder.setType(14);
                }
            }
            this.encoder.encode((OutputStream)outputStreamAdapter, mediaLibImage2);
        }
        catch (Throwable throwable) {
            throw new IIOException("codecLib error", throwable);
        }
    }
}

