/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.jpeg2000;

import java.util.Locale;
import javax.imageio.ImageWriteParam;

public class J2KImageWriteParam
extends ImageWriteParam {
    public static final String FILTER_97 = "w9x7";
    public static final String FILTER_53 = "w5x3";
    private int numDecompositionLevels = 5;
    private double encodingRate = Double.MAX_VALUE;
    private boolean lossless = true;
    private boolean componentTransformation = true;
    private String filter = "w5x3";
    private int[] codeBlockSize = new int[]{64, 64};
    private String progressionType = "layer";
    private boolean EPH = false;
    private boolean SOP = false;
    private boolean writeCodeStreamOnly = false;

    public J2KImageWriteParam(Locale locale) {
        super(locale);
        this.setDefaults();
    }

    public J2KImageWriteParam() {
        this.setDefaults();
    }

    private void setDefaults() {
        this.canOffsetTiles = true;
        this.canWriteTiles = true;
        this.canOffsetTiles = true;
        this.compressionTypes = new String[]{"JPEG2000"};
        this.canWriteCompressed = true;
        this.tilingMode = 2;
    }

    public void setNumDecompositionLevels(int n) {
        if (n < 0 || n > 32) {
            throw new IllegalArgumentException("numDecompositionLevels < 0 || numDecompositionLevels > 32");
        }
        this.numDecompositionLevels = n;
    }

    public int getNumDecompositionLevels() {
        return this.numDecompositionLevels;
    }

    public void setEncodingRate(double d) {
        this.encodingRate = d;
        if (this.encodingRate != Double.MAX_VALUE) {
            this.lossless = false;
            this.filter = FILTER_97;
        } else {
            this.lossless = true;
            this.filter = FILTER_53;
        }
    }

    public double getEncodingRate() {
        return this.encodingRate;
    }

    public void setLossless(boolean bl) {
        this.lossless = bl;
    }

    public boolean getLossless() {
        return this.lossless;
    }

    public void setFilter(String string) {
        this.filter = string;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setComponentTransformation(boolean bl) {
        this.componentTransformation = bl;
    }

    public boolean getComponentTransformation() {
        return this.componentTransformation;
    }

    public void setCodeBlockSize(int[] nArray) {
        this.codeBlockSize = nArray;
    }

    public int[] getCodeBlockSize() {
        return this.codeBlockSize;
    }

    public void setSOP(boolean bl) {
        this.SOP = bl;
    }

    public boolean getSOP() {
        return this.SOP;
    }

    public void setEPH(boolean bl) {
        this.EPH = bl;
    }

    public boolean getEPH() {
        return this.EPH;
    }

    public void setProgressionType(String string) {
        this.progressionType = string;
    }

    public String getProgressionType() {
        return this.progressionType;
    }

    public void setWriteCodeStreamOnly(boolean bl) {
        this.writeCodeStreamOnly = bl;
    }

    public boolean getWriteCodeStreamOnly() {
        return this.writeCodeStreamOnly;
    }
}

