/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.JaiI18N;
import java.awt.image.DataBuffer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public final class DataBufferUtils {
    private static final String[] FLOAT_CLASS_NAMES = new String[]{"java.awt.image.DataBufferFloat", "javax.media.jai.DataBufferFloat", "com.sun.media.jai.codecimpl.util.DataBufferFloat"};
    private static final String[] DOUBLE_CLASS_NAMES = new String[]{"java.awt.image.DataBufferDouble", "javax.media.jai.DataBufferDouble", "com.sun.media.jai.codecimpl.util.DataBufferDouble"};
    static /* synthetic */ Class array$$F;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$$D;
    static /* synthetic */ Class array$D;

    private static final Class getDataBufferClass(int n) {
        String[] stringArray = null;
        switch (n) {
            case 4: {
                stringArray = FLOAT_CLASS_NAMES;
                break;
            }
            case 5: {
                stringArray = DOUBLE_CLASS_NAMES;
                break;
            }
            default: {
                throw new IllegalArgumentException("dataType == " + n + "!");
            }
        }
        Class<?> clazz = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                clazz = Class.forName(stringArray[n2]);
                if (clazz != null) {
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ++n2;
        }
        if (clazz == null) {
            throw new RuntimeException(JaiI18N.getString("DataBufferUtils0") + " " + (n == 4 ? "DataBufferFloat" : "DataBufferDouble"));
        }
        return clazz;
    }

    private static final DataBuffer constructDataBuffer(int n, Class[] classArray, Object[] objectArray) {
        DataBuffer dataBuffer = null;
        Class clazz = DataBufferUtils.getDataBufferClass(n);
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            dataBuffer = (DataBuffer)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(JaiI18N.getString("DataBufferUtils1"));
        }
        return dataBuffer;
    }

    private static final Object invokeDataBufferMethod(DataBuffer dataBuffer, String string, Class[] classArray, Object[] objectArray) {
        if (dataBuffer == null) {
            throw new IllegalArgumentException("dataBuffer == null!");
        }
        Class clazz = DataBufferUtils.getDataBufferClass(dataBuffer.getDataType());
        Object object = null;
        try {
            Method method = clazz.getMethod(string, classArray);
            object = method.invoke((Object)dataBuffer, objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(JaiI18N.getString("DataBufferUtils2") + " \"" + string + "\".");
        }
        return object;
    }

    public static final DataBuffer createDataBufferFloat(float[][] fArray, int n) {
        return DataBufferUtils.constructDataBuffer(4, new Class[]{array$$F == null ? (array$$F = DataBufferUtils.class$("[[F")) : array$$F, Integer.TYPE}, new Object[]{fArray, new Integer(n)});
    }

    public static final DataBuffer createDataBufferFloat(float[][] fArray, int n, int[] nArray) {
        return DataBufferUtils.constructDataBuffer(4, new Class[]{array$$F == null ? (array$$F = DataBufferUtils.class$("[[F")) : array$$F, Integer.TYPE, array$I == null ? (array$I = DataBufferUtils.class$("[I")) : array$I}, new Object[]{fArray, new Integer(n), nArray});
    }

    public static final DataBuffer createDataBufferFloat(float[] fArray, int n) {
        return DataBufferUtils.constructDataBuffer(4, new Class[]{array$F == null ? (array$F = DataBufferUtils.class$("[F")) : array$F, Integer.TYPE}, new Object[]{fArray, new Integer(n)});
    }

    public static final DataBuffer createDataBufferFloat(float[] fArray, int n, int n2) {
        return DataBufferUtils.constructDataBuffer(4, new Class[]{array$F == null ? (array$F = DataBufferUtils.class$("[F")) : array$F, Integer.TYPE, Integer.TYPE}, new Object[]{fArray, new Integer(n), new Integer(n2)});
    }

    public static final DataBuffer createDataBufferFloat(int n) {
        return DataBufferUtils.constructDataBuffer(4, new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public static final DataBuffer createDataBufferFloat(int n, int n2) {
        return DataBufferUtils.constructDataBuffer(4, new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2)});
    }

    public static final float[][] getBankDataFloat(DataBuffer dataBuffer) {
        return (float[][])DataBufferUtils.invokeDataBufferMethod(dataBuffer, "getBankData", null, null);
    }

    public static final float[] getDataFloat(DataBuffer dataBuffer) {
        return (float[])DataBufferUtils.invokeDataBufferMethod(dataBuffer, "getData", null, null);
    }

    public static final float[] getDataFloat(DataBuffer dataBuffer, int n) {
        return (float[])DataBufferUtils.invokeDataBufferMethod(dataBuffer, "getData", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public static final DataBuffer createDataBufferDouble(double[][] dArray, int n) {
        return DataBufferUtils.constructDataBuffer(5, new Class[]{array$$D == null ? (array$$D = DataBufferUtils.class$("[[D")) : array$$D, Integer.TYPE}, new Object[]{dArray, new Integer(n)});
    }

    public static final DataBuffer createDataBufferDouble(double[][] dArray, int n, int[] nArray) {
        return DataBufferUtils.constructDataBuffer(5, new Class[]{array$$D == null ? (array$$D = DataBufferUtils.class$("[[D")) : array$$D, Integer.TYPE, array$I == null ? (array$I = DataBufferUtils.class$("[I")) : array$I}, new Object[]{dArray, new Integer(n), nArray});
    }

    public static final DataBuffer createDataBufferDouble(double[] dArray, int n) {
        return DataBufferUtils.constructDataBuffer(5, new Class[]{array$D == null ? (array$D = DataBufferUtils.class$("[D")) : array$D, Integer.TYPE}, new Object[]{dArray, new Integer(n)});
    }

    public static final DataBuffer createDataBufferDouble(double[] dArray, int n, int n2) {
        return DataBufferUtils.constructDataBuffer(5, new Class[]{array$D == null ? (array$D = DataBufferUtils.class$("[D")) : array$D, Integer.TYPE, Integer.TYPE}, new Object[]{dArray, new Integer(n), new Integer(n2)});
    }

    public static final DataBuffer createDataBufferDouble(int n) {
        return DataBufferUtils.constructDataBuffer(5, new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public static final DataBuffer createDataBufferDouble(int n, int n2) {
        return DataBufferUtils.constructDataBuffer(5, new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2)});
    }

    public static final double[][] getBankDataDouble(DataBuffer dataBuffer) {
        return (double[][])DataBufferUtils.invokeDataBufferMethod(dataBuffer, "getBankData", null, null);
    }

    public static final double[] getDataDouble(DataBuffer dataBuffer) {
        return (double[])DataBufferUtils.invokeDataBufferMethod(dataBuffer, "getData", null, null);
    }

    public static final double[] getDataDouble(DataBuffer dataBuffer, int n) {
        return (double[])DataBufferUtils.invokeDataBufferMethod(dataBuffer, "getData", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

